/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.gflogger.AbstractBufferLocalLogEntry;
import org.gflogger.GFLogEntry;
import org.gflogger.LoggerService;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.formatter.BufferFormatter;

public final class CharBufferLocalLogEntry
extends AbstractBufferLocalLogEntry {
    private final CharBuffer buffer;

    public CharBufferLocalLogEntry(int maxMessageSize, ObjectFormatterFactory formatterFactory, LoggerService loggerService) {
        this(Thread.currentThread(), maxMessageSize, formatterFactory, loggerService);
    }

    public CharBufferLocalLogEntry(Thread owner, int maxMessageSize, ObjectFormatterFactory formatterFactory, LoggerService loggerService) {
        this(owner, BufferFormatter.allocate(maxMessageSize), formatterFactory, loggerService);
    }

    public CharBufferLocalLogEntry(Thread owner, ByteBuffer byteBuffer, ObjectFormatterFactory formatterFactory, LoggerService loggerService) {
        super(owner, formatterFactory, loggerService, byteBuffer);
        this.buffer = byteBuffer.asCharBuffer();
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public <T extends Buffer> void copyTo(T buffer) {
        buffer.clear();
        ((CharBuffer)buffer).put(this.buffer);
    }

    @Override
    protected void moveAndAppendSilent(String message) {
        int length = message.length();
        int remaining = this.buffer.remaining();
        if (remaining < length) {
            this.buffer.position(this.buffer.position() - (length - remaining));
        }
        try {
            BufferFormatter.append(this.buffer, (CharSequence)message);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    @Override
    public CharBufferLocalLogEntry append(char c) {
        this.checkIfCommitted();
        try {
            this.buffer.append(c);
        }
        catch (Throwable e) {
            this.error("append(char c)", e);
        }
        return this;
    }

    @Override
    public CharBufferLocalLogEntry append(CharSequence csq) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.buffer, csq);
        }
        catch (Throwable e) {
            this.error("append(CharSequence csq)", e);
        }
        return this;
    }

    @Override
    public CharBufferLocalLogEntry append(CharSequence csq, int start, int end) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.buffer, csq, start, end);
        }
        catch (Throwable e) {
            this.error("append(CharSequence csq, int start, int end)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(boolean b) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.buffer, b);
        }
        catch (Throwable e) {
            this.error("append(boolean b)", e);
        }
        return this;
    }

    @Override
    public CharBufferLocalLogEntry append(int i) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.buffer, i);
        }
        catch (Throwable e) {
            this.error("append(int i)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(long i) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.buffer, i);
        }
        catch (Throwable e) {
            this.error("append(long i)", e);
        }
        return this;
    }

    @Override
    public GFLogEntry append(double i, int precision) {
        this.checkIfCommitted();
        try {
            BufferFormatter.append(this.buffer, i, precision);
        }
        catch (Throwable e) {
            this.error("append(double i, int precision)", e);
        }
        return this;
    }

    @Override
    protected void commit0() {
        this.buffer.flip();
    }

    @Override
    public String stringValue() {
        int pos = this.buffer.position();
        int limit = this.buffer.limit();
        this.buffer.flip();
        char[] bs = new char[pos];
        this.buffer.get(bs);
        this.buffer.position(pos);
        this.buffer.limit(limit);
        return new String(bs);
    }

    public String toString() {
        return "[local of " + this.threadName + " " + (Object)((Object)this.logLevel) + " pos:" + this.byteBuffer.position() + " limit:" + this.byteBuffer.limit() + " capacity:" + this.byteBuffer.capacity() + "]";
    }
}

