/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.util.Map;
import org.gflogger.DefaultObjectFormatter;
import org.gflogger.ObjectFormatter;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.TypeEntityRegistry;

public final class DefaultObjectFormatterFactory
implements ObjectFormatterFactory {
    private final TypeEntityRegistry<ObjectFormatter> formatters = new TypeEntityRegistry<ObjectFormatter<Object>>(DefaultObjectFormatter.DEFAULT_OBJECT_FORMATTER);

    public <T> void registerObjectFormatter(Class<T> clazz, ObjectFormatter<T> formatter) {
        this.formatters.register(clazz, formatter);
    }

    public void setExtraObjectFormatters(Map<Class, ObjectFormatter> formatters) {
        for (Map.Entry<Class, ObjectFormatter> entry : formatters.entrySet()) {
            this.registerObjectFormatter(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public ObjectFormatter getObjectFormatter(Object obj) {
        if (obj == null) {
            return DefaultObjectFormatter.DEFAULT_OBJECT_FORMATTER;
        }
        Class<?> type = obj.getClass();
        return this.formatters.forType(type);
    }
}

