/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.gflogger.GFLog;
import org.gflogger.GFLogView;
import org.gflogger.LoggerService;
import org.gflogger.helpers.LogLog;

public final class GFLogFactory {
    private final Object lock = new Object();
    private final AtomicReference<LoggerService> loggerService = new AtomicReference();
    private final Map<String, GFLogView> namedLogger = new HashMap<String, GFLogView>();
    private final Map<Class, GFLogView> classedLogger = new HashMap<Class, GFLogView>();

    private GFLogFactory() {
        String ver = GFLogFactory.class.getPackage().getImplementationVersion();
        LogLog.info(" version " + (ver != null ? ver : "*dev*"));
    }

    private GFLog get(String name) {
        return this.get0(name, name, this.namedLogger);
    }

    private GFLog get(Class clazz) {
        return this.get0(clazz, clazz.getName(), this.classedLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> GFLog get0(T key, String name, Map<T, GFLogView> map) {
        GFLogView logger = map.get(key);
        if (logger != null) {
            return logger;
        }
        Object object = this.lock;
        synchronized (object) {
            logger = map.get(name);
            if (logger != null) {
                return logger;
            }
            logger = new GFLogView(name);
            LoggerService service = this.getService();
            logger.setLoggerService(service);
            map.put(key, logger);
            return logger;
        }
    }

    public static LoggerService lookupService(String name) {
        return Helper.FACTORY.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerService getService() {
        Object object = this.lock;
        synchronized (object) {
            return this.loggerService.get();
        }
    }

    public static GFLog getLog(String name) {
        return Helper.FACTORY.get(name);
    }

    public static GFLog getLog(Class clazz) {
        return Helper.FACTORY.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Object object = Helper.FACTORY.lock;
        synchronized (object) {
            LoggerService service = Helper.FACTORY.loggerService.getAndSet(null);
            if (service == null) {
                return;
            }
            service.stop();
            for (GFLogView loggerView : Helper.FACTORY.namedLogger.values()) {
                loggerView.invalidate();
            }
            for (GFLogView loggerView : Helper.FACTORY.classedLogger.values()) {
                loggerView.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GFLogFactory init(LoggerService service) {
        Object object = Helper.FACTORY.lock;
        synchronized (object) {
            GFLogFactory.stop();
            if (service == null) {
                throw new IllegalArgumentException("Not a null logger service is expected");
            }
            Helper.FACTORY.loggerService.set(service);
        }
        return Helper.FACTORY;
    }

    private static final class Helper {
        static final GFLogFactory FACTORY = new GFLogFactory();

        private Helper() {
        }
    }
}

