/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import org.gflogger.FormattedGFLogEntry;
import org.gflogger.GFLog;
import org.gflogger.GFLogEntry;
import org.gflogger.GFLogFactory;
import org.gflogger.GFLogger;
import org.gflogger.LogLevel;
import org.gflogger.LoggerService;
import org.gflogger.NullLogEntry;

public class GFLogView
implements GFLog {
    private LoggerService loggerService;
    private LogLevel level;
    private volatile boolean valid;
    private final long[] appenderMask = new long[LogLevel.values.length];
    private final NullLogEntry mockLogEntry = NullLogEntry.INSTANCE;
    private final String name;

    public GFLogView(String name) {
        this.name = name;
    }

    void invalidate() {
        this.loggerService = null;
        this.level = null;
        this.valid = false;
    }

    LoggerService setLoggerService(LoggerService loggerService) {
        this.loggerService = loggerService;
        GFLogger[] loggers = loggerService != null ? loggerService.lookupLoggers(this.name) : GFLogger.EMPTY;
        block0: for (int i = 0; i < LogLevel.values.length; ++i) {
            LogLevel level = LogLevel.values[i];
            int ordinal = level.ordinal();
            this.appenderMask[ordinal] = 0L;
            for (GFLogger gfLogger : loggers) {
                LogLevel loggerLevel = gfLogger.getLogLevel();
                if (loggerLevel.greaterThan(level)) continue;
                long m = gfLogger.getAppenderMask(level);
                int n = ordinal;
                this.appenderMask[n] = this.appenderMask[n] | m;
                if (!gfLogger.hasAdditivity()) continue block0;
            }
        }
        this.level = LogLevel.FATAL;
        for (GFLogger gfLogger : loggers) {
            LogLevel loggerLevel = gfLogger.getLogLevel();
            this.level = !this.level.greaterThan(loggerLevel) ? this.level : loggerLevel;
        }
        this.valid = loggerService != null;
        return this.loggerService;
    }

    private boolean hasNecessaryLevel(LogLevel level) {
        return this.loggerService() != null && !this.level.greaterThan(level);
    }

    private LoggerService loggerService() {
        if (this.valid) {
            return this.loggerService;
        }
        return this.setLoggerService(GFLogFactory.lookupService(this.name));
    }

    private GFLogEntry logEntry(LogLevel logLevel) {
        return this.hasNecessaryLevel(logLevel) ? this.loggerService.log(logLevel, this.name, this.appenderMask[logLevel.ordinal()]) : this.mockLogEntry;
    }

    private FormattedGFLogEntry formattedLogEntry(LogLevel logLevel, String pattern) {
        return this.hasNecessaryLevel(logLevel) ? this.loggerService.formattedLog(logLevel, this.name, pattern, this.appenderMask[logLevel.ordinal()]) : this.mockLogEntry;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.hasNecessaryLevel(LogLevel.TRACE);
    }

    @Override
    public GFLogEntry trace() {
        return this.logEntry(LogLevel.TRACE);
    }

    @Override
    public FormattedGFLogEntry trace(String pattern) {
        return this.formattedLogEntry(LogLevel.TRACE, pattern);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.hasNecessaryLevel(LogLevel.DEBUG);
    }

    @Override
    public GFLogEntry debug() {
        return this.logEntry(LogLevel.DEBUG);
    }

    @Override
    public FormattedGFLogEntry debug(String pattern) {
        return this.formattedLogEntry(LogLevel.DEBUG, pattern);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.hasNecessaryLevel(LogLevel.INFO);
    }

    @Override
    public GFLogEntry info() {
        return this.logEntry(LogLevel.INFO);
    }

    @Override
    public FormattedGFLogEntry info(String pattern) {
        return this.formattedLogEntry(LogLevel.INFO, pattern);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.hasNecessaryLevel(LogLevel.WARN);
    }

    @Override
    public GFLogEntry warn() {
        return this.logEntry(LogLevel.WARN);
    }

    @Override
    public FormattedGFLogEntry warn(String pattern) {
        return this.formattedLogEntry(LogLevel.WARN, pattern);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.hasNecessaryLevel(LogLevel.ERROR);
    }

    @Override
    public GFLogEntry error() {
        return this.logEntry(LogLevel.ERROR);
    }

    @Override
    public FormattedGFLogEntry error(String pattern) {
        return this.formattedLogEntry(LogLevel.ERROR, pattern);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.hasNecessaryLevel(LogLevel.ERROR);
    }

    @Override
    public GFLogEntry fatal() {
        return this.logEntry(LogLevel.FATAL);
    }

    @Override
    public FormattedGFLogEntry fatal(String pattern) {
        return this.formattedLogEntry(LogLevel.FATAL, pattern);
    }
}

