/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gflogger.GFLogger;
import org.gflogger.LogLevel;
import org.gflogger.appender.AppenderFactory;

public final class GFLoggerBuilder {
    private LogLevel logLevel;
    private String name;
    private boolean additivity;
    private final List<AppenderFactory> factories;

    public GFLoggerBuilder() {
        this(LogLevel.FATAL, null, false, new AppenderFactory[0]);
    }

    public GFLoggerBuilder(AppenderFactory factory) {
        this(factory.getLogLevel(), null, false, factory);
    }

    public GFLoggerBuilder(String category, AppenderFactory factory) {
        this(factory.getLogLevel(), category, false, factory);
    }

    public GFLoggerBuilder(LogLevel logLevel, String category, AppenderFactory ... appenderFactories) {
        this(logLevel, category, false, appenderFactories);
    }

    public GFLoggerBuilder(LogLevel logLevel, String category, boolean additivity, AppenderFactory ... appenderFactories) {
        this.logLevel = logLevel;
        this.name = category;
        this.additivity = additivity;
        this.factories = new ArrayList<AppenderFactory>(Arrays.asList(appenderFactories));
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String category) {
        this.name = category;
    }

    public boolean isAdditivity() {
        return this.additivity;
    }

    public void setAdditivity(boolean additivity) {
        this.additivity = additivity;
    }

    public void setAppenderFactory(AppenderFactory appender) {
        this.factories.clear();
        if (appender != null) {
            this.factories.add(appender);
        }
    }

    public void setAppenderFactories(Collection<AppenderFactory> appenders) {
        this.factories.clear();
        if (appenders != null) {
            this.factories.addAll(appenders);
        }
    }

    public void addAppenderFactory(AppenderFactory appender) {
        this.factories.add(appender);
    }

    public void removeAppenderFactory(AppenderFactory appender) {
        this.factories.remove(appender);
    }

    public GFLogger build() {
        return new GFLoggerFinal(this.logLevel, this.name, this.additivity, this.factories.toArray(new AppenderFactory[this.factories.size()]));
    }

    public String toString() {
        return "GFLoggerBuilder [logLevel:" + (Object)((Object)this.logLevel) + ", category:" + this.name + ", additivity=" + this.additivity + "]";
    }

    private static final class GFLoggerFinal
    implements GFLogger {
        private final LogLevel logLevel;
        private final String category;
        private final long mask;
        private final boolean additivity;

        public GFLoggerFinal(LogLevel logLevel, String category, boolean additivity, AppenderFactory ... appenderFactories) {
            this(logLevel, category, additivity, GFLoggerFinal.mask(appenderFactories));
        }

        private GFLoggerFinal(LogLevel logLevel, String category, boolean additivity, long mask) {
            this.logLevel = logLevel;
            this.category = category;
            this.additivity = additivity;
            this.mask = mask;
        }

        private static long mask(AppenderFactory ... appenderFactories) {
            long mask = 0L;
            for (AppenderFactory appenderFactory : appenderFactories) {
                int idx = appenderFactory.getIndex();
                if (idx < 0) {
                    throw new IllegalArgumentException("Negative indeces are not supported.");
                }
                if (idx >= 64) {
                    throw new IllegalArgumentException("Index " + idx + " is too large. Max value:" + 63);
                }
                int appenderMask = 1 << idx;
                if ((mask & (long)appenderMask) != 0L) {
                    throw new IllegalArgumentException("Duplicate index " + idx);
                }
                mask |= (long)appenderMask;
            }
            return mask;
        }

        @Override
        public LogLevel getLogLevel() {
            return this.logLevel;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public boolean hasAdditivity() {
            return this.additivity;
        }

        @Override
        public long getAppenderMask(LogLevel level) {
            return !this.logLevel.greaterThan(level) ? this.mask : 0L;
        }

        public String toString() {
            return "GFLoggerImpl [logLevel:" + (Object)((Object)this.logLevel) + ", category:" + this.category + ", additivity=" + this.additivity + "]";
        }
    }
}

