/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.gflogger.AbstractLocalLogEntry;
import org.gflogger.LogEntryItem;
import org.gflogger.LogLevel;
import org.gflogger.LoggerService;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.formatter.BufferFormatter;
import org.gflogger.ring.Publishable;

public final class LogEntryItemImpl
extends AbstractLocalLogEntry
implements LogEntryItem,
Publishable {
    private final ByteBuffer buffer;
    private final CharBuffer charBuffer;
    private volatile boolean published;
    private String categoryName;
    private LogLevel logLevel;
    private long timestamp;
    private String threadName;
    private long appenderMask;
    private long sequence;

    public LogEntryItemImpl(int size) {
        this(size, false);
    }

    public LogEntryItemImpl(int size, boolean multibyte) {
        this(BufferFormatter.allocate(size), multibyte);
    }

    public LogEntryItemImpl(ByteBuffer buffer, boolean multibyte) {
        this(null, null, buffer, multibyte);
    }

    public LogEntryItemImpl(ObjectFormatterFactory formatterFactory, LoggerService loggerService, ByteBuffer buffer, boolean multibyte) {
        super(formatterFactory, loggerService, null);
        this.buffer = buffer;
        this.charBuffer = multibyte ? buffer.asCharBuffer() : null;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public CharBuffer getCharBuffer() {
        return this.charBuffer;
    }

    @Override
    public void setCategoryName(String name) {
        this.categoryName = name;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    @Override
    public long getAppenderMask() {
        return this.appenderMask;
    }

    @Override
    public void setAppenderMask(long appenderMask) {
        this.appenderMask = appenderMask;
    }

    @Override
    public boolean isPublished() {
        return this.published;
    }

    @Override
    public void setPublished(boolean published) {
        this.published = published;
    }

    @Override
    public void clear() {
        this.buffer.clear();
    }

    @Override
    public <T extends Buffer> void copyTo(T buffer) {
        buffer.clear();
        ((ByteBuffer)buffer).put(this.buffer);
    }

    @Override
    protected void moveAndAppendSilent(String message) {
        int length = message.length();
        int remaining = this.buffer.remaining();
        if (remaining < length) {
            this.buffer.position(this.buffer.position() - (length - remaining));
        }
        try {
            BufferFormatter.append(this.buffer, (CharSequence)message);
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    @Override
    public LogEntryItemImpl append(char c) {
        try {
            BufferFormatter.append(this.buffer, c);
        }
        catch (Throwable e) {
            this.error("append(char c)", e);
        }
        return this;
    }

    @Override
    public LogEntryItemImpl append(CharSequence csq) {
        try {
            BufferFormatter.append(this.buffer, csq);
        }
        catch (Throwable e) {
            this.error("append(CharSequence csq)", e);
        }
        return this;
    }

    @Override
    public LogEntryItemImpl append(CharSequence csq, int start, int end) {
        try {
            BufferFormatter.append(this.buffer, csq, start, end);
        }
        catch (Throwable e) {
            this.error("append(CharSequence csq, int start, int end)", e);
        }
        return this;
    }

    @Override
    public LogEntryItemImpl append(boolean b) {
        try {
            BufferFormatter.append(this.buffer, b);
        }
        catch (Throwable e) {
            this.error("append(boolean b)", e);
        }
        return this;
    }

    @Override
    public LogEntryItemImpl append(int i) {
        try {
            BufferFormatter.append(this.buffer, i);
        }
        catch (Throwable e) {
            this.error("append(int i)", e);
        }
        return this;
    }

    @Override
    public LogEntryItemImpl append(long i) {
        try {
            BufferFormatter.append(this.buffer, i);
        }
        catch (Throwable e) {
            this.error("append(long i)", e);
        }
        return this;
    }

    @Override
    public LogEntryItemImpl append(double i, int precision) {
        try {
            BufferFormatter.append(this.buffer, i, precision);
        }
        catch (Throwable e) {
            this.error("append(double i, int precision)", e);
        }
        return this;
    }

    @Override
    protected void commit0() {
        this.buffer.flip();
        this.loggerService.entryFlushed(this);
    }

    @Override
    public String stringValue() {
        int pos = this.buffer.position();
        int limit = this.buffer.limit();
        this.buffer.flip();
        byte[] bs = new byte[pos];
        this.buffer.get(bs);
        this.buffer.position(pos);
        this.buffer.limit(limit);
        return new String(bs);
    }

    public String toString() {
        return "[" + (Object)((Object)this.logLevel) + " pos:" + this.buffer.position() + " limit:" + this.buffer.limit() + " capacity:" + this.buffer.capacity() + "]";
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public long getSequence() {
        return this.sequence;
    }
}

