/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Locale;
import java.util.TimeZone;
import org.gflogger.Layout;
import org.gflogger.LogEntryItem;
import org.gflogger.helpers.PatternConverter;
import org.gflogger.helpers.PatternParser;

public class PatternLayout
extends Layout {
    public static final String DEFAULT_CONVERSION_PATTERN = "%m%n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %x - %m%n";
    private String pattern;
    private PatternConverter head;
    private Locale locale;
    private TimeZone timeZone;

    public PatternLayout() {
        this(DEFAULT_CONVERSION_PATTERN);
    }

    public PatternLayout(String pattern) {
        this(pattern, (TimeZone)null, (Locale)null);
    }

    public PatternLayout(String pattern, String timeZoneId) {
        this(pattern, timeZoneId != null ? TimeZone.getTimeZone(timeZoneId) : null, null);
    }

    public PatternLayout(String pattern, String timeZoneId, String language) {
        this(pattern, timeZoneId != null ? TimeZone.getTimeZone(timeZoneId) : null, language != null ? new Locale(language) : null);
    }

    public PatternLayout(String pattern, TimeZone timeZone, Locale locale) {
        this.pattern = pattern;
        this.locale = locale;
        this.timeZone = timeZone;
        this.head = this.createPatternParser(pattern == null ? DEFAULT_CONVERSION_PATTERN : pattern).parse();
    }

    public void setConversionPattern(String conversionPattern) {
        this.pattern = conversionPattern;
        this.head = this.createPatternParser(conversionPattern).parse();
    }

    public String getConversionPattern() {
        return this.pattern;
    }

    public void activateOptions() {
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean ignoresThrowable() {
        return true;
    }

    protected PatternParser createPatternParser(String pattern) {
        return new PatternParser(pattern, this.locale, this.timeZone);
    }

    @Override
    public CharBuffer format(CharBuffer buffer, LogEntryItem item) {
        PatternConverter c = this.head;
        while (c != null) {
            c.format(buffer, item);
            c = c.next;
        }
        return buffer;
    }

    @Override
    public ByteBuffer format(ByteBuffer buffer, LogEntryItem item) {
        PatternConverter c = this.head;
        while (c != null) {
            c.format(buffer, item);
            c = c.next;
        }
        return buffer;
    }

    @Override
    public int size(LogEntryItem item) {
        int size = 0;
        PatternConverter c = this.head;
        while (c != null) {
            size += c.size(item);
            c = c.next;
        }
        return size;
    }
}

