/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TypeEntityRegistry<T> {
    private final T defaultEntity;
    private final ConcurrentMap<Class, T> entities = new ConcurrentHashMap<Class, T>();

    public TypeEntityRegistry(T defaultEntity) {
        this.defaultEntity = defaultEntity;
    }

    public void register(Class<?> clazz, T entity) {
        this.entities.put(clazz, entity);
    }

    public void clear() {
        this.entities.clear();
    }

    public T forType(Class<?> type) {
        LookupResult<T> ifaceResult;
        Object entity = this.entities.get(type);
        if (entity != null) {
            return (T)entity;
        }
        LookupResult<T> sclassResult = this.lookupSuperclassChain(type);
        LookupResult<T> bestResult = LookupResult.bestOf(sclassResult, ifaceResult = this.lookupInterfacesChain(type, 0));
        entity = bestResult.isFound() ? bestResult.entity() : this.defaultEntity;
        this.entities.put(type, entity);
        return (T)entity;
    }

    private LookupResult<T> lookupSuperclassChain(Class<?> startingWith) {
        double minWeight = 2.147483647E9;
        Object matchedEntity = null;
        Class matchedType = null;
        int depth = 0;
        for (Class<?> clazz = startingWith; clazz != null; clazz = clazz.getSuperclass()) {
            Object entity = this.entities.get(clazz);
            if (entity != null) {
                return LookupResult.byClass(clazz, entity, depth);
            }
            LookupResult<T> ifaceResult = this.lookupInterfacesChain(clazz, depth);
            if (ifaceResult.isFound() && ifaceResult.weight() < minWeight) {
                matchedType = ifaceResult.actualTypeMatched();
                minWeight = ifaceResult.weight();
                matchedEntity = ifaceResult.entity();
            }
            ++depth;
        }
        if (matchedEntity == null) {
            return LookupResult.NOT_FOUND;
        }
        return LookupResult.byClass(matchedType, matchedEntity, minWeight);
    }

    private LookupResult<T> lookupInterfacesChain(Class<?> startingWith, int depth) {
        double minWeight = 2.147483647E9;
        Object matchedEntity = null;
        Class matchedIface = null;
        for (Class<?> iface : startingWith.getInterfaces()) {
            Object entity = this.entities.get(iface);
            if (entity != null) {
                return LookupResult.byInterface(iface, entity, depth + 1);
            }
            LookupResult<T> result = this.lookupInterfacesChain(iface, depth + 1);
            if (!result.isFound() || !(result.weight() < minWeight)) continue;
            minWeight = result.weight();
            matchedEntity = result.entity();
            matchedIface = result.actualTypeMatched();
        }
        if (matchedEntity == null) {
            return LookupResult.NOT_FOUND;
        }
        return LookupResult.byInterface(matchedIface, matchedEntity, (double)depth + minWeight);
    }

    private static class LookupResult<T> {
        public static final LookupResult NOT_FOUND = new LookupResult<Object>(null, null, 2.147483647E9);
        private Class actualTypeMatched;
        private T entity;
        private double weight;

        private LookupResult() {
        }

        public static <T> LookupResult byClass(Class actualTypeMatched, T entity, double weight) {
            return new LookupResult<T>(actualTypeMatched, entity, weight);
        }

        public static <T> LookupResult byInterface(Class actualTypeMatched, T entity, double weight) {
            return new LookupResult<T>(actualTypeMatched, entity, weight + 0.5);
        }

        private LookupResult(Class actualTypeMatched, T entity, double weight) {
            this.setup(actualTypeMatched, entity, weight);
        }

        private void setup(Class actualTypeMatched, T entity, double weight) {
            this.actualTypeMatched = actualTypeMatched;
            this.entity = entity;
            this.weight = weight;
        }

        public Class actualTypeMatched() {
            return this.actualTypeMatched;
        }

        public T entity() {
            return this.entity;
        }

        public double weight() {
            return this.weight;
        }

        public boolean isFound() {
            return this.entity != null;
        }

        public static <T> LookupResult<T> bestOf(LookupResult<T> sr1, LookupResult<T> sr2) {
            return sr1.weight <= sr2.weight ? sr1 : sr2;
        }
    }
}

