/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.appender;

import java.util.Locale;
import java.util.TimeZone;
import org.gflogger.Layout;
import org.gflogger.LogLevel;
import org.gflogger.LoggerService;
import org.gflogger.PatternLayout;
import org.gflogger.appender.AppenderFactory;
import org.gflogger.helpers.OptionConverter;

public abstract class AbstractAppenderFactory
implements AppenderFactory {
    protected int bufferSize = OptionConverter.getIntProperty("gflogger.buffer.size", 0x100000);
    protected boolean multibyte = OptionConverter.getBooleanProperty("gflogger.multibyte", false);
    protected LogLevel logLevel = LogLevel.valueOf(OptionConverter.getStringProperty("gflogger.loglevel", "TRACE"));
    protected TimeZone timeZone = OptionConverter.getStringProperty("gflogger.timeZoneId", null) != null ? TimeZone.getTimeZone(OptionConverter.getStringProperty("gflogger.timeZoneId", null)) : null;
    protected Locale locale = OptionConverter.getStringProperty("gflogger.language", null) != null ? new Locale(OptionConverter.getStringProperty("gflogger.language", null)) : null;
    protected String layoutPattern = OptionConverter.getStringProperty("gflogger.pattern", "%m%n");
    protected Layout layout;
    protected boolean immediateFlush = OptionConverter.getBooleanProperty("gflogger.immediateFlush", false);
    protected int bufferedIOThreshold = OptionConverter.getIntProperty("gflogger.bufferedIOThreshold", 100);
    protected long awaitTimeout = OptionConverter.getIntProperty("gflogger.awaitTimeout", 10);
    protected boolean enabled = true;
    protected int index;

    protected void preinit(Class<? extends LoggerService> loggerServiceClass) {
        if (this.layout == null) {
            this.layout = new PatternLayout(this.layoutPattern, this.timeZone, this.locale);
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isMultibyte() {
        return this.multibyte;
    }

    public void setMultibyte(boolean multibyte) {
        this.multibyte = multibyte;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZoneId() {
        return this.timeZone != null ? this.timeZone.getID() : null;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZone = timeZoneId != null ? TimeZone.getTimeZone(timeZoneId) : null;
    }

    public String getLayoutPattern() {
        return this.layoutPattern;
    }

    public void setLayoutPattern(String layoutPattern) {
        this.layoutPattern = layoutPattern;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public int getBufferedIOThreshold() {
        return this.bufferedIOThreshold;
    }

    public void setBufferedIOThreshold(int bufferedIOThreshold) {
        this.bufferedIOThreshold = bufferedIOThreshold;
    }

    public long getAwaitTimeout() {
        return this.awaitTimeout;
    }

    public void setAwaitTimeout(long awaitTimeout) {
        this.awaitTimeout = awaitTimeout;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }
}

