/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.appender;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.gflogger.Appender;
import org.gflogger.Layout;
import org.gflogger.LogEntryItem;
import org.gflogger.LogEntryItemImpl;
import org.gflogger.LogLevel;
import org.gflogger.PatternLayout;
import org.gflogger.formatter.BufferFormatter;
import org.gflogger.helpers.LogLog;

public abstract class AbstractAsyncAppender
implements Appender<LogEntryItemImpl> {
    protected final CharBuffer charBuffer;
    protected final ByteBuffer byteBuffer;
    protected LogLevel logLevel = LogLevel.TRACE;
    protected Layout layout;
    protected boolean immediateFlush = false;
    protected int bufferedIOThreshold = 100;
    protected long awaitTimeout = 10L;
    protected boolean enabled = true;
    protected int index;
    protected volatile boolean running = false;
    protected final boolean multibyte;

    public AbstractAsyncAppender(boolean multibyte) {
        this(0x400000, multibyte);
    }

    public AbstractAsyncAppender(int bufferSize, boolean multibyte) {
        this.multibyte = multibyte;
        this.byteBuffer = BufferFormatter.allocate(multibyte ? bufferSize << 1 : bufferSize);
        this.byteBuffer.clear();
        this.charBuffer = multibyte ? BufferFormatter.allocate(multibyte ? bufferSize << 1 : bufferSize).asCharBuffer() : null;
    }

    @Override
    public boolean isMultibyte() {
        return this.multibyte;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public synchronized void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public void setBufferedIOThreshold(int bufferedIOThreshold) {
        this.bufferedIOThreshold = bufferedIOThreshold;
    }

    public void setAwaitTimeout(long awaitTimeout) {
        this.awaitTimeout = awaitTimeout;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void process(LogEntryItemImpl entry) {
        if (!this.enabled || this.logLevel.greaterThan(entry.getLogLevel())) {
            return;
        }
        if (this.multibyte) {
            CharBuffer buffer = entry.getCharBuffer();
            int position0 = buffer.position();
            int limit0 = buffer.limit();
            int position = this.charBuffer.position();
            int limit = this.charBuffer.limit();
            int size = this.layout.size(entry);
            if (position + size >= limit) {
                this.flush();
                this.charBuffer.clear();
            }
            buffer.flip();
            this.layout.format(this.charBuffer, (LogEntryItem)entry);
            buffer.limit(limit0).position(position0);
            this.processCharBuffer();
        } else {
            ByteBuffer buffer = entry.getBuffer();
            int position0 = buffer.position();
            int limit0 = buffer.limit();
            int position = this.byteBuffer.position();
            int limit = this.byteBuffer.limit();
            int size = this.layout.size(entry);
            if (position + size >= limit) {
                this.flush();
                this.byteBuffer.clear();
            }
            buffer.flip();
            this.layout.format(this.byteBuffer, (LogEntryItem)entry);
            buffer.limit(limit0).position(position0);
        }
    }

    protected void processCharBuffer() {
    }

    @Override
    public void workerIsAboutToFinish() {
        this.flush();
        BufferFormatter.purge(this.byteBuffer);
        BufferFormatter.purge(this.charBuffer);
    }

    @Override
    public void flush() {
        this.flush(true);
    }

    @Override
    public void start() {
        if (this.running) {
            throw new IllegalStateException();
        }
        LogLog.debug(this.getName() + " is starting ");
        if (this.layout == null) {
            this.layout = new PatternLayout();
        }
        this.running = true;
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        LogLog.debug(this.getName() + " is stopping ");
        this.running = false;
    }
}

