/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.appender;

import java.io.Flushable;
import java.io.IOException;
import org.gflogger.appender.AbstractAsyncAppender;
import org.gflogger.helpers.LogLog;

public class ConsoleAppender
extends AbstractAsyncAppender {
    private final Appendable out;
    private final Flushable flushable;

    public ConsoleAppender() {
        this(false);
    }

    public ConsoleAppender(boolean multibyte) {
        this(System.out, multibyte);
    }

    public ConsoleAppender(int bufferSize, boolean multibyte) {
        this(bufferSize, multibyte, System.out);
    }

    public ConsoleAppender(Appendable out, boolean multibyte) {
        super(multibyte);
        this.out = out;
        this.flushable = out instanceof Flushable ? (Flushable)((Object)out) : null;
    }

    public ConsoleAppender(int bufferSize, boolean multibyte, Appendable out) {
        super(bufferSize, multibyte);
        this.out = out;
        this.flushable = out instanceof Flushable ? (Flushable)((Object)out) : null;
    }

    @Override
    protected void processCharBuffer() {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void flush(boolean force) {
        if (!force && !this.immediateFlush) {
            return;
        }
        if (this.multibyte) {
            if (this.charBuffer.position() <= 0) return;
            this.charBuffer.flip();
            try {
                while (this.charBuffer.hasRemaining()) {
                    this.out.append(this.charBuffer.get());
                }
                if (this.flushable == null) return;
                this.flushable.flush();
                return;
            }
            catch (IOException e) {
                LogLog.error("[" + Thread.currentThread().getName() + "] exception at " + this.getName() + " - " + e.getMessage(), e);
                return;
            }
            finally {
                this.charBuffer.clear();
            }
        }
        if (this.byteBuffer.position() <= 0) return;
        this.byteBuffer.flip();
        try {
            while (this.byteBuffer.hasRemaining()) {
                this.out.append((char)this.byteBuffer.get());
            }
            if (this.flushable == null) return;
            this.flushable.flush();
            return;
        }
        catch (IOException e) {
            LogLog.error("[" + Thread.currentThread().getName() + "] exception at " + this.getName() + " - " + e.getMessage(), e);
            return;
        }
        finally {
            this.byteBuffer.clear();
        }
    }

    @Override
    public String getName() {
        return "console";
    }
}

