/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.appender;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.gflogger.Layout;
import org.gflogger.LogEntryItemImpl;
import org.gflogger.PatternLayout;
import org.gflogger.appender.FileAppender;
import org.gflogger.helpers.LogLog;

public class DailyRollingFileAppender
extends FileAppender {
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    RollingCalendar rc;
    Troubles checkPeriod = Troubles.TOP_OF_TROUBLE;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public DailyRollingFileAppender(boolean multibyte) {
        super(multibyte);
    }

    public DailyRollingFileAppender(int bufferSize, boolean multibyte) {
        super(bufferSize, multibyte);
    }

    public DailyRollingFileAppender(Layout layout, String filename, String datePattern, boolean multibyte) {
        super(layout, filename, multibyte);
        this.datePattern = datePattern;
    }

    public DailyRollingFileAppender(int bufferSize, Layout layout, String filename, String datePattern, boolean multibyte) {
        super(bufferSize, layout, filename, multibyte);
        this.datePattern = datePattern;
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    @Override
    protected void createFileChannel() throws FileNotFoundException {
        FileOutputStream fout = new FileOutputStream(this.fileName, this.append);
        this.channel = fout.getChannel();
        this.scheduledFilename = this.fileName + this.sdf.format(this.now);
    }

    void printPeriodicity(Troubles type) {
        switch (type) {
            case TOP_OF_MINUTE: {
                LogLog.debug("Appender to be rolled every minute.");
                break;
            }
            case TOP_OF_HOUR: {
                LogLog.debug("Appender to be rolled on top of every hour.");
                break;
            }
            case HALF_DAY: {
                LogLog.debug("Appender to be rolled at midday and midnight.");
                break;
            }
            case TOP_OF_DAY: {
                LogLog.debug("Appender to be rolled at midnight.");
                break;
            }
            case TOP_OF_WEEK: {
                LogLog.debug("Appender to be rolled at start of week.");
                break;
            }
            case TOP_OF_MONTH: {
                LogLog.debug("Appender to be rolled at start of every month.");
                break;
            }
            default: {
                LogLog.warn("Unknown periodicity for appender.");
            }
        }
    }

    Troubles computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.getDefault());
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (Troubles troubles : Troubles.values) {
                if (troubles.getCode() < 0) continue;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(troubles);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return troubles;
            }
        }
        return Troubles.TOP_OF_TROUBLE;
    }

    void rollOver() throws IOException {
        File file;
        boolean result;
        this.flush();
        if (this.datePattern == null) {
            return;
        }
        String datedFilename = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(datedFilename)) {
            return;
        }
        this.closeFile();
        File target = new File(this.scheduledFilename);
        if (target.exists()) {
            target.delete();
        }
        if (result = (file = new File(this.fileName)).renameTo(target)) {
            LogLog.debug(this.fileName + " -> " + this.scheduledFilename);
        } else {
            LogLog.error("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "].");
        }
        try {
            this.createFileChannel();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.scheduledFilename = datedFilename;
    }

    @Override
    public void process(LogEntryItemImpl entry) {
        long n = entry.getTimestamp();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                if (ioe instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                LogLog.error("rollOver() failed.", ioe);
            }
        }
        super.process(entry);
    }

    @Override
    public void start() {
        this.now.setTime(System.currentTimeMillis());
        this.sdf = new SimpleDateFormat(this.datePattern);
        Troubles type = this.computeCheckPeriod();
        this.printPeriodicity(type);
        TimeZone timeZone = null;
        if (this.layout instanceof PatternLayout) {
            PatternLayout patternLayout = (PatternLayout)this.layout;
            timeZone = patternLayout.getTimeZone();
        }
        this.rc = new RollingCalendar(timeZone != null ? timeZone : TimeZone.getDefault());
        this.rc.setType(type);
        super.start();
    }

    @Override
    public String getName() {
        return "rollFile:" + this.fileName;
    }

    static class RollingCalendar
    extends GregorianCalendar {
        private static final long serialVersionUID = -3560331770601814177L;
        Troubles type = Troubles.TOP_OF_TROUBLE;

        RollingCalendar(TimeZone tz) {
            super(tz);
        }

        RollingCalendar(TimeZone tz, Locale locale) {
            super(tz, locale);
        }

        void setType(Troubles type) {
            this.type = type;
        }

        public long getNextCheckMillis(Date now) {
            return this.getNextCheckDate(now).getTime();
        }

        public Date getNextCheckDate(Date now) {
            this.setTime(now);
            switch (this.type) {
                case TOP_OF_MINUTE: {
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(12, 1);
                    break;
                }
                case TOP_OF_HOUR: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(11, 1);
                    break;
                }
                case HALF_DAY: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    int hour = this.get(11);
                    if (hour < 12) {
                        this.set(11, 12);
                        break;
                    }
                    this.set(11, 0);
                    this.add(5, 1);
                    break;
                }
                case TOP_OF_DAY: {
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(5, 1);
                    break;
                }
                case TOP_OF_WEEK: {
                    this.set(7, this.getFirstDayOfWeek());
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(3, 1);
                    break;
                }
                case TOP_OF_MONTH: {
                    this.set(5, 1);
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(2, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type:" + (Object)((Object)this.type));
                }
            }
            return this.getTime();
        }
    }

    static enum Troubles {
        TOP_OF_TROUBLE(-1),
        TOP_OF_MINUTE(0),
        TOP_OF_HOUR(1),
        HALF_DAY(2),
        TOP_OF_DAY(3),
        TOP_OF_WEEK(4),
        TOP_OF_MONTH(5);

        private final int code;
        public static Troubles[] values;

        private Troubles(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        static {
            values = Troubles.values();
        }
    }
}

