/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.appender;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.gflogger.Layout;
import org.gflogger.appender.AbstractAsyncAppender;
import org.gflogger.helpers.LogLog;

public class FileAppender
extends AbstractAsyncAppender {
    protected String fileName;
    protected String codepage = "UTF-8";
    protected CharsetEncoder encoder;
    protected FileChannel channel;
    protected boolean append = true;
    protected int maxBytesPerChar;

    public FileAppender(boolean multibyte) {
        this(0x100000, multibyte);
    }

    public FileAppender(int bufferSize, boolean multibyte) {
        super(bufferSize, multibyte);
        this.immediateFlush = false;
    }

    public FileAppender(Layout layout, String filename, boolean multibyte) {
        this(0x100000, layout, filename, multibyte);
    }

    public FileAppender(int bufferSize, Layout layout, String filename, boolean multibyte) {
        this(bufferSize, multibyte);
        this.layout = layout;
        this.fileName = filename;
    }

    public synchronized void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public synchronized void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    @Override
    protected void processCharBuffer() {
        int sizeOfBuffer;
        int remaining = this.byteBuffer.remaining();
        if (remaining < (sizeOfBuffer = this.maxBytesPerChar * this.charBuffer.position())) {
            this.store("remaining < sizeOfBuffer");
        }
        this.charBuffer.flip();
        this.encoder.encode(this.charBuffer, this.byteBuffer, true);
        this.charBuffer.clear();
    }

    @Override
    public void flush(boolean force) {
        if (!force && !this.immediateFlush) {
            return;
        }
        this.store("flushCharBuffer");
    }

    @Override
    public void workerIsAboutToFinish() {
        this.store("workerIsAboutFinish");
        this.closeFile();
    }

    @Override
    public void start() {
        try {
            this.encoder = this.multibyte ? Charset.forName(this.codepage).newEncoder() : null;
            this.maxBytesPerChar = this.multibyte ? (int)Math.floor(this.encoder.maxBytesPerChar()) : 1;
            this.createFileChannel();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        super.start();
    }

    protected void createFileChannel() throws FileNotFoundException {
        FileOutputStream fout = new FileOutputStream(this.fileName, this.append);
        this.channel = fout.getChannel();
    }

    protected void closeFile() {
        try {
            this.channel.force(true);
            this.channel.close();
        }
        catch (IOException e) {
            LogLog.error("[" + Thread.currentThread().getName() + "] exception at " + this.getName() + " - " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean store(String cause) {
        if (this.byteBuffer.position() == 0) {
            return false;
        }
        this.byteBuffer.flip();
        try {
            this.channel.write(this.byteBuffer);
        }
        catch (IOException e) {
            LogLog.error("[" + Thread.currentThread().getName() + "] exception at " + this.getName() + " - " + e.getMessage(), e);
        }
        finally {
            this.byteBuffer.clear();
        }
        return true;
    }

    @Override
    public String getName() {
        return "file:" + this.fileName;
    }
}

