/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.appender;

import org.gflogger.Appender;
import org.gflogger.LoggerService;
import org.gflogger.appender.AbstractAppenderFactory;
import org.gflogger.appender.FileAppender;
import org.gflogger.helpers.OptionConverter;

public class FileAppenderFactory
extends AbstractAppenderFactory {
    protected String fileName = OptionConverter.getStringProperty("gflogger.filename", null);
    protected String codepage = OptionConverter.getStringProperty("gflogger.codepage", "UTF-8");
    protected boolean append = OptionConverter.getBooleanProperty("gflogger.append", true);

    @Override
    public Appender createAppender(Class<? extends LoggerService> loggerServiceClass) {
        this.preinit(loggerServiceClass);
        FileAppender appender = new FileAppender(this.bufferSize, this.multibyte);
        appender.setLogLevel(this.logLevel);
        appender.setLayout(this.layout);
        appender.setImmediateFlush(this.immediateFlush);
        appender.setBufferedIOThreshold(this.bufferedIOThreshold);
        appender.setAwaitTimeout(this.awaitTimeout);
        appender.setEnabled(this.enabled);
        appender.setIndex(this.index);
        appender.setFileName(this.fileName);
        appender.setCodepage(this.codepage);
        appender.setAppend(this.append);
        return appender;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getCodepage() {
        return this.codepage;
    }

    public void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }
}

