/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.base;

import java.util.concurrent.TimeUnit;
import org.gflogger.AbstractEntryHandler;
import org.gflogger.Appender;
import org.gflogger.LogEntryItemImpl;
import org.gflogger.helpers.LogLog;
import org.gflogger.ring.AlertException;
import org.gflogger.ring.EntryProcessor;
import org.gflogger.ring.PaddedAtomicLong;
import org.gflogger.ring.RingBuffer;
import org.gflogger.ring.RingBufferAware;

public class EntryHandler
extends AbstractEntryHandler
implements EntryProcessor,
RingBufferAware<LogEntryItemImpl> {
    protected RingBuffer<LogEntryItemImpl> ringBuffer;
    protected final PaddedAtomicLong cursor = new PaddedAtomicLong(-1L);
    protected boolean immediateFlush = false;
    protected int bufferedIOThreshold = 10000;
    protected long awaitTimeout = 10L;

    public EntryHandler(Appender[] appenders) {
        super(appenders);
    }

    @Override
    public final long getSequence() {
        return this.cursor.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LogLog.debug(Thread.currentThread().getName() + " is started.");
        long idx = -1L;
        long loopCounter = 0L;
        try {
            while (true) {
                long maxIndex = this.ringBuffer.waitFor(idx + 1L, this.awaitTimeout, TimeUnit.MILLISECONDS);
                while (maxIndex > idx) {
                    LogEntryItemImpl entry = this.ringBuffer.get(idx + 1L);
                    assert (entry.isPublished());
                    try {
                        this.process(entry);
                    }
                    finally {
                        entry.setPublished(false);
                        this.cursor.lazySet(idx);
                        ++idx;
                    }
                    if (!this.immediateFlush) continue;
                    this.flushBuffer(false);
                    loopCounter = 0L;
                }
                if (loopCounter > (long)this.bufferedIOThreshold) {
                    this.flushBuffer();
                    loopCounter = 0L;
                }
                ++loopCounter;
            }
        }
        catch (InterruptedException e) {
        }
        catch (AlertException e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.workerIsAboutToFinish();
        LogLog.debug(Thread.currentThread().getName() + " is finished. ");
    }

    @Override
    public final void setRingBuffer(RingBuffer<LogEntryItemImpl> ringBuffer) {
        this.ringBuffer = ringBuffer;
    }
}

