/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.base;

import java.util.concurrent.TimeUnit;
import org.gflogger.AbstractLoggerServiceImpl;
import org.gflogger.Appender;
import org.gflogger.GFLogger;
import org.gflogger.GFLoggerBuilder;
import org.gflogger.LocalLogEntry;
import org.gflogger.LogEntryItemImpl;
import org.gflogger.LogLevel;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.appender.AppenderFactory;
import org.gflogger.base.EntryHandler;
import org.gflogger.formatter.BufferFormatter;
import org.gflogger.ring.EntryProcessor;
import org.gflogger.ring.Publishable;
import org.gflogger.ring.RingBuffer;

public class LoggerServiceImpl
extends AbstractLoggerServiceImpl {
    private final RingBuffer<LogEntryItemImpl> ringBuffer;
    private final EntryHandler entryHandler;

    public LoggerServiceImpl(int count, int maxMessageSize, GFLoggerBuilder[] loggerBuilders, AppenderFactory ... appenderFactories) {
        this(count, maxMessageSize, null, LoggerServiceImpl.createAppenders(appenderFactories), LoggerServiceImpl.createLoggers(appenderFactories, loggerBuilders));
    }

    public LoggerServiceImpl(int count, int maxMessageSize, ObjectFormatterFactory objectFormatterFactory, GFLoggerBuilder[] loggersBuilders, AppenderFactory ... appenderFactories) {
        this(count, maxMessageSize, objectFormatterFactory, LoggerServiceImpl.createAppenders(appenderFactories), LoggerServiceImpl.createLoggers(appenderFactories, loggersBuilders));
    }

    private LoggerServiceImpl(int count, int maxMessageSize, ObjectFormatterFactory objectFormatterFactory, Appender[] appenders, GFLogger[] loggers) {
        super(count, maxMessageSize, objectFormatterFactory, loggers, appenders);
        int maxMessageSize0 = this.multibyte ? maxMessageSize << 1 : maxMessageSize;
        int c = (count & count - 1) != 0 ? BufferFormatter.roundUpNextPower2(count) : count;
        this.entryHandler = new EntryHandler(appenders);
        this.ringBuffer = new RingBuffer((Publishable[])this.initEnties(c, maxMessageSize0), new EntryProcessor[]{this.entryHandler});
        this.entryHandler.start();
        this.executorService.execute(this.entryHandler);
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entryFlushed(LocalLogEntry localEntry) {
        String categoryName = localEntry.getCategoryName();
        LogLevel logLevel = localEntry.getLogLevel();
        String threadName = localEntry.getThreadName();
        long appenderMask = localEntry.getAppenderMask();
        long now = System.currentTimeMillis();
        long next = this.ringBuffer.next();
        LogEntryItemImpl entry = this.ringBuffer.get(next);
        try {
            entry.setCategoryName(categoryName);
            entry.setLogLevel(logLevel);
            entry.setThreadName(threadName);
            entry.setTimestamp(now);
            entry.setAppenderMask(appenderMask);
            if (this.multibyte) {
                localEntry.copyTo(entry.getCharBuffer());
            } else {
                localEntry.copyTo(entry.getBuffer());
            }
        }
        finally {
            this.ringBuffer.publish(next);
        }
    }

    @Override
    protected String name() {
        return "gflogger";
    }

    @Override
    public void stop() {
        this.running = false;
        this.ringBuffer.stop();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.stop();
    }
}

