/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.config.xml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.TimeZone;

public final class BeanUtils {
    private static final Class[] PRIMITIVE_MAPPING = new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Byte.TYPE, Integer.class, Short.TYPE, Integer.class, Long.TYPE, Long.class, Character.TYPE, Character.class};

    private BeanUtils() {
        throw new AssertionError((Object)"Not for instantiation");
    }

    public static PropertyDescriptor[] classProperties(Class clazz) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        return beanInfo.getPropertyDescriptors();
    }

    public static void setPropertyStringValue(Object bean, PropertyDescriptor property, String value) throws Exception {
        PropertyEditor editor = property.createPropertyEditor(bean);
        if (editor != null) {
            editor.setAsText(value);
        } else {
            Method writeMethod = property.getWriteMethod();
            if (writeMethod != null) {
                Class<?> paramClass = writeMethod.getParameterTypes()[0];
                try {
                    Object aValue = BeanUtils.convert(value, paramClass);
                    if (aValue != null) {
                        writeMethod.invoke(bean, aValue);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public static void setPropertyValue(Object bean, String propertyName, Object value) throws Exception {
        Class<?> beanClass = bean.getClass();
        Class<?> valueClass = value.getClass();
        for (Method method : beanClass.getMethods()) {
            String beanPropertyName;
            if (!BeanUtils.isPublic(method) || BeanUtils.isStatic(method)) continue;
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!methodName.startsWith("set") || parameterTypes.length != 1 || !parameterTypes[0].isInstance(value) || !propertyName.equals(beanPropertyName = Introspector.decapitalize(methodName.substring(3)))) continue;
            method.invoke(bean, value);
        }
    }

    private static Object convert(String value, Class targetType) {
        if (targetType.isInstance(value)) {
            return value;
        }
        Class actualTargetType = targetType;
        if (targetType.isPrimitive()) {
            for (int i = 0; i < PRIMITIVE_MAPPING.length; i += 2) {
                if (!PRIMITIVE_MAPPING[i].equals(targetType)) continue;
                actualTargetType = PRIMITIVE_MAPPING[i + 1];
                break;
            }
        }
        try {
            Method valueOfMethod = actualTargetType.getMethod("valueOf", String.class);
            if (BeanUtils.isStatic(valueOfMethod) && BeanUtils.isPublic(valueOfMethod)) {
                return valueOfMethod.invoke(null, value);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Constructor ctor = actualTargetType.getConstructor(String.class);
            if (BeanUtils.isPublic(ctor)) {
                return ctor.newInstance(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (actualTargetType.equals(Character.class)) {
            return Character.valueOf(value.charAt(0));
        }
        if (actualTargetType.equals(TimeZone.class)) {
            return TimeZone.getTimeZone(value);
        }
        return null;
    }

    private static boolean isPublic(Member m) {
        return (m.getModifiers() & 1) != 0;
    }

    private static boolean isStatic(Member m) {
        return (m.getModifiers() & 8) != 0;
    }
}

