/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.config.xml;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.gflogger.GFLoggerBuilder;
import org.gflogger.Layout;
import org.gflogger.LoggerService;
import org.gflogger.ObjectFormatter;
import org.gflogger.appender.AppenderFactory;
import org.gflogger.config.xml.BeanUtils;
import org.gflogger.config.xml.DLoggerServiceFactory;
import org.gflogger.config.xml.LoggerServiceFactory;
import org.gflogger.helpers.LogLog;
import org.gflogger.helpers.OptionConverter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Configuration
extends DefaultHandler {
    private final Stack<Object> stack = new Stack();
    private final Map<String, AppenderFactory> appenderFactories = new LinkedHashMap<String, AppenderFactory>();
    private final List<GFLoggerBuilder> loggerBuilders = new ArrayList<GFLoggerBuilder>();
    private final Map<Class, ObjectFormatter> objectFormatters = new LinkedHashMap<Class, ObjectFormatter>();
    private LoggerServiceFactory loggerServiceFactory;
    private LoggerService loggerService;

    public Map<String, AppenderFactory> getAppenderFactories() {
        return this.appenderFactories;
    }

    public LoggerService getLoggerService() {
        if (this.loggerService == null) {
            for (AppenderFactory appenderFactory : this.appenderFactories.values()) {
                this.loggerServiceFactory.addAppenderFactory(appenderFactory);
            }
            for (GFLoggerBuilder gFLoggerBuilder : this.loggerBuilders) {
                this.loggerServiceFactory.addGFLoggerBuilder(gFLoggerBuilder);
            }
            for (Map.Entry entry : this.objectFormatters.entrySet()) {
                this.loggerServiceFactory.addObjectFormatter((Class)entry.getKey(), (ObjectFormatter)entry.getValue());
            }
            this.loggerService = this.loggerServiceFactory.createService();
            Configuration.debug("Created LoggerService.");
        }
        return this.loggerService;
    }

    private String getAttribute(Attributes attributes, String name) {
        return OptionConverter.substVars(attributes.getValue(name), System.getProperties());
    }

    private void startAppender(Attributes attributes) throws Exception {
        String name = this.getAttribute(attributes, "name");
        String factoryClassName = this.getAttribute(attributes, "class");
        Class<?> factoryClazz = Class.forName(factoryClassName);
        AppenderFactory appenderFactory = (AppenderFactory)factoryClazz.newInstance();
        for (PropertyDescriptor property : BeanUtils.classProperties(factoryClazz)) {
            String propertyName;
            String attributeValue;
            if (property.getWriteMethod() == null || (attributeValue = this.getAttribute(attributes, propertyName = property.getName())) == null) continue;
            BeanUtils.setPropertyStringValue(appenderFactory, property, attributeValue);
        }
        this.stack.push(appenderFactory);
        this.appenderFactories.put(name, appenderFactory);
        Configuration.debug("Created AppenderFactory '" + name + "'");
    }

    private void startLayout(Attributes attributes) throws Exception {
        String className = this.getAttribute(attributes, "class");
        String pattern = this.getAttribute(attributes, "pattern");
        String timeZoneId = this.getAttribute(attributes, "timeZoneId");
        String language = this.getAttribute(attributes, "language");
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getConstructor(String.class, String.class, String.class);
        Layout layout = (Layout)constructor.newInstance(pattern, timeZoneId, language);
        BeanUtils.setPropertyValue(this.stack.peek(), "layout", layout);
    }

    private void startLoggerService(Attributes attributes) throws Exception {
        String className = this.getAttribute(attributes, "class");
        Class clazz = className != null ? Class.forName(className) : DLoggerServiceFactory.class;
        this.loggerServiceFactory = (LoggerServiceFactory)clazz.newInstance();
        for (PropertyDescriptor property : BeanUtils.classProperties(clazz)) {
            String propertyName = property.getName();
            if (property.getWriteMethod() == null) continue;
            BeanUtils.setPropertyStringValue(this.loggerServiceFactory, property, this.getAttribute(attributes, propertyName));
        }
    }

    private void startObjectFormatter(Attributes attributes) throws Exception {
        String className = this.getAttribute(attributes, "class");
        Class<?> clazz = Class.forName(className);
        String formatterClassName = this.getAttribute(attributes, "formatter");
        Class<?> formatterClass = Class.forName(formatterClassName);
        ObjectFormatter objectFormatter = (ObjectFormatter)formatterClass.newInstance();
        this.objectFormatters.put(clazz, objectFormatter);
        Configuration.debug("added ObjectFormatter '" + className + "'");
    }

    private void startAppenderRef(Attributes attributes) {
        String name = this.getAttribute(attributes, "ref");
        AppenderFactory appenderFactory = this.appenderFactories.get(name);
        if (appenderFactory == null) {
            Configuration.debug("No AppenderFactory '" + name + "' found");
            return;
        }
        ((GFLoggerBuilder)this.stack.peek()).addAppenderFactory(appenderFactory);
    }

    private void startLogger(Attributes attributes) throws Exception {
        GFLoggerBuilder builder = new GFLoggerBuilder();
        for (PropertyDescriptor property : BeanUtils.classProperties(builder.getClass())) {
            String propertyName = property.getName();
            if (property.getWriteMethod() == null) continue;
            BeanUtils.setPropertyStringValue(builder, property, this.getAttribute(attributes, propertyName));
        }
        String name = builder.getName();
        Configuration.debug("Created " + (name != null ? "'" + name + "'" : "root") + " logger");
        this.stack.push(builder);
    }

    private void endLogger() {
        GFLoggerBuilder gfLogger = (GFLoggerBuilder)this.stack.peek();
        this.loggerBuilders.add(gfLogger);
    }

    private void endAppenderFactory() {
        this.stack.pop();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Configuration.debug("start element:" + qName);
        try {
            if (qName.equals("appender")) {
                this.startAppender(attributes);
            } else if (qName.equals("layout")) {
                this.startLayout(attributes);
            } else if (qName.equals("service")) {
                this.startLoggerService(attributes);
            } else if (qName.equals("object-formatter")) {
                this.startObjectFormatter(attributes);
            } else if (qName.equals("appender-ref")) {
                this.startAppenderRef(attributes);
            } else if (qName.equals("logger")) {
                this.startLogger(attributes);
            } else if (qName.equals("root")) {
                this.startLogger(attributes);
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Configuration.debug("end element:" + qName);
        if (qName.equals("appender-factory")) {
            this.endAppenderFactory();
        } else if (qName.equals("logger")) {
            this.endLogger();
        } else if (qName.equals("root")) {
            this.endLogger();
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        super.error(e);
        Configuration.error("error " + e.getMessage());
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        super.warning(e);
        Configuration.error("warning " + e.getMessage());
    }

    private static void error(String message) {
        LogLog.error("[GFLogger-Init] " + message);
    }

    private static void debug(String message) {
        LogLog.debug("[GFLogger-Init] " + message);
    }
}

