/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.config.xml;

import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.gflogger.GFLogFactory;
import org.gflogger.config.xml.Configuration;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlLogFactoryConfigurator {
    public static void configure(InputStream in) throws Exception {
        new XmlLogFactoryConfigurator(in);
    }

    public static void configure(String xmlFileName) throws Exception {
        XmlLogFactoryConfigurator.configure(XmlLogFactoryConfigurator.class.getResourceAsStream(xmlFileName));
    }

    public static void configure() throws Exception {
        XmlLogFactoryConfigurator.configure(System.getProperty("gflogger.configuration", "/gflogger.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlLogFactoryConfigurator(InputStream in) throws Exception {
        if (in == null) {
            throw new IllegalArgumentException("Not a null input stream is expected.");
        }
        try {
            SAXParser saxParser;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            InputStream is = this.getClass().getResourceAsStream("/gflogger.xsd");
            if (is != null) {
                factory.setNamespaceAware(true);
                factory.setValidating(true);
                saxParser = factory.newSAXParser();
                saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                saxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", is);
            } else {
                saxParser = factory.newSAXParser();
            }
            Configuration configuration = new Configuration();
            saxParser.parse(in, (DefaultHandler)configuration);
            GFLogFactory.init(configuration.getLoggerService());
        }
        finally {
            in.close();
        }
    }
}

