/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.disruptor;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.ClaimStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.MultiThreadedClaimStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.util.Util;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.gflogger.AbstractLoggerServiceImpl;
import org.gflogger.Appender;
import org.gflogger.GFLogger;
import org.gflogger.GFLoggerBuilder;
import org.gflogger.LocalLogEntry;
import org.gflogger.LogEntryItemImpl;
import org.gflogger.LogLevel;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.appender.AppenderFactory;
import org.gflogger.disruptor.EntryHandler;
import org.gflogger.formatter.BufferFormatter;

public class LoggerServiceImpl
extends AbstractLoggerServiceImpl {
    private final Disruptor<LogEntryItemImpl> disruptor;
    private final RingBuffer<LogEntryItemImpl> ringBuffer;
    private final WaitStrategyImpl strategy;

    public LoggerServiceImpl(int count, int maxMessageSize, GFLoggerBuilder[] loggerBuilders, AppenderFactory ... appenderFactories) {
        this(count, maxMessageSize, null, LoggerServiceImpl.createAppenders(appenderFactories), LoggerServiceImpl.createLoggers(appenderFactories, loggerBuilders));
    }

    public LoggerServiceImpl(int count, int maxMessageSize, ObjectFormatterFactory objectFormatterFactory, GFLoggerBuilder[] loggerBuilders, AppenderFactory ... appenderFactories) {
        this(count, maxMessageSize, objectFormatterFactory, LoggerServiceImpl.createAppenders(appenderFactories), LoggerServiceImpl.createLoggers(appenderFactories, loggerBuilders));
    }

    private LoggerServiceImpl(int count, int maxMessageSize, final ObjectFormatterFactory objectFormatterFactory, Appender[] appenders, GFLogger[] loggers) {
        super(count, maxMessageSize, objectFormatterFactory, loggers, appenders);
        int c = (count & count - 1) != 0 ? BufferFormatter.roundUpNextPower2(count) : count;
        final int bufferSize = this.multibyte ? maxMessageSize << 1 : maxMessageSize;
        final ByteBuffer buffer = BufferFormatter.allocate(c * bufferSize);
        this.strategy = new WaitStrategyImpl();
        final LoggerServiceImpl service = this;
        this.disruptor = new Disruptor((EventFactory)new EventFactory<LogEntryItemImpl>(){
            int i = 0;

            public LogEntryItemImpl newInstance() {
                buffer.limit((this.i + 1) * bufferSize);
                buffer.position(this.i * bufferSize);
                ++this.i;
                ByteBuffer subBuffer = buffer.slice();
                return new LogEntryItemImpl(objectFormatterFactory, service, subBuffer, LoggerServiceImpl.this.multibyte);
            }
        }, (Executor)this.executorService, (ClaimStrategy)new MultiThreadedClaimStrategy(c), (WaitStrategy)this.strategy);
        this.disruptor.handleExceptionsWith(new ExceptionHandler(){

            public void handleOnStartException(Throwable ex) {
                ex.printStackTrace();
            }

            public void handleOnShutdownException(Throwable ex) {
                ex.printStackTrace();
            }

            public void handleEventException(Throwable ex, long sequence, Object event) {
                ex.printStackTrace();
            }
        });
        EntryHandler entryHandler = new EntryHandler(appenders);
        this.disruptor.handleEventsWith(new EventHandler[]{entryHandler});
        this.ringBuffer = this.disruptor.start();
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entryFlushed(LocalLogEntry localEntry) {
        String categoryName = localEntry.getCategoryName();
        LogLevel logLevel = localEntry.getLogLevel();
        String threadName = localEntry.getThreadName();
        long appenderMask = localEntry.getAppenderMask();
        long now = System.currentTimeMillis();
        long sequence = this.ringBuffer.next();
        LogEntryItemImpl entry = (LogEntryItemImpl)this.ringBuffer.get(sequence);
        try {
            entry.setCategoryName(categoryName);
            entry.setLogLevel(logLevel);
            entry.setThreadName(threadName);
            entry.setTimestamp(now);
            entry.setAppenderMask(appenderMask);
            if (this.multibyte) {
                localEntry.copyTo(entry.getCharBuffer());
            } else {
                localEntry.copyTo(entry.getBuffer());
            }
        }
        finally {
            this.ringBuffer.publish(sequence);
        }
    }

    @Override
    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.strategy.signalAllWhenBlocking();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.disruptor.halt();
        super.stop();
    }

    @Override
    protected String name() {
        return "dgflogger";
    }

    void flush() {
        for (int i = 0; i < this.appenders.length; ++i) {
            this.appenders[i].flush();
        }
    }

    private class WaitStrategyImpl
    implements WaitStrategy {
        private volatile int numWaiters = 0;
        private boolean signalled;
        private final Object lock = new Object();

        private WaitStrategyImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long waitFor(long sequence, Sequence cursor, Sequence[] dependents, SequenceBarrier barrier) throws AlertException, InterruptedException {
            long availableSequence = cursor.get();
            if (availableSequence < sequence) {
                LoggerServiceImpl.this.flush();
                Object object = this.lock;
                synchronized (object) {
                    ++this.numWaiters;
                    while ((availableSequence = cursor.get()) < sequence) {
                        if (!LoggerServiceImpl.this.running) {
                            LoggerServiceImpl.this.disruptor.halt();
                            throw AlertException.INSTANCE;
                        }
                        barrier.checkAlert();
                        this.lock.wait();
                    }
                    --this.numWaiters;
                }
            }
            if (0 != dependents.length) {
                while ((availableSequence = Util.getMinimumSequence((Sequence[])dependents)) < sequence) {
                    barrier.checkAlert();
                }
            }
            return availableSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long waitFor(long sequence, Sequence cursor, Sequence[] dependents, SequenceBarrier barrier, long timeout, TimeUnit sourceUnit) throws AlertException, InterruptedException {
            long availableSequence = cursor.get();
            if (availableSequence < sequence) {
                long timeoutMs = sourceUnit.toMillis(timeout);
                long startTime = System.currentTimeMillis();
                LoggerServiceImpl.this.flush();
                Object object = this.lock;
                synchronized (object) {
                    ++this.numWaiters;
                    while ((availableSequence = cursor.get()) < sequence) {
                        barrier.checkAlert();
                        if (!LoggerServiceImpl.this.running) {
                            LoggerServiceImpl.this.disruptor.halt();
                            throw AlertException.INSTANCE;
                        }
                        this.lock.wait(timeoutMs);
                        if (this.signalled && System.currentTimeMillis() - startTime <= timeoutMs) continue;
                    }
                    --this.numWaiters;
                }
            }
            if (0 != dependents.length) {
                while ((availableSequence = Util.getMinimumSequence((Sequence[])dependents)) < sequence) {
                    barrier.checkAlert();
                }
            }
            return availableSequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void signalAllWhenBlocking() {
            if (0 != this.numWaiters) {
                Object object = this.lock;
                synchronized (object) {
                    this.signalled = true;
                    this.lock.notifyAll();
                }
            }
        }
    }
}

