/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.formatter;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import sun.misc.Cleaner;
import sun.misc.FloatingDecimal;
import sun.nio.ch.DirectBuffer;

public class BufferFormatter {
    public static final int[] INT_SIZE_TABLE = new int[]{10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000, Integer.MAX_VALUE};
    public static final long[] LONG_SIZE_TABLE = new long[]{10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L, Long.MAX_VALUE};
    public static final char[] DIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    public static final char[] DIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final byte[] BDIGIT_TENS = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    public static final byte[] BDIGIT_ONES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    public static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final byte[] BDIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    public static final long SIGN_MASK = Long.MIN_VALUE;
    public static final long EXP_MASK = 0x7FF0000000000000L;
    public static final long MANTISA_MASK = 0xFFFFFFFFFFFFFL;
    public static final long EXP_BIAS = 1023L;
    public static final int EXP_SHIFT = 52;
    public static final long FRACT_HOB = 0x10000000000000L;
    public static final long EXP_ONE = 0x3FF0000000000000L;
    public static final String INFINITY = "Infinity";
    public static final String NAN = "NaN";
    public static final String ZERO_DOT_ZERO = "0.0";
    public static final int DOUBLE_DIGITS = 15;

    public static ByteBuffer allocate(int capacity) {
        boolean direct = Boolean.parseBoolean(System.getProperty("gflogger.direct", "true"));
        return direct ? ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder()) : ByteBuffer.allocate(capacity);
    }

    public static void purge(Buffer buffer) {
        if (!(buffer instanceof DirectBuffer)) {
            return;
        }
        DirectBuffer db = (DirectBuffer)((Object)buffer);
        Cleaner cleaner = db.cleaner();
        if (cleaner != null) {
            cleaner.clean();
        } else {
            Object viewedBuffer = db.viewedBuffer();
            if (viewedBuffer instanceof Buffer) {
                BufferFormatter.purge((Buffer)viewedBuffer);
            }
        }
    }

    public static int roundUpNextPower2(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public static ByteBuffer append1(ByteBuffer buffer, CharSequence s) {
        int length = s != null ? s.length() : 0;
        buffer.put((byte)length);
        if (length == 0) {
            return buffer;
        }
        return BufferFormatter.append(buffer, s, 0, length);
    }

    public static ByteBuffer append(ByteBuffer buffer, CharSequence s) {
        return BufferFormatter.append(buffer, s, 0, s != null ? s.length() : 0);
    }

    public static ByteBuffer append(ByteBuffer buffer, CharSequence s, int start, int end) {
        if (s == null) {
            assert (buffer.remaining() >= 4);
            return buffer.put((byte)110).put((byte)117).put((byte)108).put((byte)108);
        }
        assert (buffer.remaining() >= end - start);
        for (int i = start; i < end; ++i) {
            buffer.put((byte)s.charAt(i));
        }
        return buffer;
    }

    public static ByteBuffer append(ByteBuffer buffer, boolean b) {
        if (b) {
            assert (buffer.remaining() >= 4);
            return buffer.put((byte)116).put((byte)114).put((byte)117).put((byte)101);
        }
        assert (buffer.remaining() >= 5);
        return buffer.put((byte)102).put((byte)97).put((byte)108).put((byte)115).put((byte)101);
    }

    public static CharBuffer append(CharBuffer buffer, boolean b) {
        if (b) {
            assert (buffer.remaining() >= 4);
            return buffer.put('t').put('r').put('u').put('e');
        }
        assert (buffer.remaining() >= 5);
        return buffer.put('f').put('a').put('l').put('s').put('e');
    }

    public static CharBuffer append(CharBuffer buffer, CharSequence s) {
        return BufferFormatter.append(buffer, s, 0, s != null ? s.length() : 0);
    }

    public static CharBuffer append(CharBuffer buffer, CharSequence s, int start, int end) {
        if (s != null) {
            assert (buffer.remaining() >= end - start);
            for (int i = start; i < end; ++i) {
                buffer.put(s.charAt(i));
            }
            return buffer;
        }
        assert (buffer.remaining() >= 4);
        return buffer.put('n').put('u').put('l').put('l');
    }

    public static CharBuffer append(CharBuffer buffer, byte b) {
        char sign = '\u0000';
        int i = b;
        int size = 0;
        if (i < 0) {
            sign = '-';
            i = -i;
            ++size;
        }
        assert (buffer.remaining() >= (size += i > 100 ? 3 : (i > 10 ? 2 : 1)));
        int j = i;
        if (sign != '\u0000') {
            buffer.put(sign);
        }
        if (i >= 100) {
            buffer.put(DIGIT_ONES[1]);
            i -= 100;
        }
        if (i >= 10 || j >= 100) {
            buffer.put(DIGIT_TENS[i]);
        }
        buffer.put(DIGIT_ONES[i]);
        return buffer;
    }

    public static CharBuffer append(CharBuffer buffer, int i) {
        if (i == Integer.MIN_VALUE) {
            return BufferFormatter.append(buffer, (CharSequence)Integer.toString(i));
        }
        BufferFormatter.put(buffer, i);
        return buffer;
    }

    public static ByteBuffer append(ByteBuffer buffer, char i) {
        buffer.put((byte)i);
        return buffer;
    }

    public static ByteBuffer append(ByteBuffer buffer, int i) {
        if (i == Integer.MIN_VALUE) {
            return BufferFormatter.append(buffer, (CharSequence)Integer.toString(i));
        }
        BufferFormatter.put(buffer, i);
        return buffer;
    }

    public static ByteBuffer append(ByteBuffer buffer, long i) {
        if (i == Long.MIN_VALUE) {
            return BufferFormatter.append(buffer, (CharSequence)Long.toString(i));
        }
        BufferFormatter.put(buffer, i);
        return buffer;
    }

    public static CharBuffer append(CharBuffer buffer, long i) {
        if (i == Long.MIN_VALUE) {
            return BufferFormatter.append(buffer, (CharSequence)Long.toString(i));
        }
        BufferFormatter.put(buffer, i);
        return buffer;
    }

    public static ByteBuffer append(ByteBuffer buffer, double i, int precision) {
        BufferFormatter.put(buffer, i, precision < 0 ? 8 : precision, true);
        return buffer;
    }

    public static CharBuffer append(CharBuffer buffer, double i, int precision) {
        BufferFormatter.put(buffer, i, precision < 0 ? 8 : precision, true);
        return buffer;
    }

    public static ByteBuffer append(ByteBuffer buffer, double v) {
        BufferFormatter.put(buffer, v);
        return buffer;
    }

    public static CharBuffer append(CharBuffer buffer, double v) {
        BufferFormatter.put(buffer, v);
        return buffer;
    }

    public static int stringSize(int x) {
        for (int i = 0; i < INT_SIZE_TABLE.length; ++i) {
            if (x >= INT_SIZE_TABLE[i]) continue;
            return i + 1;
        }
        return INT_SIZE_TABLE.length;
    }

    private static void put(CharBuffer buffer, int i) {
        int r;
        int q;
        int size;
        int n = size = i < 0 ? BufferFormatter.stringSize(-i) + 1 : BufferFormatter.stringSize(i);
        assert (buffer.remaining() >= size);
        if (i < 0) {
            buffer.put('-');
            --size;
            i = -i;
        }
        int charPos = size;
        int oldPos = buffer.position();
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_ONES[r]);
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_TENS[r]);
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGITS[r]);
        } while ((i = q) != 0);
        buffer.position(oldPos + size);
    }

    private static void put(ByteBuffer buffer, int i) {
        int r;
        int q;
        int size;
        int n = size = i < 0 ? BufferFormatter.stringSize(-i) + 1 : BufferFormatter.stringSize(i);
        assert (buffer.remaining() >= size);
        int charPos = size;
        int oldPos = buffer.position();
        char sign = '\u0000';
        if (i < 0) {
            sign = '-';
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_ONES[r]);
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_TENS[r]);
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGITS[r]);
        } while ((i = q) != 0);
        if (sign != '\u0000') {
            BufferFormatter.putAt(buffer, oldPos + --charPos, sign);
        }
        buffer.position(oldPos + size);
    }

    public static int stringSize(long x) {
        for (int i = 0; i < LONG_SIZE_TABLE.length; ++i) {
            if (x >= LONG_SIZE_TABLE[i]) continue;
            return i + 1;
        }
        return LONG_SIZE_TABLE.length;
    }

    private static void put(CharBuffer buffer, long i) {
        int q2;
        int r;
        int size;
        int n = size = i < 0L ? BufferFormatter.stringSize(-i) + 1 : BufferFormatter.stringSize(i);
        assert (buffer.remaining() >= size);
        int oldPos = buffer.position();
        int charPos = size;
        char sign = '\u0000';
        if (i < 0L) {
            sign = '-';
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_ONES[r]);
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_TENS[r]);
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_ONES[r]);
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_TENS[r]);
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGITS[r]);
        } while ((i2 = q2) != 0);
        if (sign != '\u0000') {
            BufferFormatter.putAt(buffer, oldPos + --charPos, sign);
        }
        buffer.position(oldPos + size);
    }

    private static void put(ByteBuffer buffer, long i) {
        int q2;
        int r;
        int size;
        int n = size = i < 0L ? BufferFormatter.stringSize(-i) + 1 : BufferFormatter.stringSize(i);
        assert (buffer.remaining() >= size);
        int oldPos = buffer.position();
        int charPos = size;
        char sign = '\u0000';
        if (i < 0L) {
            sign = '-';
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_ONES[r]);
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_TENS[r]);
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_ONES[r]);
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGIT_TENS[r]);
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            BufferFormatter.putAt(buffer, oldPos + --charPos, DIGITS[r]);
        } while ((i2 = q2) != 0);
        if (sign != '\u0000') {
            BufferFormatter.putAt(buffer, oldPos + --charPos, sign);
        }
        buffer.position(oldPos + size);
    }

    private static void putAt(CharBuffer buffer, int pos, char b) {
        buffer.position(pos);
        buffer.append(b);
    }

    private static void putAt(ByteBuffer buffer, int pos, char b) {
        buffer.position(pos);
        buffer.put((byte)b);
    }

    private static void put(ByteBuffer buffer, double v) {
        boolean isNegative;
        if (Double.isNaN(v)) {
            BufferFormatter.append(buffer, (CharSequence)NAN);
            return;
        }
        long d = Double.doubleToRawLongBits(v);
        boolean bl = isNegative = (d & Long.MIN_VALUE) != 0L;
        if (isNegative) {
            v = Double.longBitsToDouble(d &= Long.MAX_VALUE);
            buffer.put((byte)45);
        }
        if (v == Double.POSITIVE_INFINITY) {
            BufferFormatter.append(buffer, (CharSequence)INFINITY);
            return;
        }
        if (d == 0L) {
            BufferFormatter.append(buffer, (CharSequence)ZERO_DOT_ZERO);
            return;
        }
        long exp = ((0x7FF0000000000000L & d) >> 52) - 1023L;
        long mants = 0x20000000000000L | 0xFFFFFFFFFFFFFL & d;
        long fractBits = mants;
        double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFEFFFFFFFFFFFFFL);
        int decExp = (int)Math.floor((d2 - 1.5) * 0.289529654 + 0.176091259 + (double)exp * 0.301029995663981);
        BufferFormatter.put(buffer, v, 15 - (decExp > 0 ? decExp : 0), false);
    }

    private static void put(ByteBuffer buffer, double v, int precision, boolean forceTailZeros) {
        boolean isNegative;
        if (Double.isNaN(v)) {
            BufferFormatter.append(buffer, (CharSequence)NAN);
            return;
        }
        long d = Double.doubleToRawLongBits(v);
        boolean bl = isNegative = (d & Long.MIN_VALUE) != 0L;
        if (isNegative) {
            v = Double.longBitsToDouble(d &= Long.MAX_VALUE);
            buffer.put((byte)45);
        }
        if (v == Double.POSITIVE_INFINITY) {
            BufferFormatter.append(buffer, (CharSequence)INFINITY);
            return;
        }
        if (d == 0L) {
            BufferFormatter.append(buffer, (CharSequence)ZERO_DOT_ZERO);
            return;
        }
        if (v > 0.0 && (v > 1.0E18 || v < 1.0E-18) || v < 0.0 && (v < -1.0E18 || v > -1.0E-18)) {
            BufferFormatter.append(buffer, (CharSequence)BufferFormatter.toString(v));
            return;
        }
        long x = (long)v;
        BufferFormatter.put(buffer, x);
        buffer.put((byte)46);
        long usedPrecision = precision > 0 ? (precision - 1 < LONG_SIZE_TABLE.length ? LONG_SIZE_TABLE[precision - 1] : LONG_SIZE_TABLE[LONG_SIZE_TABLE.length - 2]) : 1L;
        x = Math.round((v - (double)x) * (double)usedPrecision);
        int oldPos = buffer.position();
        if (x != 0L) {
            int stringSize = BufferFormatter.stringSize(x);
            int leadingZeros = (precision > 0 ? (precision - 1 < LONG_SIZE_TABLE.length ? precision - 1 : LONG_SIZE_TABLE.length - 2) : 0) - stringSize;
            if (leadingZeros >= 0) {
                for (int i = 0; i <= leadingZeros; ++i) {
                    buffer.put((byte)48);
                }
            }
        }
        BufferFormatter.put(buffer, x);
        if (x != 0L || forceTailZeros) {
            int pos = buffer.position();
            int limit = buffer.limit();
            if (pos - oldPos < precision && pos < limit) {
                int j = precision - (pos - oldPos);
                j = j < limit - pos ? j : limit - pos;
                for (int i = 0; i < j; ++i) {
                    buffer.put((byte)48);
                }
            }
        }
    }

    private static void put(CharBuffer buffer, double v) {
        boolean isNegative;
        if (Double.isNaN(v)) {
            BufferFormatter.append(buffer, (CharSequence)NAN);
            return;
        }
        long d = Double.doubleToRawLongBits(v);
        boolean bl = isNegative = (d & Long.MIN_VALUE) != 0L;
        if (isNegative) {
            v = Double.longBitsToDouble(d &= Long.MAX_VALUE);
            buffer.put('-');
        }
        if (v == Double.POSITIVE_INFINITY) {
            BufferFormatter.append(buffer, (CharSequence)INFINITY);
            return;
        }
        if (d == 0L) {
            BufferFormatter.append(buffer, (CharSequence)ZERO_DOT_ZERO);
            return;
        }
        long exp = ((0x7FF0000000000000L & d) >> 52) - 1023L;
        long mants = 0x20000000000000L | 0xFFFFFFFFFFFFFL & d;
        long fractBits = mants;
        double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFEFFFFFFFFFFFFFL);
        int decExp = (int)Math.floor((d2 - 1.5) * 0.289529654 + 0.176091259 + (double)exp * 0.301029995663981);
        BufferFormatter.put(buffer, v, 15 - (decExp > 0 ? decExp : 0), false);
    }

    private static String toString(double v) {
        String javaFormatString = new FloatingDecimal(v).toJavaFormatString();
        return javaFormatString;
    }

    private static void put(CharBuffer buffer, double v, int precision, boolean forceTailZeros) {
        boolean isNegative;
        if (Double.isNaN(v)) {
            BufferFormatter.append(buffer, (CharSequence)NAN);
            return;
        }
        long d = Double.doubleToRawLongBits(v);
        boolean bl = isNegative = (d & Long.MIN_VALUE) != 0L;
        if (isNegative) {
            v = Double.longBitsToDouble(d &= Long.MAX_VALUE);
            buffer.put('-');
        }
        if (v == Double.POSITIVE_INFINITY) {
            BufferFormatter.append(buffer, (CharSequence)INFINITY);
            return;
        }
        if (d == 0L) {
            BufferFormatter.append(buffer, (CharSequence)ZERO_DOT_ZERO);
            return;
        }
        if (v > 0.0 && (v > 1.0E18 || v < 1.0E-18) || v < 0.0 && (v < -1.0E18 || v > -1.0E-18)) {
            BufferFormatter.append(buffer, (CharSequence)BufferFormatter.toString(v));
            return;
        }
        long x = (long)v;
        BufferFormatter.put(buffer, x);
        buffer.put('.');
        long usedPrecision = precision > 0 ? (precision - 1 < LONG_SIZE_TABLE.length ? LONG_SIZE_TABLE[precision - 1] : LONG_SIZE_TABLE[LONG_SIZE_TABLE.length - 2]) : 1L;
        x = Math.round((v - (double)x) * (double)usedPrecision);
        int oldPos = buffer.position();
        if (x != 0L) {
            int stringSize = BufferFormatter.stringSize(x);
            int leadingZeros = (precision > 0 ? (precision - 1 < LONG_SIZE_TABLE.length ? precision - 1 : LONG_SIZE_TABLE.length - 2) : 0) - stringSize;
            if (leadingZeros >= 0) {
                for (int i = 0; i <= leadingZeros; ++i) {
                    buffer.put('0');
                }
            }
        }
        BufferFormatter.put(buffer, x);
        if (x != 0L || forceTailZeros) {
            int pos = buffer.position();
            int limit = buffer.limit();
            if (pos - oldPos < precision && pos < limit) {
                int j = precision - (pos - oldPos);
                j = j < limit - pos ? j : limit - pos;
                for (int i = 0; i < j; ++i) {
                    buffer.put('0');
                }
            }
        }
    }
}

