/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.formatter;

import com.lmax.disruptor.util.Util;
import java.nio.ByteBuffer;
import org.gflogger.formatter.BufferFormatter;
import org.gflogger.formatter.BytesOverflow;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public final class Bytes {
    private final byte[] bs;
    private int pos;
    private static final Unsafe UNSAFE = Util.getUnsafe();
    private static final long arrayBaseOffset = UNSAFE.arrayBaseOffset(byte[].class);
    private static final int JNI_COPY_TO_ARRAY_THRESHOLD = 6;
    private static final int JNI_COPY_FROM_ARRAY_THRESHOLD = 6;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    public Bytes(int size) {
        this.bs = new byte[size];
    }

    public int size() {
        return this.bs.length;
    }

    public int remaining() {
        return this.bs.length - this.pos;
    }

    public int position() {
        return this.pos;
    }

    public void position(int pos) {
        if (pos < 0 || pos > this.bs.length) {
            throw new IllegalArgumentException("position " + pos + " is out of range [0 .. " + this.bs.length + "]");
        }
        this.pos = pos;
    }

    public void clear() {
        this.pos = 0;
    }

    public void put(boolean b) {
        int remaining = this.remaining();
        if (b) {
            if (remaining < 4) {
                throw BytesOverflow.BYTES_OVERFLOW;
            }
            this.bs[this.pos + 0] = 116;
            this.bs[this.pos + 1] = 114;
            this.bs[this.pos + 2] = 117;
            this.bs[this.pos + 3] = 101;
            this.pos += 4;
            return;
        }
        if (remaining < 5) {
            throw BytesOverflow.BYTES_OVERFLOW;
        }
        this.bs[this.pos + 0] = 102;
        this.bs[this.pos + 1] = 97;
        this.bs[this.pos + 2] = 108;
        this.bs[this.pos + 3] = 115;
        this.bs[this.pos + 4] = 101;
        this.pos += 5;
    }

    public void put(char c) {
        int remaining = this.remaining();
        if (remaining < 1) {
            throw BytesOverflow.BYTES_OVERFLOW;
        }
        this.bs[this.pos++] = (byte)c;
    }

    private void putNull(int remaining) {
        if (remaining < 4) {
            throw BytesOverflow.BYTES_OVERFLOW;
        }
        this.bs[this.pos + 0] = 110;
        this.bs[this.pos + 1] = 117;
        this.bs[this.pos + 2] = 108;
        this.bs[this.pos + 3] = 108;
        this.pos += 4;
    }

    public void put(CharSequence s) {
        int remaining = this.remaining();
        if (s == null) {
            this.putNull(remaining);
            return;
        }
        int len = s.length();
        if (remaining < len) {
            throw BytesOverflow.BYTES_OVERFLOW;
        }
        for (int i = 0; i < len; ++i) {
            this.bs[this.pos++] = (byte)s.charAt(i);
        }
    }

    public void put(CharSequence s, int start, int end) {
        int remaining = this.remaining();
        if (s == null) {
            this.putNull(remaining);
            return;
        }
        if (remaining < end - start) {
            throw BytesOverflow.BYTES_OVERFLOW;
        }
        for (int i = start; i < end; ++i) {
            this.bs[this.pos++] = (byte)s.charAt(i);
        }
    }

    public void put(int i) {
        int r;
        int q;
        int size;
        if (i == Integer.MIN_VALUE) {
            this.put(Integer.toString(i));
            return;
        }
        int n = size = i < 0 ? BufferFormatter.stringSize(-i) + 1 : BufferFormatter.stringSize(i);
        if (this.remaining() < size) {
            throw BytesOverflow.BYTES_OVERFLOW;
        }
        if (i < 0) {
            this.bs[this.pos++] = 45;
            --size;
            i = -i;
        }
        int charPos = size;
        int oldPos = this.pos;
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            this.bs[oldPos + --charPos] = BufferFormatter.BDIGIT_ONES[r];
            this.bs[oldPos + --charPos] = BufferFormatter.BDIGIT_TENS[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            this.bs[oldPos + --charPos] = BufferFormatter.BDIGITS[r];
        } while ((i = q) != 0);
        this.pos = oldPos + size;
    }

    public void put(long i) {
        int q2;
        int r;
        int size;
        if (i == Long.MIN_VALUE) {
            this.put(Long.toString(i));
            return;
        }
        int n = size = i < 0L ? BufferFormatter.stringSize(-i) + 1 : BufferFormatter.stringSize(i);
        if (this.remaining() < size) {
            throw BytesOverflow.BYTES_OVERFLOW;
        }
        if (i < 0L) {
            this.bs[this.pos++] = 45;
            --size;
            i = -i;
        }
        int oldPos = this.pos;
        int charPos = size;
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            this.bs[oldPos + --charPos] = BufferFormatter.BDIGIT_ONES[r];
            this.bs[oldPos + --charPos] = BufferFormatter.BDIGIT_TENS[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            this.bs[oldPos + --charPos] = BufferFormatter.BDIGIT_ONES[r];
            this.bs[oldPos + --charPos] = BufferFormatter.BDIGIT_TENS[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            this.bs[oldPos + --charPos] = BufferFormatter.BDIGITS[r];
        } while ((i2 = q2) != 0);
        this.pos = oldPos + size;
    }

    public void put(double i, int precision) {
        long x = (long)i;
        this.put(x);
        this.bs[this.pos++] = 46;
        x = (long)((i - (double)x) * (double)(precision > 0 ? BufferFormatter.LONG_SIZE_TABLE[precision - 1] : 1L));
        this.put(x < 0L ? -x : x);
    }

    public String asString() {
        return new String(this.bs, 0, this.pos);
    }

    public void copyTo(ByteBuffer buffer) {
        if (buffer.isDirect() && this.pos > 6) {
            DirectBuffer db = (DirectBuffer)((Object)buffer);
            Bytes.copyFromArray(this.bs, arrayBaseOffset, 0L, db.address(), this.pos << 0);
            buffer.position(buffer.position() + this.pos);
        } else {
            buffer.put(this.bs, 0, this.pos);
        }
    }

    private static void copyFromArray(Object src, long srcBaseOffset, long srcPos, long dstAddr, long length) {
        long offset = srcBaseOffset + srcPos;
        while (length > 0L) {
            long size = length > 0x100000L ? 0x100000L : length;
            UNSAFE.copyMemory(src, offset, null, dstAddr, size);
            length -= size;
            offset += size;
            dstAddr += size;
        }
    }
}

