/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.helpers;

import org.gflogger.LogLevel;
import org.gflogger.helpers.OptionConverter;

public class LogLog {
    protected static LogLevel internalLogLevel = LogLevel.INFO;
    private static boolean quietMode;
    private static final String PREFIX = "gflogger: ";
    private static final String ERR_PREFIX = "gflogger:ERROR ";
    private static final String WARN_PREFIX = "gflogger:WARN ";

    private static boolean isLoggable(LogLevel level) {
        return !quietMode && LogLog.isLoggable0(level);
    }

    public static boolean isLoggable0(LogLevel level) {
        return !internalLogLevel.greaterThan(level);
    }

    public static void debug(String msg) {
        if (LogLog.isLoggable(LogLevel.DEBUG)) {
            System.out.println(PREFIX + msg);
        }
    }

    public static void info(String msg) {
        if (LogLog.isLoggable(LogLevel.INFO)) {
            System.out.println(PREFIX + msg);
        }
    }

    public static void debug(String msg, Throwable t) {
        if (LogLog.isLoggable(LogLevel.DEBUG)) {
            System.out.println(PREFIX + msg);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    public static void error(String msg) {
        if (LogLog.isLoggable0(LogLevel.ERROR)) {
            System.err.println(ERR_PREFIX + msg);
        }
    }

    public static void error(String msg, Throwable t) {
        if (LogLog.isLoggable0(LogLevel.ERROR)) {
            System.err.println(ERR_PREFIX + msg);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    public static void setQuietMode(boolean quietMode) {
        LogLog.quietMode = quietMode;
    }

    public static void warn(String msg) {
        if (LogLog.isLoggable0(LogLevel.WARN)) {
            System.err.println(WARN_PREFIX + msg);
        }
    }

    public static void warn(String msg, Throwable t) {
        if (LogLog.isLoggable0(LogLevel.WARN)) {
            System.err.println(WARN_PREFIX + msg);
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    static {
        String value = OptionConverter.getStringProperty("gflogger.internalLogLevel", "INFO");
        try {
            internalLogLevel = LogLevel.valueOf(value);
        }
        catch (Throwable e) {
            System.err.println("Unable to parse internal log level of '" + value + "'");
        }
        quietMode = OptionConverter.getBooleanProperty("gflogger.internalQuietMode", false);
    }
}

