/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.helpers;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.gflogger.LogEntryItem;
import org.gflogger.formatter.BufferFormatter;
import org.gflogger.helpers.FormattingInfo;

public abstract class PatternConverter {
    public PatternConverter next;
    int min = -1;
    int max = Integer.MAX_VALUE;
    boolean leftAlign = false;
    static String[] SPACES = new String[]{" ", "  ", "    ", "        ", "                ", "                                "};

    protected PatternConverter() {
    }

    protected PatternConverter(FormattingInfo fi) {
        this.min = fi.min;
        this.max = fi.max;
        this.leftAlign = fi.leftAlign;
    }

    public abstract void format(ByteBuffer var1, LogEntryItem var2);

    public abstract void format(CharBuffer var1, LogEntryItem var2);

    public abstract int size(LogEntryItem var1);

    public void spacePad(ByteBuffer buffer, int length) {
        while (length >= 32) {
            BufferFormatter.append(buffer, (CharSequence)SPACES[5]);
            length -= 32;
        }
        for (int i = 4; i >= 0; --i) {
            if ((length & 1 << i) == 0) continue;
            BufferFormatter.append(buffer, (CharSequence)SPACES[i]);
        }
    }

    public void spacePad(CharBuffer buffer, int length) {
        while (length >= 32) {
            buffer.append(SPACES[5]);
            length -= 32;
        }
        for (int i = 4; i >= 0; --i) {
            if ((length & 1 << i) == 0) continue;
            buffer.append(SPACES[i]);
        }
    }
}

