/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.helpers;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Locale;
import java.util.TimeZone;
import org.gflogger.Layout;
import org.gflogger.LogEntryItem;
import org.gflogger.formatter.BufferFormatter;
import org.gflogger.formatter.FastDateFormat;
import org.gflogger.helpers.FormattingInfo;
import org.gflogger.helpers.LogLog;
import org.gflogger.helpers.PatternConverter;

public class PatternParser {
    private static final char ESCAPE_CHAR = '%';
    private static final int LITERAL_STATE = 0;
    private static final int CONVERTER_STATE = 1;
    private static final int DOT_STATE = 3;
    private static final int MIN_STATE = 4;
    private static final int MAX_STATE = 5;
    static final int RELATIVE_TIME_CONVERTER = 2000;
    static final int THREAD_CONVERTER = 2001;
    static final int LEVEL_CONVERTER = 2002;
    static final int MESSAGE_CONVERTER = 2004;
    int state;
    protected StringBuffer currentLiteral = new StringBuffer(32);
    protected int patternLength;
    protected int i;
    PatternConverter head;
    PatternConverter tail;
    protected FormattingInfo formattingInfo = new FormattingInfo();
    protected final String pattern;
    protected final Locale locale;
    protected final TimeZone timeZone;

    public PatternParser(String pattern, Locale locale, TimeZone timeZone) {
        this.pattern = pattern;
        this.locale = locale;
        this.timeZone = timeZone;
        this.patternLength = pattern.length();
        this.state = 0;
    }

    private void addToList(PatternConverter pc) {
        if (this.head == null) {
            this.head = this.tail = pc;
        } else {
            this.tail.next = pc;
            this.tail = pc;
        }
    }

    protected String extractOption() {
        int end;
        if (this.i < this.patternLength && this.pattern.charAt(this.i) == '{' && (end = this.pattern.indexOf(125, this.i)) > this.i) {
            String r = this.pattern.substring(this.i + 1, end);
            this.i = end + 1;
            return r;
        }
        return null;
    }

    protected int extractPrecisionOption() {
        String opt = this.extractOption();
        int r = 0;
        if (opt != null) {
            try {
                r = Integer.parseInt(opt);
                if (r <= 0) {
                    LogLog.error("Precision option (" + opt + ") isn't a positive integer.");
                    r = 0;
                }
            }
            catch (NumberFormatException e) {
                LogLog.error("Category option \"" + opt + "\" not a decimal integer.", e);
            }
        }
        return r;
    }

    public PatternConverter parse() {
        this.i = 0;
        while (this.i < this.patternLength) {
            char c = this.pattern.charAt(this.i++);
            block0 : switch (this.state) {
                case 0: {
                    if (this.i == this.patternLength) {
                        this.currentLiteral.append(c);
                        break;
                    }
                    if (c == '%') {
                        switch (this.pattern.charAt(this.i)) {
                            case '%': {
                                this.currentLiteral.append(c);
                                ++this.i;
                                break block0;
                            }
                            case 'n': {
                                this.currentLiteral.append(Layout.LINE_SEP);
                                ++this.i;
                                break block0;
                            }
                        }
                        if (this.currentLiteral.length() != 0) {
                            this.addToList(new LiteralPatternConverter(this.currentLiteral.toString()));
                            LogLog.debug("Parsed LITERAL converter: \"" + this.currentLiteral + "\".");
                        }
                        this.currentLiteral.setLength(0);
                        this.currentLiteral.append(c);
                        this.state = 1;
                        this.formattingInfo.reset();
                        break;
                    }
                    this.currentLiteral.append(c);
                    break;
                }
                case 1: {
                    this.currentLiteral.append(c);
                    switch (c) {
                        case '-': {
                            this.formattingInfo.leftAlign = true;
                            break block0;
                        }
                        case '.': {
                            this.state = 3;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.min = c - 48;
                        this.state = 4;
                        break;
                    }
                    this.finalizeConverter(c);
                    break;
                }
                case 4: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.min = this.formattingInfo.min * 10 + (c - 48);
                        break;
                    }
                    if (c == '.') {
                        this.state = 3;
                        break;
                    }
                    this.finalizeConverter(c);
                    break;
                }
                case 3: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.max = c - 48;
                        this.state = 5;
                        break;
                    }
                    LogLog.error("Error occured in position " + this.i + ".\n Was expecting digit, instead got char \"" + c + "\".");
                    this.state = 0;
                    break;
                }
                case 5: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.max = this.formattingInfo.max * 10 + (c - 48);
                        break;
                    }
                    this.finalizeConverter(c);
                    this.state = 0;
                }
            }
        }
        if (this.currentLiteral.length() != 0) {
            this.addToList(new LiteralPatternConverter(this.currentLiteral.toString()));
            LogLog.debug("Parsed LITERAL converter: \"" + this.currentLiteral + "\".");
        }
        return this.head;
    }

    protected void finalizeConverter(char c) {
        PatternConverter pc = null;
        switch (c) {
            case 'c': {
                pc = new CategoryPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                LogLog.debug("CATEGORY converter.");
                this.formattingInfo.dump();
                this.currentLiteral.setLength(0);
                break;
            }
            case 'd': {
                String dateFormatStr = "ISO8601";
                FastDateFormat df = null;
                String dOpt = this.extractOption();
                if (dOpt != null) {
                    dateFormatStr = dOpt;
                }
                try {
                    df = FastDateFormat.getInstance(dateFormatStr, this.timeZone, this.locale);
                }
                catch (IllegalArgumentException e) {
                    LogLog.error("Could not instantiate SimpleDateFormat with " + dateFormatStr, e);
                    break;
                }
                pc = new DatePatternConverter(this.formattingInfo, df);
                LogLog.debug("DATE converter {" + dateFormatStr + "}.");
                this.formattingInfo.dump();
                this.currentLiteral.setLength(0);
                break;
            }
            case 'm': {
                pc = new BasicPatternConverter(this.formattingInfo, 2004);
                LogLog.debug("MESSAGE converter.");
                this.formattingInfo.dump();
                this.currentLiteral.setLength(0);
                break;
            }
            case 'p': {
                pc = new BasicPatternConverter(this.formattingInfo, 2002);
                LogLog.debug("LEVEL converter.");
                this.formattingInfo.dump();
                this.currentLiteral.setLength(0);
                break;
            }
            case 'r': {
                pc = new BasicPatternConverter(this.formattingInfo, 2000);
                LogLog.debug("RELATIVE time converter.");
                this.formattingInfo.dump();
                this.currentLiteral.setLength(0);
                break;
            }
            case 't': {
                pc = new BasicPatternConverter(this.formattingInfo, 2001);
                LogLog.debug("THREAD converter.");
                this.formattingInfo.dump();
                this.currentLiteral.setLength(0);
                break;
            }
            default: {
                LogLog.error("Unexpected char [" + c + "] at position " + this.i + " in conversion patterrn.");
                pc = new LiteralPatternConverter(this.currentLiteral.toString());
                this.currentLiteral.setLength(0);
            }
        }
        this.addConverter(pc);
    }

    protected void addConverter(PatternConverter pc) {
        this.currentLiteral.setLength(0);
        this.addToList(pc);
        this.state = 0;
        this.formattingInfo.reset();
    }

    private class CategoryPatternConverter
    extends NamedPatternConverter {
        CategoryPatternConverter(FormattingInfo formattingInfo, int precision) {
            super(formattingInfo, precision);
        }

        @Override
        String getFullyQualifiedName(LogEntryItem item) {
            return item.getCategoryName();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append("%category");
            if (this.next != null) {
                builder.append(" ").append(this.next);
            }
            return builder.toString();
        }
    }

    private static abstract class NamedPatternConverter
    extends PatternConverter {
        int precision;

        NamedPatternConverter(FormattingInfo formattingInfo, int precision) {
            super(formattingInfo);
            this.precision = precision;
        }

        abstract String getFullyQualifiedName(LogEntryItem var1);

        @Override
        public int size(LogEntryItem item) {
            String n = this.getFullyQualifiedName(item);
            if (this.precision <= 0) {
                return n.length();
            }
            int len = n.length();
            int end = len - 1;
            for (int i = this.precision; i > 0 && end > 0; --i) {
                end = n.lastIndexOf(46, end - 1);
            }
            return len - (end + 1);
        }

        @Override
        public void format(ByteBuffer buffer, LogEntryItem item) {
            String n = this.getFullyQualifiedName(item);
            if (this.precision <= 0) {
                BufferFormatter.append(buffer, (CharSequence)n);
            } else {
                int len = n.length();
                int end = len - 1;
                for (int i = this.precision; i > 0 && end > 0; --i) {
                    end = n.lastIndexOf(46, end - 1);
                }
                BufferFormatter.append(buffer, (CharSequence)n, end + 1, len);
            }
        }

        @Override
        public void format(CharBuffer buffer, LogEntryItem item) {
            String n = this.getFullyQualifiedName(item);
            if (this.precision <= 0) {
                BufferFormatter.append(buffer, (CharSequence)n);
            } else {
                int len = n.length();
                int end = len - 1;
                for (int i = this.precision; i > 0 && end > 0; --i) {
                    end = n.lastIndexOf(46, end - 1);
                }
                BufferFormatter.append(buffer, (CharSequence)n, end + 1, len);
            }
        }
    }

    private static class DatePatternConverter
    extends PatternConverter {
        private FastDateFormat df;

        DatePatternConverter(FormattingInfo formattingInfo, FastDateFormat df) {
            super(formattingInfo);
            this.df = df;
        }

        @Override
        public void format(ByteBuffer buffer, LogEntryItem logEntryItem) {
            this.df.format(logEntryItem.getTimestamp(), buffer);
        }

        @Override
        public void format(CharBuffer buffer, LogEntryItem logEntryItem) {
            this.df.format(logEntryItem.getTimestamp(), buffer);
        }

        @Override
        public int size(LogEntryItem entry) {
            return this.df.getMaxLengthEstimate();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append("%date");
            if (this.next != null) {
                builder.append(" ").append(this.next);
            }
            return builder.toString();
        }
    }

    private static class LiteralPatternConverter
    extends PatternConverter {
        private String literal;

        LiteralPatternConverter(String value) {
            this.literal = value;
        }

        @Override
        public void format(ByteBuffer buffer, LogEntryItem logEntryItem) {
            BufferFormatter.append(buffer, (CharSequence)this.literal);
        }

        @Override
        public void format(CharBuffer buffer, LogEntryItem logEntryItem) {
            BufferFormatter.append(buffer, (CharSequence)this.literal);
        }

        @Override
        public int size(LogEntryItem entry) {
            return this.literal.length();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.literal);
            if (this.next != null) {
                builder.append(" ").append(this.next);
            }
            return builder.toString();
        }
    }

    private static class BasicPatternConverter
    extends PatternConverter {
        int type;

        BasicPatternConverter(FormattingInfo formattingInfo, int type) {
            super(formattingInfo);
            this.type = type;
        }

        @Override
        public void format(ByteBuffer buffer, LogEntryItem item) {
            switch (this.type) {
                case 2000: {
                    BufferFormatter.append(buffer, item.getTimestamp() - LogEntryItem.startTime);
                    break;
                }
                case 2001: {
                    BufferFormatter.append(buffer, (CharSequence)item.getThreadName());
                    return;
                }
                case 2002: {
                    BufferFormatter.append(buffer, (CharSequence)item.getLogLevel().name());
                    return;
                }
                case 2004: {
                    buffer.put(item.getBuffer());
                    return;
                }
            }
        }

        @Override
        public void format(CharBuffer buffer, LogEntryItem item) {
            switch (this.type) {
                case 2000: {
                    BufferFormatter.append(buffer, item.getTimestamp() - LogEntryItem.startTime);
                    break;
                }
                case 2001: {
                    BufferFormatter.append(buffer, (CharSequence)item.getThreadName());
                    return;
                }
                case 2002: {
                    BufferFormatter.append(buffer, (CharSequence)item.getLogLevel().name());
                    return;
                }
                case 2004: {
                    buffer.put(item.getCharBuffer());
                    return;
                }
            }
        }

        @Override
        public int size(LogEntryItem item) {
            switch (this.type) {
                case 2000: {
                    return BufferFormatter.stringSize(item.getTimestamp() - LogEntryItem.startTime);
                }
                case 2001: {
                    return item.getThreadName().length();
                }
                case 2002: {
                    return item.getLogLevel().name().length();
                }
                case 2004: {
                    ByteBuffer buffer = item.getBuffer();
                    return buffer.limit() - buffer.position();
                }
            }
            return 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            switch (this.type) {
                case 2000: {
                    builder.append("%time");
                    break;
                }
                case 2001: {
                    builder.append("%thread");
                    break;
                }
                case 2002: {
                    builder.append("%level");
                    break;
                }
                case 2004: {
                    builder.append("%msg");
                    break;
                }
                default: {
                    builder.append("%unkown");
                }
            }
            if (this.next != null) {
                builder.append(" ").append(this.next);
            }
            return builder.toString();
        }
    }
}

