/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.log4j;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.gflogger.DefaultObjectFormatterFactory;
import org.gflogger.FormattedGFLogEntry;
import org.gflogger.GFLogEntry;
import org.gflogger.LogLevel;
import org.gflogger.Loggable;
import org.gflogger.ObjectFormatter;
import org.gflogger.ObjectFormatterFactory;
import org.gflogger.formatter.BufferFormatter;
import org.gflogger.util.StackTraceUtils;

public class Log4jEntry
implements GFLogEntry,
FormattedGFLogEntry {
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private final Log log;
    private final StringBuilder builder;
    private LogLevel logLevel;
    private final ObjectFormatterFactory formatterFactory = new DefaultObjectFormatterFactory();
    private String pattern;
    private int pPos;

    public Log4jEntry(Log log) {
        this.log = log;
        this.builder = new StringBuilder(2048);
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("expected not null pattern.");
        }
        this.pattern = pattern;
        this.pPos = 0;
        this.appendNextPatternChank();
    }

    protected void appendNextPatternChank() {
        int len = this.pattern.length();
        while (this.pPos < len) {
            char ch = this.pattern.charAt(this.pPos);
            if (ch == '%' && this.pPos + 1 < len) {
                if (this.pattern.charAt(this.pPos + 1) != '%') break;
                ++this.pPos;
            }
            this.append(ch);
            ++this.pPos;
        }
        if (this.pPos == len) {
            this.commit();
        }
    }

    protected void checkPlaceholder() {
        if (this.pattern == null) {
            throw new IllegalStateException("Entry has been commited.");
        }
        if (this.pPos + 2 >= this.pattern.length()) {
            throw new IllegalStateException("Illegal pattern '" + this.pattern + "' or position " + this.pPos);
        }
        char ch1 = this.pattern.charAt(this.pPos);
        char ch2 = this.pattern.charAt(this.pPos + 1);
        if (ch1 != '%' || ch2 != 's') {
            throw new IllegalArgumentException("Illegal pattern placeholder '" + ch1 + "" + ch2 + " at " + this.pPos);
        }
        this.pPos += 2;
    }

    protected void checkAndCommit() {
        if (this.pattern == null) {
            return;
        }
        if (this.pPos + 1 != this.pattern.length()) {
            throw new IllegalStateException("The pattern has not been finished. More parameters are required.");
        }
        this.commit();
    }

    public void reset() {
        this.builder.setLength(0);
    }

    @Override
    public GFLogEntry append(char c) {
        this.builder.append(c);
        return this;
    }

    @Override
    public GFLogEntry append(CharSequence csq) {
        this.builder.append(csq);
        return this;
    }

    @Override
    public GFLogEntry append(CharSequence csq, int start, int end) {
        this.builder.append(csq, start, end);
        return this;
    }

    @Override
    public GFLogEntry append(boolean b) {
        this.builder.append(b);
        return this;
    }

    @Override
    public GFLogEntry append(int i) {
        this.builder.append(i);
        return this;
    }

    @Override
    public GFLogEntry append(long i) {
        this.builder.append(i);
        return this;
    }

    @Override
    public GFLogEntry append(double i) {
        this.builder.append(i);
        return this;
    }

    @Override
    public GFLogEntry append(double i, int precision) {
        long x = (long)i;
        this.builder.append(x);
        this.builder.append('.');
        x = (long)((i - (double)x) * (double)(precision > 0 ? BufferFormatter.LONG_SIZE_TABLE[precision - 1] : 1L));
        this.builder.append(x < 0L ? -x : x);
        return this;
    }

    @Override
    public <T> GFLogEntry append(T[] array, String separator) {
        if (array != null) {
            try {
                this.append('[');
                ObjectFormatter formatter = null;
                for (int i = 0; i < array.length; ++i) {
                    T obj;
                    if (i > 0) {
                        this.append(separator);
                    }
                    if ((obj = array[i]) != null) {
                        if (formatter == null) {
                            formatter = this.formatterFactory.getObjectFormatter(obj);
                        }
                        formatter.append(obj, this);
                        continue;
                    }
                    this.append('n').append('u').append('l').append('l');
                }
                this.append(']');
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this;
        }
        this.append('n').append('u').append('l').append('l');
        return this;
    }

    @Override
    public <T> GFLogEntry append(Iterable<T> iterable, String separator) {
        if (iterable == null) {
            this.append('n').append('u').append('l').append('l');
        } else {
            try {
                this.append('[');
                ObjectFormatter formatter = null;
                Iterator<T> it = iterable.iterator();
                while (it.hasNext()) {
                    T obj = it.next();
                    if (obj != null) {
                        if (formatter == null) {
                            formatter = this.formatterFactory.getObjectFormatter(obj);
                        }
                        formatter.append(obj, this);
                    } else {
                        this.append('n').append('u').append('l').append('l');
                    }
                    if (!it.hasNext()) continue;
                    this.append(separator);
                }
                this.append(']');
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public GFLogEntry append(Throwable e) {
        if (e != null) {
            try {
                this.append(e.getClass().getName());
                String message = e.getLocalizedMessage();
                if (message != null) {
                    this.append(": ").append(message);
                }
                this.append('\n');
                StackTraceElement[] trace = e.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    this.append("\tat ").append(trace[i].getClassName()).append('.').append(trace[i].getMethodName());
                    this.append('(');
                    if (trace[i].isNativeMethod()) {
                        this.append("native");
                    } else {
                        String fileName = trace[i].getFileName();
                        int lineNumber = trace[i].getLineNumber();
                        if (fileName != null) {
                            Class clazz;
                            this.append(fileName);
                            if (lineNumber >= 0) {
                                this.append(':').append(lineNumber);
                            }
                            if ((clazz = StackTraceUtils.loadClass(trace[i].getClassName())) != null) {
                                this.append('[').append(StackTraceUtils.getCodeLocation(clazz));
                                String implVersion = StackTraceUtils.getImplementationVersion(clazz);
                                if (implVersion != null) {
                                    this.append(':').append(implVersion);
                                }
                                this.append(']');
                            }
                        } else {
                            this.append("unknown");
                        }
                    }
                    this.append(')').append('\n');
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return this;
    }

    @Override
    public GFLogEntry append(Loggable loggable) {
        if (loggable != null) {
            loggable.appendTo(this);
        } else {
            this.append('n').append('u').append('l').append('l');
        }
        return this;
    }

    @Override
    public GFLogEntry append(Object o) {
        try {
            if (o != null) {
                ObjectFormatter formatter = this.formatterFactory.getObjectFormatter(o);
                formatter.append(o, this);
            } else {
                this.append('n').append('u').append('l').append('l');
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public void appendLast(char c) {
        this.append(c);
        this.commit();
    }

    @Override
    public void appendLast(CharSequence csq) {
        this.append(csq);
        this.commit();
    }

    @Override
    public void appendLast(CharSequence csq, int start, int end) {
        this.append(csq, start, end);
        this.commit();
    }

    @Override
    public void appendLast(boolean b) {
        this.append(b);
        this.commit();
    }

    @Override
    public void appendLast(int i) {
        this.append(i);
        this.commit();
    }

    @Override
    public void appendLast(long i) {
        this.append(i);
        this.commit();
    }

    @Override
    public void appendLast(double i) {
        this.append(i);
        this.commit();
    }

    @Override
    public void appendLast(double i, int precision) {
        this.append(i, precision);
        this.commit();
    }

    @Override
    public <T> void appendLast(T[] array, String separator) {
        this.append(array, separator);
        this.commit();
    }

    @Override
    public <T> void appendLast(Iterable<T> iterable, String separator) {
        this.append(iterable, separator);
        this.commit();
    }

    @Override
    public void appendLast(Throwable e) {
        this.append(e);
        this.commit();
    }

    @Override
    public void appendLast(Loggable loggable) {
        this.append(loggable);
        this.commit();
    }

    @Override
    public void appendLast(Object o) {
        this.append(o);
        this.commit();
    }

    @Override
    public FormattedGFLogEntry with(char c) {
        this.checkPlaceholder();
        this.append(c);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(CharSequence csq) {
        this.checkPlaceholder();
        this.append(csq);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(CharSequence csq, int start, int end) {
        this.checkPlaceholder();
        this.append(csq, start, end);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(boolean b) {
        this.checkPlaceholder();
        this.append(b);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(int i) {
        this.checkPlaceholder();
        this.append(i);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(long i) {
        this.checkPlaceholder();
        this.append(i);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(double i) {
        this.checkPlaceholder();
        this.append(i);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(double i, int precision) {
        this.checkPlaceholder();
        this.append(i, precision);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public <T> FormattedGFLogEntry with(T[] array, String separator) {
        this.checkPlaceholder();
        this.append(array, separator);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public <T> FormattedGFLogEntry with(Iterable<T> iterable, String separator) {
        this.checkPlaceholder();
        this.append(iterable, separator);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(Throwable e) {
        this.checkPlaceholder();
        this.append(e);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(Loggable loggable) {
        this.checkPlaceholder();
        this.append(loggable);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public FormattedGFLogEntry with(Object o) {
        this.checkPlaceholder();
        this.append(o);
        this.appendNextPatternChank();
        return this;
    }

    @Override
    public void withLast(char c) {
        this.with(c);
        this.checkAndCommit();
    }

    @Override
    public void withLast(CharSequence csq) {
        this.with(csq);
        this.checkAndCommit();
    }

    @Override
    public void withLast(CharSequence csq, int start, int end) {
        this.with(csq, start, end);
        this.checkAndCommit();
    }

    @Override
    public void withLast(boolean b) {
        this.with(b);
        this.checkAndCommit();
    }

    @Override
    public void withLast(int i) {
        this.with(i);
        this.checkAndCommit();
    }

    @Override
    public void withLast(long i) {
        this.with(i);
        this.checkAndCommit();
    }

    @Override
    public void withLast(double i) {
        this.with(i);
        this.checkAndCommit();
    }

    @Override
    public void withLast(double i, int precision) {
        this.with(i, precision);
        this.checkAndCommit();
    }

    @Override
    public <T> void withLast(T[] array, String separator) {
        this.with(array, separator);
        this.checkAndCommit();
    }

    @Override
    public <T> void withLast(Iterable<T> iterable, String separator) {
        this.with(iterable, separator);
        this.checkAndCommit();
    }

    @Override
    public void withLast(Throwable e) {
        this.with(e);
        this.checkAndCommit();
    }

    @Override
    public void withLast(Loggable loggable) {
        this.with(loggable);
        this.checkAndCommit();
    }

    @Override
    public void withLast(Object o) {
        this.with(o);
        this.checkAndCommit();
    }

    @Override
    public void commit() {
        switch (this.logLevel) {
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace((Object)this.builder.toString());
                break;
            }
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)this.builder.toString());
                break;
            }
            case INFO: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info((Object)this.builder.toString());
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)this.builder.toString());
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)this.builder.toString());
                break;
            }
            case FATAL: {
                if (!this.log.isFatalEnabled()) break;
                this.log.fatal((Object)this.builder.toString());
            }
        }
        if (this.builder.length() > 2048) {
            this.builder.setLength(2048);
            this.builder.trimToSize();
        }
        this.builder.setLength(0);
        this.pattern = null;
    }
}

