/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.log4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.LogManager;
import org.gflogger.FormattedGFLogEntry;
import org.gflogger.GFLogEntry;
import org.gflogger.GFLogger;
import org.gflogger.LocalLogEntry;
import org.gflogger.LogLevel;
import org.gflogger.LoggerService;
import org.gflogger.log4j.Log4jEntry;

public class Log4jLoggerServiceImpl
implements LoggerService {
    private final ThreadLocal<Map<String, Log4jEntry>> entries;
    private final LogLevel level;

    public Log4jLoggerServiceImpl() {
        this(LogLevel.DEBUG);
    }

    public Log4jLoggerServiceImpl(LogLevel level) {
        this.level = level;
        this.entries = new ThreadLocal<Map<String, Log4jEntry>>(){

            @Override
            protected Map<String, Log4jEntry> initialValue() {
                return new HashMap<String, Log4jEntry>();
            }
        };
        BasicConfigurator.configure();
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public GFLogEntry log(LogLevel level, String categoryName, long appenderMask) {
        Map<String, Log4jEntry> map = this.entries.get();
        Log4jEntry entry = map.get(categoryName);
        if (entry == null) {
            entry = new Log4jEntry(LogFactory.getLog((String)categoryName));
            map.put(categoryName, entry);
        }
        entry.setLogLevel(level);
        entry.reset();
        return entry;
    }

    @Override
    public FormattedGFLogEntry formattedLog(LogLevel level, String categoryName, String pattern, long appenderMask) {
        Map<String, Log4jEntry> map = this.entries.get();
        Log4jEntry entry = map.get(categoryName);
        if (entry == null) {
            entry = new Log4jEntry(LogFactory.getLog((String)categoryName));
            map.put(categoryName, entry);
        }
        entry.reset();
        entry.setPattern(pattern);
        entry.setLogLevel(level);
        return entry;
    }

    @Override
    public GFLogger[] lookupLoggers(String name) {
        return GFLogger.EMPTY;
    }

    @Override
    public void entryFlushed(LocalLogEntry localEntry) {
    }

    @Override
    public void stop() {
        LogManager.shutdown();
    }
}

