/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.ring;

import java.util.concurrent.TimeUnit;
import org.gflogger.ring.Sequence;
import org.gflogger.ring.WaitStrategy;

public class BlockingWaitStrategy
implements WaitStrategy {
    private final Object lock = new Object();
    private boolean signalled;
    private volatile int waiters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signallAll() {
        if (this.waiters != 0) {
            Object object = this.lock;
            synchronized (object) {
                this.signalled = true;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(Sequence cursor, long seqNum) throws InterruptedException {
        long availableSequence = cursor.get();
        if (availableSequence < seqNum) {
            Object object = this.lock;
            synchronized (object) {
                this.signalled = false;
                try {
                    ++this.waiters;
                    while ((availableSequence = cursor.get()) < seqNum) {
                        this.lock.wait();
                    }
                }
                finally {
                    --this.waiters;
                }
            }
        }
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(Sequence cursor, long seqNum, long timeout, TimeUnit unit) throws InterruptedException {
        long availableSequence = cursor.get();
        if (availableSequence < seqNum) {
            long timeoutMs = unit.toMillis(timeout);
            long startTime = System.currentTimeMillis();
            Object object = this.lock;
            synchronized (object) {
                this.signalled = false;
                try {
                    ++this.waiters;
                    while ((availableSequence = cursor.get()) < seqNum) {
                        this.lock.wait(timeoutMs);
                        if (this.signalled && System.currentTimeMillis() - startTime <= timeoutMs) continue;
                        break;
                    }
                }
                finally {
                    --this.waiters;
                }
            }
        }
        return availableSequence;
    }
}

