/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.ring;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gflogger.ring.AlertException;
import org.gflogger.ring.EntryProcessor;
import org.gflogger.ring.MutableLong;
import org.gflogger.ring.PaddedAtomicLong;
import org.gflogger.ring.Publishable;
import org.gflogger.ring.RingBufferAware;

public final class RingBuffer<T extends Publishable> {
    public static final long INITIAL_CURSOR_VALUE = -1L;
    public static final int SPIN_TRIES = 1000;
    private final T[] entries;
    private final int mask;
    private final PaddedAtomicLong sequence = new PaddedAtomicLong(-1L);
    private final ThreadLocal<MutableLong> minSequence = new MutableLongThreadLocal();
    private final EntryProcessor[] entryProcessors;
    private final AtomicBoolean running = new AtomicBoolean();
    private final Object lock = new Object();
    private boolean signalled;
    private volatile int waiters;

    public RingBuffer(T[] entries, EntryProcessor ... entryProcessors) {
        if ((entries.length & entries.length - 1) != 0) {
            throw new IllegalArgumentException("number of entries should be power of 2");
        }
        this.entries = entries;
        this.mask = entries.length - 1;
        this.entryProcessors = entryProcessors;
        for (int i = 0; i < entryProcessors.length; ++i) {
            if (!(entryProcessors[i] instanceof RingBufferAware)) continue;
            RingBufferAware bufferAware = (RingBufferAware)((Object)entryProcessors[i]);
            bufferAware.setRingBuffer(this);
        }
        this.running.set(true);
    }

    private long getMinSeqNum() {
        long minimum = this.entryProcessors[0].getSequence();
        if (this.entryProcessors.length > 1) {
            for (int i = 1; i < this.entryProcessors.length; ++i) {
                minimum = Math.min(minimum, this.entryProcessors[i].getSequence());
            }
        }
        return minimum;
    }

    public long next() {
        long nextSeqNum = this.sequence.incrementAndGet();
        this.claimSequence(nextSeqNum);
        return nextSeqNum;
    }

    private void claimSequence(long seqNum) {
        long wrapPoint = seqNum - (long)this.entries.length;
        MutableLong minSeq = this.minSequence.get();
        if (wrapPoint > minSeq.get()) {
            long minSeqNum;
            while (wrapPoint > (minSeqNum = this.getMinSeqNum())) {
                Thread.yield();
            }
            minSeq.set(minSeqNum);
        }
    }

    public void publish(long sequence) {
        this.entries[(int)(sequence & (long)this.mask)].setPublished(true);
        this.signallAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitFor(long seqNum) throws InterruptedException {
        long availableSequence;
        int idx = (int)(seqNum & (long)this.mask);
        boolean published = this.entries[idx].isPublished();
        long l = availableSequence = published ? seqNum : seqNum - 1L;
        if (!published) {
            Object object = this.lock;
            synchronized (object) {
                this.signalled = false;
                try {
                    ++this.waiters;
                    while (!(published = this.entries[idx].isPublished())) {
                        if (!this.running.get()) {
                            throw AlertException.ALERT_EXCEPTION;
                        }
                        this.lock.wait();
                        if (this.signalled) continue;
                        break;
                    }
                }
                finally {
                    --this.waiters;
                }
            }
        }
        if (published) {
            availableSequence = seqNum;
            long e = seqNum + (long)this.entries.length;
            for (long i = seqNum; i < e; ++i) {
                if (this.entries[(int)(i & (long)this.mask)].isPublished()) continue;
                availableSequence = i - 1L;
                break;
            }
        }
        return availableSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitFor(long seqNum, long timeout, TimeUnit unit) throws InterruptedException {
        long availableSequence;
        int idx = (int)(seqNum & (long)this.mask);
        boolean published = this.entries[idx].isPublished();
        long l = availableSequence = published ? seqNum : seqNum - 1L;
        if (!published) {
            long timeoutMs = unit.toMillis(timeout);
            long startTime = System.currentTimeMillis();
            Object object = this.lock;
            synchronized (object) {
                this.signalled = false;
                try {
                    ++this.waiters;
                    while (!(published = this.entries[idx].isPublished())) {
                        if (!this.running.get()) {
                            throw AlertException.ALERT_EXCEPTION;
                        }
                        this.lock.wait(timeoutMs);
                        if (this.signalled && System.currentTimeMillis() - startTime <= timeoutMs) continue;
                        break;
                    }
                }
                finally {
                    --this.waiters;
                }
            }
        }
        if (published) {
            availableSequence = seqNum;
            long e = seqNum + (long)this.entries.length;
            for (long i = seqNum; i < e; ++i) {
                if (this.entries[(int)(i & (long)this.mask)].isPublished()) continue;
                availableSequence = i - 1L;
                break;
            }
        }
        return availableSequence;
    }

    public T get(long index) {
        return this.entries[(int)(index & (long)this.mask)];
    }

    public int size() {
        return this.entries.length;
    }

    public void stop() {
        if (this.running.getAndSet(false)) {
            this.signallAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signallAll() {
        if (this.waiters != 0) {
            Object object = this.lock;
            synchronized (object) {
                this.signalled = true;
                this.lock.notifyAll();
            }
        }
    }

    private static class MutableLongThreadLocal
    extends ThreadLocal<MutableLong> {
        private MutableLongThreadLocal() {
        }

        @Override
        protected MutableLong initialValue() {
            return new MutableLong(-1L);
        }
    }
}

