/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    private final String namePrefix;
    private final String[] names;

    public NamedThreadFactory(String prefix, String ... names) {
        this.names = names;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = prefix + "-" + poolNumber.getAndIncrement() + "-";
    }

    @Override
    public Thread newThread(Runnable r) {
        int idx = this.threadNumber.getAndIncrement();
        String threadName = this.namePrefix + (idx < this.names.length ? this.names[idx] + "-" : "") + idx;
        Thread t = new Thread(this.group, r, threadName, 0L);
        t.setDaemon(true);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

