/*
 * Decompiled with CFR 0.152.
 */
package org.gflogger.util;

import java.net.URL;

public class StackTraceUtils {
    public static String getCodeLocation(Class type) {
        try {
            URL resource;
            if (type != null && (resource = type.getProtectionDomain().getCodeSource().getLocation()) != null) {
                String locationStr = resource.toString();
                String result = StackTraceUtils.getCodeLocation(locationStr, '/');
                if (result != null) {
                    return result;
                }
                return StackTraceUtils.getCodeLocation(locationStr, '\\');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "na";
    }

    public static String getCodeLocation(String locationStr, char separator) {
        int idx = locationStr.lastIndexOf(separator);
        if (StackTraceUtils.isFolder(idx, locationStr)) {
            idx = locationStr.lastIndexOf(separator, idx - 1);
            return locationStr.substring(idx + 1);
        }
        if (idx > 0) {
            return locationStr.substring(idx + 1);
        }
        return null;
    }

    public static String getImplementationVersion(Class clazz) {
        String v;
        if (clazz == null) {
            return null;
        }
        Package pkg = clazz.getPackage();
        if (pkg != null && (v = pkg.getImplementationVersion()) != null) {
            return v;
        }
        return null;
    }

    private static boolean isFolder(int idx, String text) {
        return idx != -1 && idx + 1 == text.length();
    }

    public static Class loadClass(String className) {
        return StackTraceUtils.loadClass(Thread.currentThread().getContextClassLoader(), className);
    }

    public static Class loadClass(ClassLoader cl, String className) {
        if (cl == null) {
            return null;
        }
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e1) {
            return null;
        }
        catch (NoClassDefFoundError e1) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

