/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.util.EventListener;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.core.dataStructures.hash.LongLinkedHashMap;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import org.jetbrains.annotations.NotNull;

public class LongObjectCache<V>
extends LongObjectCacheBase<V> {
    public static final float DEFAULT_SECOND_GENERATION_QUEUE_SIZE_RATIO = 0.4f;
    private final Lock lock = new ReentrantLock();
    private final float secondGenSizeRatio;
    private LongLinkedHashMap<V> firstGenerationQueue;
    private LongLinkedHashMap<V> secondGenerationQueue;
    private DeletedPairsListener<V>[] listeners;
    private V pushedOutValue;

    public LongObjectCache() {
        this(8192);
    }

    public LongObjectCache(int cacheSize) {
        this(cacheSize, 0.4f);
    }

    public LongObjectCache(int cacheSize, float secondGenSizeRatio) {
        super(cacheSize);
        if (secondGenSizeRatio < 0.05f) {
            secondGenSizeRatio = 0.05f;
        } else if (secondGenSizeRatio > 0.95f) {
            secondGenSizeRatio = 0.95f;
        }
        this.secondGenSizeRatio = secondGenSizeRatio;
        this.clear();
        this.addDeletedPairsListener(new DeletedPairsListener<V>(){

            @Override
            public void objectRemoved(long key, V value) {
                LongObjectCache.this.pushedOutValue = value;
            }
        });
    }

    @Override
    public void clear() {
        this.firstGenerationQueue = new LongLinkedHashMap<V>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, V> eldest) {
                boolean result;
                boolean bl = result = this.size() + LongObjectCache.this.secondGenerationQueue.size() > LongObjectCache.this.size;
                if (result) {
                    LongObjectCache.this.fireListenersAboutDeletion(eldest.getKey(), eldest.getValue());
                }
                return result;
            }
        };
        final int secondGenSizeBound = (int)((float)this.size * this.secondGenSizeRatio);
        this.secondGenerationQueue = new LongLinkedHashMap<V>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, V> eldest) {
                boolean result;
                boolean bl = result = this.size() > secondGenSizeBound;
                if (result) {
                    --this.size;
                    LongObjectCache.this.firstGenerationQueue.put(eldest.getKey(), eldest.getValue());
                    ++this.size;
                }
                return result;
            }
        };
    }

    @Override
    public void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    @Override
    public void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    @Override
    public V remove(long key) {
        V x = this.firstGenerationQueue.remove(key);
        if (x != null) {
            this.fireListenersAboutDeletion(key, x);
        } else {
            x = this.secondGenerationQueue.remove(key);
            if (x != null) {
                this.fireListenersAboutDeletion(key, x);
            }
        }
        return x;
    }

    public void removeAll() {
        long key;
        Iterator iterator2 = this.firstGenerationQueue.keySet().iterator();
        while (iterator2.hasNext()) {
            key = (Long)iterator2.next();
            this.fireListenersAboutDeletion(key, this.firstGenerationQueue.get(key));
        }
        iterator2 = this.secondGenerationQueue.keySet().iterator();
        while (iterator2.hasNext()) {
            key = (Long)iterator2.next();
            this.fireListenersAboutDeletion(key, this.secondGenerationQueue.get(key));
        }
        this.clear();
    }

    @Override
    public V cacheObject(long key, @NotNull V x) {
        this.pushedOutValue = null;
        if (this.firstGenerationQueue.put(key, x) == null) {
            this.secondGenerationQueue.remove(key);
        }
        return this.pushedOutValue;
    }

    @Override
    public V tryKey(long key) {
        this.incAttempts();
        V result = this.secondGenerationQueue.get(key);
        if (result == null && (result = this.firstGenerationQueue.remove(key)) != null) {
            this.secondGenerationQueue.put(key, result);
        }
        if (result != null) {
            this.incHits();
        }
        return result;
    }

    @Override
    public V getObject(long key) {
        V result = this.firstGenerationQueue.get(key);
        if (result == null) {
            result = this.secondGenerationQueue.get(key);
        }
        return result;
    }

    @Override
    public int count() {
        return this.firstGenerationQueue.size() + this.secondGenerationQueue.size();
    }

    public Iterator<Long> keys() {
        return new LongObjectCacheKeysIterator(this);
    }

    public Iterator<V> values() {
        return new LongObjectCacheValuesIterator(this);
    }

    public boolean forEachEntry(ObjectProcedure<Map.Entry<Long, V>> procedure) {
        for (Map.Entry entry : this.firstGenerationQueue.entrySet()) {
            if (procedure.execute(entry)) continue;
            return false;
        }
        for (Map.Entry entry : this.secondGenerationQueue.entrySet()) {
            if (procedure.execute(entry)) continue;
            return false;
        }
        return true;
    }

    public void addDeletedPairsListener(DeletedPairsListener<V> listener) {
        if (this.listeners == null) {
            this.listeners = new DeletedPairsListener[1];
        } else {
            DeletedPairsListener[] newListeners = new DeletedPairsListener[this.listeners.length + 1];
            System.arraycopy(this.listeners, 0, newListeners, 0, this.listeners.length);
            this.listeners = newListeners;
        }
        this.listeners[this.listeners.length - 1] = listener;
    }

    public void removeDeletedPairsListener(DeletedPairsListener<V> listener) {
        if (this.listeners != null) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                DeletedPairsListener[] newListeners = new DeletedPairsListener[this.listeners.length - 1];
                int i = 0;
                for (DeletedPairsListener<V> myListener : this.listeners) {
                    if (myListener == listener) continue;
                    newListeners[i++] = myListener;
                }
                this.listeners = newListeners;
            }
        }
    }

    private void fireListenersAboutDeletion(long key, V x) {
        if (this.listeners != null) {
            for (DeletedPairsListener<V> myListener : this.listeners) {
                myListener.objectRemoved(key, x);
            }
        }
    }

    public static interface DeletedPairsListener<V>
    extends EventListener {
        public void objectRemoved(long var1, V var3);
    }

    protected static class LongObjectCacheValuesIterator<V>
    implements Iterator<V> {
        private final Iterator<V> firstGenIterator;
        private final Iterator<V> secondGenIterator;

        protected LongObjectCacheValuesIterator(LongObjectCache<V> cache) {
            this.firstGenIterator = ((LongObjectCache)cache).firstGenerationQueue.values().iterator();
            this.secondGenIterator = ((LongObjectCache)cache).secondGenerationQueue.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.firstGenIterator.hasNext() || this.secondGenIterator.hasNext();
        }

        @Override
        public V next() {
            return this.firstGenIterator.hasNext() ? this.firstGenIterator.next() : this.secondGenIterator.next();
        }

        @Override
        public void remove() {
            if (this.firstGenIterator.hasNext()) {
                this.firstGenIterator.remove();
            } else {
                this.secondGenIterator.remove();
            }
        }
    }

    protected static class LongObjectCacheKeysIterator<V>
    implements Iterator<Long> {
        private final Iterator<Long> firstGenIterator;
        private final Iterator<Long> secondGenIterator;

        protected LongObjectCacheKeysIterator(LongObjectCache<V> cache) {
            this.firstGenIterator = ((LongObjectCache)cache).firstGenerationQueue.keySet().iterator();
            this.secondGenIterator = ((LongObjectCache)cache).secondGenerationQueue.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.firstGenIterator.hasNext() || this.secondGenIterator.hasNext();
        }

        @Override
        public Long next() {
            return this.firstGenIterator.hasNext() ? this.firstGenIterator.next() : this.secondGenIterator.next();
        }

        @Override
        public void remove() {
            if (this.firstGenIterator.hasNext()) {
                this.firstGenIterator.remove();
            } else {
                this.secondGenIterator.remove();
            }
        }
    }
}

