/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import org.jetbrains.annotations.NotNull;

public class RunnableJob
extends Job {
    private Runnable runnable;

    public RunnableJob(Runnable runnable) {
        this.runnable = runnable;
    }

    public RunnableJob(@NotNull JobProcessor processor, Runnable runnable) {
        this(processor, Priority.normal, runnable);
    }

    public RunnableJob(@NotNull JobProcessor processor, @NotNull Priority priority, Runnable runnable) {
        this.setProcessor(processor);
        this.runnable = runnable;
        this.queue(priority);
    }

    @Override
    protected void execute() {
        this.runnable.run();
    }

    @Override
    public String getName() {
        String name = this.runnable.getClass().getSimpleName();
        return name.isEmpty() ? "Anonymous runnable job" : "Runnable job " + name;
    }

    @Override
    public String getGroup() {
        return this.runnable.getClass().getName();
    }
}

