/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.OutOfDiskSpaceException;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.FakeObjectCache;
import jetbrains.exodus.core.dataStructures.NonAdjustableConcurrentObjectCache;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.ObjectCacheDecorator;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.ComparableGetter;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableCache;
import jetbrains.exodus.entitystore.EntityIterableCacheAdapter;
import jetbrains.exodus.entitystore.EntityIterableCacheAdapterMutable;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.FlushLog;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransactionSnapshot;
import jetbrains.exodus.entitystore.QueryCancellingPolicy;
import jetbrains.exodus.entitystore.Sequence;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.TxnProvider;
import jetbrains.exodus.entitystore.Updatable;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesOfTypeIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesOfTypeRangeIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesWithBlobIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesWithLinkIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesWithLinkSortedIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesWithPropertyIterable;
import jetbrains.exodus.entitystore.iterate.EntityAddedOrDeletedHandleChecker;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityToLinksIterable;
import jetbrains.exodus.entitystore.iterate.HandleChecker;
import jetbrains.exodus.entitystore.iterate.LinkChangedHandleChecker;
import jetbrains.exodus.entitystore.iterate.MergeSortedIterable;
import jetbrains.exodus.entitystore.iterate.MergeSortedIterableWithValueGetter;
import jetbrains.exodus.entitystore.iterate.PropertiesIterable;
import jetbrains.exodus.entitystore.iterate.PropertyChangedHandleChecker;
import jetbrains.exodus.entitystore.iterate.PropertyRangeIterable;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterable;
import jetbrains.exodus.entitystore.iterate.SingleEntityIterable;
import jetbrains.exodus.entitystore.iterate.SortIndirectIterable;
import jetbrains.exodus.entitystore.iterate.SortIterable;
import jetbrains.exodus.entitystore.iterate.TxnGetterStrategy;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.UnsafeKt;
import jetbrains.exodus.util.StringBuilderSpinAllocator;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentStoreTransaction
implements StoreTransaction,
TxnGetterStrategy,
TxnProvider {
    private static final Logger logger = LoggerFactory.getLogger(PersistentStoreTransaction.class);
    private static final int LOCAL_CACHE_GENERATIONS = 2;
    @NotNull
    private static final ByteIterable ZERO_VERSION_ENTRY = IntegerBinding.intToCompressedEntry((int)0);
    @NotNull
    protected final PersistentEntityStoreImpl store;
    @NotNull
    protected final Transaction txn;
    private final ObjectCacheBase<PropertyId, Comparable> propsCache;
    @NotNull
    private final ObjectCacheBase<PropertyId, PersistentEntityId> linksCache;
    @NotNull
    private final ObjectCacheBase<PropertyId, String> blobStringsCache;
    private EntityIterableCacheAdapter localCache;
    private int localCacheAttempts;
    private int localCacheHits;
    @Nullable
    private EntityIterableCacheAdapterMutable mutableCache;
    private List<Updatable> mutatedInTxn;
    @Nullable
    private LongHashMap<InputStream> blobStreams;
    @Nullable
    private LongHashMap<File> blobFiles;
    private LongSet deferredBlobsToDelete;
    private QueryCancellingPolicy queryCancellingPolicy;

    PersistentStoreTransaction(@NotNull PersistentEntityStoreImpl store) {
        this(store, TransactionType.Regular);
    }

    PersistentStoreTransaction(@NotNull PersistentStoreTransaction source, @NotNull TransactionType txnType) {
        this.store = source.store;
        PersistentEntityStoreConfig config = this.store.getConfig();
        this.propsCache = PersistentStoreTransaction.createObjectCache(config.getTransactionPropsCacheSize());
        this.linksCache = PersistentStoreTransaction.createObjectCache(config.getTransactionLinksCacheSize());
        this.blobStringsCache = PersistentStoreTransaction.createObjectCache(config.getTransactionBlobStringsCacheSize());
        this.localCache = source.localCache;
        this.localCacheHits = 0;
        this.localCacheAttempts = 0;
        switch (txnType) {
            case Regular: {
                this.txn = source.txn.getSnapshot(this.getRevertCachesBeginHook());
                break;
            }
            case Readonly: {
                this.txn = source.txn.getReadonlySnapshot();
                break;
            }
            default: {
                throw new EntityStoreException("Can't create exclusive snapshot transaction");
            }
        }
    }

    protected PersistentStoreTransaction(@NotNull PersistentEntityStoreImpl store, @NotNull TransactionType txnType) {
        this.store = store;
        PersistentEntityStoreConfig config = store.getConfig();
        this.propsCache = PersistentStoreTransaction.createObjectCache(config.getTransactionPropsCacheSize());
        this.linksCache = PersistentStoreTransaction.createObjectCache(config.getTransactionLinksCacheSize());
        this.blobStringsCache = PersistentStoreTransaction.createObjectCache(config.getTransactionBlobStringsCacheSize());
        this.localCacheHits = 0;
        this.localCacheAttempts = 0;
        Runnable beginHook = this.getRevertCachesBeginHook();
        Environment env = store.getEnvironment();
        switch (txnType) {
            case Regular: {
                this.txn = env.beginTransaction(beginHook);
                break;
            }
            case Exclusive: {
                this.txn = env.beginExclusiveTransaction(beginHook);
                this.mutableCache = this.createMutableCache();
                break;
            }
            case Readonly: {
                this.txn = env.beginReadonlyTransaction(beginHook);
                break;
            }
            default: {
                throw new EntityStoreException("Can't create " + (Object)((Object)txnType) + " transaction");
            }
        }
    }

    @NotNull
    public PersistentEntityStoreImpl getStore() {
        return this.store;
    }

    public boolean isIdempotent() {
        return !(!this.getEnvironmentTransaction().isIdempotent() || this.blobStreams != null && !this.blobStreams.isEmpty() || this.blobFiles != null && !this.blobFiles.isEmpty());
    }

    public boolean isReadonly() {
        return this.txn.isReadonly();
    }

    public boolean isFinished() {
        return this.txn.isFinished();
    }

    public boolean commit() {
        if (!this.isReadonly()) {
            this.apply();
            return this.doCommit();
        }
        if (this.txn.isExclusive()) {
            this.applyExclusiveTransactionCaches();
        }
        return true;
    }

    public boolean isCurrent() {
        return true;
    }

    private boolean doCommit() {
        if (this.txn.commit()) {
            this.store.unregisterTransaction(this);
            this.flushNonTransactionalBlobs();
            this.revertCaches();
            return true;
        }
        this.revert();
        return false;
    }

    public void abort() {
        try {
            this.store.unregisterTransaction(this);
            this.revertCaches();
        }
        finally {
            this.txn.abort();
        }
    }

    public boolean flush() {
        if (!this.isReadonly()) {
            this.apply();
            return this.doFlush();
        }
        if (this.txn.isExclusive()) {
            this.applyExclusiveTransactionCaches();
        }
        return true;
    }

    boolean doFlush() {
        if (this.txn.flush()) {
            this.flushNonTransactionalBlobs();
            this.revertCaches(false);
            return true;
        }
        this.revert();
        return false;
    }

    public void revert() {
        this.txn.revert();
        this.mutableCache = null;
        this.mutatedInTxn = new ArrayList<Updatable>();
    }

    public PersistentStoreTransaction getSnapshot() {
        return new PersistentStoreTransactionSnapshot(this);
    }

    @NotNull
    public PersistentEntity newEntity(@NotNull String entityType) {
        try {
            int entityTypeId = this.store.getEntityTypeId(this, entityType, true);
            long entityLocalId = this.store.getEntitiesSequence(this, entityTypeId).increment();
            this.store.getEntitiesTable(this, entityTypeId).putRight(this.txn, (ByteIterable)LongBinding.longToCompressedEntry((long)entityLocalId), ZERO_VERSION_ENTRY);
            PersistentEntityId id = new PersistentEntityId(entityTypeId, entityLocalId);
            new EntityAddedHandleCheckerImpl(this, id, this.mutableCache(), this.mutatedInTxn).updateCache();
            return new PersistentEntity(this.store, id);
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
    }

    public void saveEntity(@NotNull Entity entity) {
        try {
            EntityId entityId = entity.getId();
            Store entitiesTable = this.store.getEntitiesTable(this, entityId.getTypeId());
            entitiesTable.put(this.txn, (ByteIterable)LongBinding.longToCompressedEntry((long)entityId.getLocalId()), ZERO_VERSION_ENTRY);
            new EntityAddedHandleCheckerImpl(this, entityId, this.mutableCache(), this.mutatedInTxn).updateCache();
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
    }

    @NotNull
    public PersistentEntity getEntity(@NotNull EntityId id) {
        int version = this.store.getLastVersion(this, id);
        if (version < 0) {
            throw new EntityRemovedInDatabaseException(this.store.getEntityType(this, id.getTypeId()));
        }
        return new PersistentEntity(this.store, (PersistentEntityId)id);
    }

    @NotNull
    public List<String> getEntityTypes() {
        return this.store.getEntityTypes(this);
    }

    @NotNull
    public EntityIterable getAll(@NotNull String entityType) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesOfTypeIterable(this, entityTypeId);
    }

    @NotNull
    public EntityIterable getSingletonIterable(@NotNull Entity entity) {
        return new SingleEntityIterable(this, entity.getId());
    }

    @NotNull
    public EntityIterable find(@NotNull String entityType, @NotNull String propertyName, @NotNull Comparable value) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int propertyId = this.store.getPropertyId(this, propertyName, false);
        if (propertyId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new PropertyValueIterable(this, entityTypeId, propertyId, value);
    }

    @NotNull
    public EntityIterable find(@NotNull String entityType, @NotNull String propertyName, @NotNull Comparable minValue, @NotNull Comparable maxValue) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int propertyId = this.store.getPropertyId(this, propertyName, false);
        if (propertyId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new PropertyRangeIterable(this, entityTypeId, propertyId, minValue, maxValue);
    }

    @NotNull
    public EntityIterable findIds(@NotNull String entityType, long minValue, long maxValue) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesOfTypeRangeIterable(this, entityTypeId, minValue, maxValue);
    }

    @NotNull
    public EntityIterableBase findWithProp(@NotNull String entityType, @NotNull String propertyName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int propertyId = this.store.getPropertyId(this, propertyName, false);
        if (propertyId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesWithPropertyIterable(this, entityTypeId, propertyId);
    }

    public EntityIterableBase findWithPropSortedByValue(@NotNull String entityType, @NotNull String propertyName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int propertyId = this.store.getPropertyId(this, propertyName, false);
        if (propertyId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new PropertiesIterable(this, entityTypeId, propertyId);
    }

    @NotNull
    public EntityIterable findStartingWith(@NotNull String entityType, @NotNull String propertyName, @NotNull String value) {
        int len = value.length();
        if (len == 0) {
            return this.getAll(entityType);
        }
        return this.find(entityType, propertyName, (Comparable)((Object)value), (Comparable)((Object)(value + '\uffff')));
    }

    @NotNull
    public EntityIterable findWithBlob(@NotNull String entityType, @NotNull String blobName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int blobId = this.store.getPropertyId(this, blobName, false);
        if (blobId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesWithBlobIterable(this, entityTypeId, blobId);
    }

    @NotNull
    public EntityIterable findLinks(@NotNull String entityType, @NotNull Entity entity, @NotNull String linkName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int linkId = this.store.getLinkId(this, linkName, false);
        if (linkId < 0) {
            return EntityIterableBase.EMPTY;
        }
        if (entity instanceof PersistentEntity) {
            return new EntityToLinksIterable(this, ((PersistentEntity)entity).getId(), entityTypeId, linkId);
        }
        EntityId id = entity.getId();
        if (id instanceof PersistentEntityId) {
            return new EntityToLinksIterable(this, id, entityTypeId, linkId);
        }
        return EntityIterableBase.EMPTY;
    }

    @NotNull
    public EntityIterable findLinks(@NotNull String entityType, @NotNull EntityIterable entities, @NotNull String linkName) {
        ArrayList<EntityIterable> links = null;
        for (Entity entity : entities) {
            if (links == null) {
                links = new ArrayList<EntityIterable>();
            }
            links.add(this.findLinks(entityType, entity, linkName));
        }
        if (links == null) {
            return EntityIterableBase.EMPTY;
        }
        if (links.size() > 1) {
            for (int i = 0; i < links.size() - 1; i += 2) {
                links.add(((EntityIterable)links.get(i)).union((EntityIterable)links.get(i + 1)));
            }
        }
        return (EntityIterable)links.get(links.size() - 1);
    }

    @NotNull
    public EntityIterable findWithLinks(@NotNull String entityType, @NotNull String linkName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int linkId = this.store.getLinkId(this, linkName, false);
        if (linkId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesWithLinkIterable(this, entityTypeId, linkId);
    }

    @NotNull
    public EntityIterable findWithLinks(@NotNull String entityType, @NotNull String linkName, @NotNull String oppositeEntityType, @NotNull String oppositeLinkName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int linkId = this.store.getLinkId(this, linkName, false);
        if (linkId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int oppositeEntityId = this.store.getEntityTypeId(this, oppositeEntityType, false);
        if (oppositeEntityId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int oppositeLinkId = this.store.getLinkId(this, oppositeLinkName, false);
        if (oppositeLinkId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesWithLinkSortedIterable(this, entityTypeId, linkId, oppositeEntityId, oppositeLinkId);
    }

    @NotNull
    public EntityIterable sort(@NotNull String entityType, @NotNull String propertyName, boolean ascending) {
        return this.sort(entityType, propertyName, this.getAll(entityType), ascending);
    }

    @NotNull
    public EntityIterable sort(@NotNull String entityType, @NotNull String propertyName, @NotNull EntityIterable rightOrder, boolean ascending) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int propertyId = this.store.getPropertyId(this, propertyName, false);
        if (propertyId < 0 || rightOrder == EntityIterableBase.EMPTY) {
            return rightOrder;
        }
        return new SortIterable(this, this.findWithPropSortedByValue(entityType, propertyName), (EntityIterableBase)rightOrder, entityTypeId, propertyId, ascending);
    }

    @NotNull
    public EntityIterable sortLinks(@NotNull String entityType, @NotNull EntityIterable sortedLinks, boolean isMultiple, @NotNull String linkName, @NotNull EntityIterable rightOrder) {
        SortIndirectIterable result = new SortIndirectIterable(this, this.store, entityType, ((EntityIterableBase)sortedLinks).getSource(), linkName, (EntityIterableBase)rightOrder, null, null);
        return isMultiple ? result.distinct() : result;
    }

    @NotNull
    public EntityIterable sortLinks(@NotNull String entityType, @NotNull EntityIterable sortedLinks, boolean isMultiple, @NotNull String linkName, @NotNull EntityIterable rightOrder, @NotNull String oppositeEntityType, @NotNull String oppositeLinkName) {
        SortIndirectIterable result = new SortIndirectIterable(this, this.store, entityType, ((EntityIterableBase)sortedLinks).getSource(), linkName, (EntityIterableBase)rightOrder, oppositeEntityType, oppositeLinkName);
        return isMultiple ? result.distinct() : result;
    }

    @Deprecated
    @NotNull
    public EntityIterable mergeSorted(@NotNull List<EntityIterable> sorted, @NotNull Comparator<Entity> comparator) {
        ArrayList<EntityIterable> filtered = null;
        for (EntityIterable it : sorted) {
            if (it == EntityIterableBase.EMPTY) continue;
            if (filtered == null) {
                filtered = new ArrayList<EntityIterable>();
            }
            filtered.add(it);
        }
        return filtered == null ? EntityIterableBase.EMPTY : new MergeSortedIterable(this, filtered, comparator);
    }

    @NotNull
    public EntityIterable mergeSorted(@NotNull List<EntityIterable> sorted, @NotNull ComparableGetter valueGetter, @NotNull Comparator<Comparable<Object>> comparator) {
        ArrayList<EntityIterable> filtered = null;
        for (EntityIterable it : sorted) {
            if (it == EntityIterableBase.EMPTY) continue;
            if (filtered == null) {
                filtered = new ArrayList<EntityIterable>();
            }
            filtered.add(it);
        }
        return filtered == null ? EntityIterableBase.EMPTY : new MergeSortedIterableWithValueGetter(this, filtered, valueGetter, comparator);
    }

    @NotNull
    public EntityId toEntityId(@NotNull String representation) {
        return PersistentEntityId.toEntityId(representation);
    }

    @NotNull
    public Sequence getSequence(@NotNull String sequenceName) {
        try {
            return this.store.getSequence(this, sequenceName);
        }
        catch (Exception e) {
            throw ExodusException.wrap((Exception)e);
        }
    }

    public void setQueryCancellingPolicy(QueryCancellingPolicy policy) {
        this.queryCancellingPolicy = policy;
    }

    @Nullable
    public QueryCancellingPolicy getQueryCancellingPolicy() {
        return this.queryCancellingPolicy;
    }

    public void registerMutatedHandle(@NotNull EntityIterableHandle handle, @NotNull CachedInstanceIterable iterable) {
        EntityIterableCacheAdapterMutable cache = this.mutableCache;
        if (cache == null) {
            throw new IllegalStateException("Transaction wasn't mutated");
        }
        cache.cacheObjectNotAffectingHandleDistribution(handle, iterable);
    }

    public void registerStickyObject(@NotNull EntityIterableHandle handle, Updatable object) {
        this.mutableCache().registerStickyObject(handle, object);
    }

    @NotNull
    public Updatable getStickyObject(@NotNull EntityIterableHandle handle) {
        return this.getLocalCache().getStickyObject(handle);
    }

    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(this.store.getLocation());
            builder.append(", thread = ");
            builder.append(Thread.currentThread().toString());
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    @NotNull
    public Transaction getEnvironmentTransaction() {
        return this.txn;
    }

    @Override
    public PersistentStoreTransaction getTxn(@NotNull EntityIterableBase iterable) {
        return this;
    }

    @Override
    @NotNull
    public PersistentStoreTransaction getTransaction() {
        return this;
    }

    @Nullable
    public CachedInstanceIterable getCachedInstance(@NotNull EntityIterableBase sample) {
        EntityIterableHandle handle = sample.getHandle();
        EntityIterableCacheAdapter localCache = this.getLocalCache();
        return localCache.tryKey(handle);
    }

    @Nullable
    public CachedInstanceIterable getCachedInstanceFast(@NotNull EntityIterableBase sample) {
        EntityIterableHandle handle = sample.getHandle();
        EntityIterableCacheAdapter localCache = this.getLocalCache();
        return localCache.getObject(handle);
    }

    public void addCachedInstance(@NotNull CachedInstanceIterable cached) {
        EntityIterableHandle handle;
        EntityIterableCacheAdapter localCache = this.getLocalCache();
        if (localCache.getObject(handle = cached.getHandle()) == null) {
            localCache.cacheObject(handle, cached);
            this.store.getEntityIterableCache().setCachedCount(handle, cached.size());
        }
    }

    @NotNull
    EntityIterableCacheAdapter getLocalCache() {
        return this.mutableCache != null ? this.mutableCache : this.localCache;
    }

    void localCacheAttempt() {
        ++this.localCacheAttempts;
    }

    void localCacheHit() {
        ++this.localCacheHits;
    }

    boolean isCachingRelevant() {
        return this.localCacheAttempts <= this.localCache.size() >> 2 || this.localCacheHits >= this.localCacheAttempts >> 2;
    }

    void cacheProperty(@NotNull PersistentEntityId fromId, int propId, @NotNull Comparable value) {
        PropertyId fromEnd = new PropertyId(fromId, propId);
        if (this.propsCache.getObject((Object)fromEnd) == null) {
            this.propsCache.cacheObject((Object)fromEnd, (Object)value);
        }
    }

    Comparable getCachedProperty(@NotNull PersistentEntity from, int propId) {
        return (Comparable)this.propsCache.tryKey((Object)new PropertyId(from.getId(), propId));
    }

    void cacheLink(@NotNull PersistentEntity from, int linkId, @NotNull PersistentEntityId to) {
        PropertyId fromEnd = new PropertyId(from.getId(), linkId);
        if (this.linksCache.getObject((Object)fromEnd) != null) {
            throw new IllegalStateException("Link is already cached, at first it should be invalidated");
        }
        this.linksCache.cacheObject((Object)fromEnd, (Object)to);
    }

    PersistentEntityId getCachedLink(@NotNull PersistentEntity from, int linkId) {
        return (PersistentEntityId)this.linksCache.tryKey((Object)new PropertyId(from.getId(), linkId));
    }

    void cacheBlobString(@NotNull PersistentEntity from, int blobId, @NotNull String value) {
        PropertyId fromEnd = new PropertyId(from.getId(), blobId);
        if (this.blobStringsCache.getObject((Object)fromEnd) != null) {
            throw new IllegalStateException("Blob string is already cached, at first it should be invalidated");
        }
        this.blobStringsCache.cacheObject((Object)fromEnd, (Object)value);
    }

    String getCachedBlobString(@NotNull PersistentEntity from, int blobId) {
        return (String)this.blobStringsCache.tryKey((Object)new PropertyId(from.getId(), blobId));
    }

    void invalidateCachedBlobString(@NotNull PersistentEntity from, int blobId) {
        this.blobStringsCache.remove((Object)new PropertyId(from.getId(), blobId));
    }

    boolean isMutable() {
        return this.mutableCache != null;
    }

    void entityDeleted(@NotNull PersistentEntityId id) {
        new EntityDeletedHandleCheckerImpl(this, id, this.mutableCache(), this.mutatedInTxn).updateCache();
    }

    void propertyChanged(@NotNull PersistentEntityId id, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
        PropertyId propId = new PropertyId(id, propertyId);
        this.propsCache.remove((Object)propId);
        new PropertyChangedHandleCheckerImpl(this, id, propertyId, oldValue, newValue, this.mutableCache(), this.mutatedInTxn).updateCache();
    }

    void linkAdded(@NotNull PersistentEntityId sourceId, @NotNull PersistentEntityId targetId, int linkId) {
        PropertyId propId = new PropertyId(sourceId, linkId);
        this.linksCache.remove((Object)propId);
        new LinkAddedHandleChecker(this, sourceId, targetId, linkId, this.mutableCache(), this.mutatedInTxn).updateCache();
    }

    void linkDeleted(@NotNull PersistentEntityId sourceId, @NotNull PersistentEntityId targetId, int linkId) {
        PropertyId propId = new PropertyId(sourceId, linkId);
        this.linksCache.remove((Object)propId);
        new LinkDeletedHandleChecker(this, sourceId, targetId, linkId, this.mutableCache(), this.mutatedInTxn).updateCache();
    }

    void addBlob(long blobHandle, @NotNull InputStream stream) {
        LongHashMap blobStreams = this.blobStreams;
        if (blobStreams == null) {
            this.blobStreams = blobStreams = new LongHashMap();
        }
        if (!stream.markSupported()) {
            throw new EntityStoreException("Blob input stream should support the mark and reset methods");
        }
        stream.mark(Integer.MAX_VALUE);
        blobStreams.put(blobHandle, (Object)stream);
    }

    void addBlob(long blobHandle, @NotNull File file) {
        LongHashMap blobFiles = this.blobFiles;
        if (blobFiles == null) {
            this.blobFiles = blobFiles = new LongHashMap();
        }
        blobFiles.put(blobHandle, (Object)file);
    }

    void deleteBlob(long blobHandle) {
        if (this.blobStreams != null) {
            this.blobStreams.remove(blobHandle);
        }
        if (this.blobFiles != null) {
            this.blobFiles.remove(blobHandle);
        }
    }

    long getBlobSize(long blobHandle) throws IOException {
        File file;
        InputStream stream;
        LongHashMap<InputStream> blobStreams = this.blobStreams;
        if (blobStreams != null && (stream = (InputStream)blobStreams.get(blobHandle)) != null) {
            stream.reset();
            return stream.skip(Long.MAX_VALUE);
        }
        LongHashMap<File> blobFiles = this.blobFiles;
        if (blobFiles != null && (file = (File)blobFiles.get(blobHandle)) != null) {
            return file.length();
        }
        return -1L;
    }

    @Nullable
    InputStream getBlobStream(long blobHandle) throws IOException {
        File file;
        InputStream stream;
        LongHashMap<InputStream> blobStreams = this.blobStreams;
        if (blobStreams != null && (stream = (InputStream)blobStreams.get(blobHandle)) != null) {
            stream.reset();
            return stream;
        }
        LongHashMap<File> blobFiles = this.blobFiles;
        if (blobFiles != null && (file = (File)blobFiles.get(blobHandle)) != null) {
            return this.store.getBlobVault().cloneFile(file);
        }
        return null;
    }

    void deferBlobDeletion(long blobHandle) {
        if (this.deferredBlobsToDelete == null) {
            this.deferredBlobsToDelete = new LongHashSet();
        }
        this.deferredBlobsToDelete.add(blobHandle);
    }

    void closeCaches() {
        this.propsCache.close();
        this.linksCache.close();
        this.blobStringsCache.close();
    }

    void revertCaches() {
        this.revertCaches(true);
    }

    private void revertCaches(boolean clearPropsAndLinksCache) {
        if (clearPropsAndLinksCache) {
            this.propsCache.clear();
            this.linksCache.clear();
            this.blobStringsCache.clear();
        }
        this.localCache = this.store.getEntityIterableCache().getCacheAdapter();
        this.mutableCache = null;
        this.mutatedInTxn = null;
        this.blobStreams = null;
        this.blobFiles = null;
        this.deferredBlobsToDelete = null;
    }

    void apply() {
        final FlushLog log = new FlushLog();
        this.store.logOperations(this.txn, log);
        BlobVault blobVault = this.store.getBlobVault();
        if (blobVault.requiresTxn()) {
            try {
                blobVault.flushBlobs(this.blobStreams, this.blobFiles, this.deferredBlobsToDelete, this.txn);
            }
            catch (Exception e) {
                throw ExodusException.toEntityStoreException((Throwable)e);
            }
        }
        this.txn.setCommitHook(new Runnable(){

            @Override
            public void run() {
                log.flushed();
                EntityIterableCacheAdapterMutable cache = PersistentStoreTransaction.this.mutableCache;
                if (cache != null) {
                    PersistentStoreTransaction.this.applyAtomicCaches(cache);
                }
            }
        });
    }

    private void applyAtomicCaches(@NotNull EntityIterableCacheAdapterMutable cache) {
        EntityIterableCache entityIterableCache = this.store.getEntityIterableCache();
        for (Updatable it : this.mutatedInTxn) {
            it.endUpdate(this);
        }
        if (!entityIterableCache.compareAndSetCacheAdapter(this.localCache, cache.endWrite())) {
            throw new EntityStoreException("This exception should never be thrown");
        }
    }

    private void applyExclusiveTransactionCaches() {
        final EntityIterableCacheAdapterMutable cache = this.mutableCache;
        if (cache != null) {
            UnsafeKt.executeInMetaWriteLock((EnvironmentImpl)((EnvironmentImpl)this.store.getEnvironment()), (Function0)new Function0<Object>(){

                public Object invoke() {
                    PersistentStoreTransaction.this.applyAtomicCaches(cache);
                    return null;
                }
            });
        }
    }

    private Runnable getRevertCachesBeginHook() {
        return new Runnable(){

            @Override
            public void run() {
                PersistentStoreTransaction.this.revertCaches();
            }
        };
    }

    private void flushNonTransactionalBlobs() {
        BlobVault blobVault = this.store.getBlobVault();
        if (!(blobVault.requiresTxn() || this.blobStreams == null && this.blobFiles == null && this.deferredBlobsToDelete == null)) {
            ((EnvironmentImpl)this.txn.getEnvironment()).flushAndSync();
            try {
                blobVault.flushBlobs(this.blobStreams, this.blobFiles, this.deferredBlobsToDelete, this.txn);
            }
            catch (Exception e) {
                this.handleOutOfDiskSpace(e);
                throw ExodusException.toEntityStoreException((Throwable)e);
            }
        }
    }

    private EntityIterableCacheAdapterMutable mutableCache() {
        EntityIterableCacheAdapterMutable cache = this.mutableCache;
        if (this.mutableCache == null) {
            this.mutableCache = cache = this.createMutableCache();
        }
        return cache;
    }

    private EntityIterableCacheAdapterMutable createMutableCache() {
        EntityIterableCacheAdapterMutable result = this.localCache.getClone();
        this.mutatedInTxn = new ArrayList<Updatable>();
        return result;
    }

    private void handleOutOfDiskSpace(Exception e) {
        if (e instanceof IOException && this.store.getUsableSpace() < 4096L) {
            throw new OutOfDiskSpaceException((Throwable)e);
        }
    }

    public static <T> T getUpdatable(@NotNull HandleChecker handleChecker, @NotNull EntityIterableHandle handle, @NotNull Class<T> handleType) {
        HandleCheckerAdapter checker = (HandleCheckerAdapter)handleChecker;
        Updatable instance = checker.get(handle);
        if (instance != null) {
            if (!instance.isMutated()) {
                if (handleType.isAssignableFrom((instance = instance.beginUpdate(checker.txn)).getClass())) {
                    checker.beginUpdate(instance);
                    return (T)instance;
                }
            } else if (handleType.isAssignableFrom(instance.getClass())) {
                return (T)instance;
            }
            checker.remove(handle);
            if (logger.isErrorEnabled()) {
                String handlePart = instance instanceof EntityIterableBase ? ", handle = " + ((EntityIterableBase)((Object)instance)).getHandle() : "";
                logger.error("Iterable doesn't match expected class " + handleType.getName() + ", handle = " + handle + ", found = " + instance.getClass().getName() + handlePart);
            }
        }
        return null;
    }

    private static <V> ObjectCacheBase<PropertyId, V> createObjectCache(int size) {
        return size == 0 ? new FakeObjectCache() : new TransactionObjectCache(size);
    }

    private static final class TransactionObjectCache<V>
    extends ObjectCacheDecorator<PropertyId, V> {
        private TransactionObjectCache(int size) {
            super(size);
        }

        protected ObjectCacheBase<PropertyId, V> createdDecorated() {
            return new NonAdjustableConcurrentObjectCache(this.size(), 2);
        }
    }

    private static final class PropertyChangedHandleCheckerImpl
    extends HandleCheckerAdapter
    implements PropertyChangedHandleChecker {
        private final EntityId id;
        private final int propertyId;
        @Nullable
        private final Comparable oldValue;
        @Nullable
        private final Comparable newValue;

        private PropertyChangedHandleCheckerImpl(@NotNull PersistentStoreTransaction txn, EntityId id, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue, @NotNull EntityIterableCacheAdapterMutable mutatedInTxn, @NotNull List<Updatable> mutableCache) {
            super(txn, mutableCache, mutatedInTxn);
            if (oldValue == null && newValue == null) {
                throw new IllegalArgumentException("Either oldValue or newValue should be not null");
            }
            this.id = id;
            this.propertyId = propertyId;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public int getPropertyId() {
            return this.propertyId;
        }

        @Override
        public int getTypeId() {
            return this.id.getTypeId();
        }

        @Override
        public long getLocalId() {
            return this.id.getLocalId();
        }

        @Override
        @Nullable
        public Comparable getOldValue() {
            return this.oldValue;
        }

        @Override
        @Nullable
        public Comparable getNewValue() {
            return this.newValue;
        }

        @Override
        public boolean checkHandle(@NotNull EntityIterableHandle handle) {
            return handle.isMatchedPropertyChanged(this.id, this.propertyId, this.oldValue, this.newValue) && !handle.onPropertyChanged(this);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyChangedHandleCheckerImpl that = (PropertyChangedHandleCheckerImpl)obj;
            if (this.propertyId != that.propertyId) {
                return false;
            }
            if (!this.id.equals(that.id)) {
                return false;
            }
            if (this.newValue != null ? !this.newValue.equals(that.newValue) : that.newValue != null) {
                return false;
            }
            return !(this.oldValue == null ? that.oldValue != null : !this.oldValue.equals(that.oldValue));
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.propertyId;
            result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
            result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
            return result;
        }
    }

    private static final class LinkDeletedHandleChecker
    extends LinkChangedHandleCheckerImpl {
        private LinkDeletedHandleChecker(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntityId sourceId, @NotNull PersistentEntityId targetId, int linkId, @NotNull EntityIterableCacheAdapterMutable mutatedInTxn, @NotNull List<Updatable> mutableCache) {
            super(txn, sourceId, targetId, linkId, mutableCache, mutatedInTxn);
        }

        @Override
        public boolean checkHandle(@NotNull EntityIterableHandle handle) {
            return handle.isMatchedLinkDeleted(this.sourceId, this.targetId, this.linkId) && !handle.onLinkDeleted(this);
        }
    }

    private static final class LinkAddedHandleChecker
    extends LinkChangedHandleCheckerImpl {
        private LinkAddedHandleChecker(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntityId sourceId, @NotNull PersistentEntityId targetId, int linkId, @NotNull EntityIterableCacheAdapterMutable mutatedInTxn, @NotNull List<Updatable> mutableCache) {
            super(txn, sourceId, targetId, linkId, mutableCache, mutatedInTxn);
        }

        @Override
        public boolean checkHandle(@NotNull EntityIterableHandle handle) {
            return handle.isMatchedLinkAdded(this.sourceId, this.targetId, this.linkId) && !handle.onLinkAdded(this);
        }
    }

    private static abstract class LinkChangedHandleCheckerImpl
    extends HandleCheckerAdapter
    implements LinkChangedHandleChecker {
        @NotNull
        final PersistentEntityId sourceId;
        @NotNull
        final PersistentEntityId targetId;
        protected final int linkId;

        private LinkChangedHandleCheckerImpl(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntityId sourceId, @NotNull PersistentEntityId targetId, int linkId, @NotNull List<Updatable> mutatedInTxn, @NotNull EntityIterableCacheAdapterMutable mutableCache) {
            super(txn, mutatedInTxn, mutableCache);
            this.sourceId = sourceId;
            this.targetId = targetId;
            this.linkId = linkId;
        }

        @Override
        public int getLinkId() {
            return this.linkId;
        }

        @Override
        public EntityId getSourceId() {
            return this.sourceId;
        }

        @Override
        public EntityId getTargetId() {
            return this.targetId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LinkChangedHandleCheckerImpl that = (LinkChangedHandleCheckerImpl)obj;
            if (this.linkId != that.linkId) {
                return false;
            }
            if (!this.sourceId.equals(that.sourceId)) {
                return false;
            }
            return this.targetId.equals(that.targetId);
        }

        public int hashCode() {
            int result = this.sourceId.hashCode();
            result = 31 * result + this.targetId.hashCode();
            result = 31 * result + this.linkId;
            return result;
        }
    }

    private static class EntityAddedHandleCheckerImpl
    extends EntityAddedOrDeletedHandleCheckerAdapter {
        private EntityAddedHandleCheckerImpl(@NotNull PersistentStoreTransaction txn, @NotNull EntityId id, @NotNull EntityIterableCacheAdapterMutable mutableCache, @NotNull List<Updatable> mutatedInTxn) {
            super(txn, id, mutatedInTxn, mutableCache);
        }

        @Override
        public boolean checkHandle(@NotNull EntityIterableHandle handle) {
            return handle.isMatchedEntityAdded(this.id) && !handle.onEntityAdded(this);
        }
    }

    private static class EntityDeletedHandleCheckerImpl
    extends EntityAddedOrDeletedHandleCheckerAdapter {
        private EntityDeletedHandleCheckerImpl(@NotNull PersistentStoreTransaction txn, @NotNull EntityId id, @NotNull EntityIterableCacheAdapterMutable mutatedInTxn, @NotNull List<Updatable> mutableCache) {
            super(txn, id, mutableCache, mutatedInTxn);
        }

        @Override
        public int getTypeId() {
            return this.id.getTypeId();
        }

        @Override
        public boolean checkHandle(@NotNull EntityIterableHandle handle) {
            return handle.isMatchedEntityDeleted(this.id) && !handle.onEntityDeleted(this);
        }
    }

    private static abstract class EntityAddedOrDeletedHandleCheckerAdapter
    extends HandleCheckerAdapter
    implements EntityAddedOrDeletedHandleChecker {
        protected final EntityId id;

        EntityAddedOrDeletedHandleCheckerAdapter(@NotNull PersistentStoreTransaction txn, @NotNull EntityId id, @NotNull List<Updatable> mutatedInTxn, @NotNull EntityIterableCacheAdapterMutable mutableCache) {
            super(txn, mutatedInTxn, mutableCache);
            this.id = id;
        }

        @Override
        public EntityId getId() {
            return this.id;
        }

        @Override
        public int getTypeIdAffectingCreation() {
            return this.id.getTypeId();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EntityAddedOrDeletedHandleCheckerAdapter that = (EntityAddedOrDeletedHandleCheckerAdapter)obj;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    private static class PropertyId {
        @NotNull
        private final PersistentEntityId entityId;
        private final int propId;

        private PropertyId(@NotNull PersistentEntityId entityId, int propId) {
            this.entityId = entityId;
            this.propId = propId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyId propertyId = (PropertyId)obj;
            return this.propId == propertyId.propId && this.entityId.equals(propertyId.entityId);
        }

        public int hashCode() {
            return 31 * this.entityId.hashCode() + this.propId;
        }
    }

    static abstract class HandleCheckerAdapter
    implements HandleChecker {
        @NotNull
        final PersistentStoreTransaction txn;
        @NotNull
        final List<Updatable> mutatedInTxn;
        @NotNull
        final EntityIterableCacheAdapterMutable mutableCache;

        HandleCheckerAdapter(@NotNull PersistentStoreTransaction txn, @NotNull List<Updatable> mutatedInTxn, @NotNull EntityIterableCacheAdapterMutable mutableCache) {
            this.txn = txn;
            this.mutatedInTxn = mutatedInTxn;
            this.mutableCache = mutableCache;
        }

        @Override
        public int getLinkId() {
            return -1;
        }

        @Override
        public int getPropertyId() {
            return -1;
        }

        @Override
        public int getTypeId() {
            return -1;
        }

        @Override
        public int getTypeIdAffectingCreation() {
            return -1;
        }

        @Override
        @NotNull
        public PersistentStoreTransaction getTxn() {
            return this.txn;
        }

        @Override
        public void beginUpdate(@NotNull Updatable instance) {
            this.mutatedInTxn.add(instance);
        }

        void updateCache() {
            this.mutableCache.update(this);
        }

        abstract boolean checkHandle(@NotNull EntityIterableHandle var1);

        Updatable get(@NotNull EntityIterableHandle handle) {
            return this.mutableCache.getUpdatable(handle);
        }

        void remove(@NotNull EntityIterableHandle handle) {
            this.mutableCache.remove(handle);
        }

        @Override
        @Deprecated
        public Updatable getUpdatableIterable(@NotNull EntityIterableHandle handle) {
            return PersistentStoreTransaction.getUpdatable(this, handle, Updatable.class);
        }
    }

    static enum TransactionType {
        Regular,
        Exclusive,
        Readonly;

    }
}

