/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.iterate.BloomIdFilter;
import org.jetbrains.annotations.NotNull;

final class BinarySearchIdFilter
extends BloomIdFilter {
    BinarySearchIdFilter(@NotNull int[] ids) {
        super(ids);
    }

    @Override
    public boolean hasId(int id) {
        if (super.hasId(id)) {
            int high = this.ids.length - 1;
            int low = 0;
            while (low <= high) {
                int mid = low + high >>> 1;
                int midVal = this.ids[mid];
                if (midVal < id) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > id) {
                    high = mid - 1;
                    continue;
                }
                return true;
            }
        }
        return false;
    }
}

