/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.binop;

import java.util.Iterator;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.binop.BinaryOperatorEntityIterable;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnionIterable
extends BinaryOperatorEntityIterable {
    public UnionIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
        super(txn, iterable1, iterable2, true);
        if (iterable1.isSortedById() && iterable2.isSortedById()) {
            this.depth += 0x20000000;
        }
    }

    @Override
    protected EntityIterableType getIterableType() {
        return EntityIterableType.UNION;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIterableBase iterable1 = this.iterable1;
        EntityIterableBase iterable2 = this.iterable2;
        if (this.isSortedById()) {
            return new EntityIteratorFixingDecorator(this, new SortedIterator(this, iterable1, iterable2));
        }
        if (iterable1.isSortedById()) {
            EntityIterableBase temp = iterable1;
            iterable1 = iterable2;
            iterable2 = temp;
        }
        return new EntityIteratorFixingDecorator(this, new UnsortedIterator(txn, this, iterable1, iterable2));
    }

    private static Iterator<EntityId> toEntityIdIterator(final @NotNull EntityIterator it) {
        return new Iterator<EntityId>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public EntityId next() {
                return it.nextId();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        UnionIterable.registerType(EntityIterableType.UNION, new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new UnionIterable(txn, (EntityIterableBase)parameters[0], (EntityIterableBase)parameters[1]);
            }
        });
    }

    private static final class UnsortedIterator
    extends NonDisposableEntityIterator {
        @NotNull
        private final PersistentStoreTransaction txn;
        @NotNull
        private final EntityIterableBase iterable1;
        @NotNull
        private final EntityIterableBase iterable2;
        private EntityIdSet iterated;
        private Iterator<EntityId> iterator1;
        private Iterator<EntityId> iterator2;
        private EntityId nextId;

        private UnsortedIterator(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase iterable, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
            super(iterable);
            this.txn = txn;
            if (iterable1.isSortedById()) {
                this.iterable1 = iterable1;
                this.iterable2 = iterable2;
            } else {
                this.iterable1 = iterable2;
                this.iterable2 = iterable1;
            }
            this.iterated = EntityIdSetFactory.newSet();
            this.nextId = PersistentEntityId.EMPTY_ID;
        }

        @Override
        protected boolean hasNextImpl() {
            if (this.nextId == PersistentEntityId.EMPTY_ID) {
                Iterator iterator = this.iterator1 = this.iterable1.isSortedById() ? UnionIterable.toEntityIdIterator(this.iterable1.iterator()) : this.iterable1.toSet(this.txn).iterator();
            }
            if (this.iterator1 != null) {
                if (this.iterator1.hasNext()) {
                    this.nextId = this.iterator1.next();
                    return true;
                }
                this.iterator1 = null;
                Iterator iterator = this.iterator2 = this.iterable2.isSortedById() ? UnionIterable.toEntityIdIterator(this.iterable2.iterator()) : this.iterable2.toSet(this.txn).iterator();
            }
            while (this.iterator2 != null && this.iterator2.hasNext()) {
                EntityId nextId = this.iterator2.next();
                if (this.iterated.contains(nextId)) continue;
                this.nextId = nextId;
                return true;
            }
            this.iterator2 = null;
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            EntityId nextId = this.nextId;
            this.iterated = this.iterated.add(nextId);
            return nextId;
        }

        @Override
        @Nullable
        protected EntityIdSet toSet() {
            return this.iterated;
        }
    }

    private static final class SortedIterator
    extends NonDisposableEntityIterator {
        private EntityIteratorBase iterator1;
        private EntityIteratorBase iterator2;
        private EntityId e1;
        private EntityId e2;
        private EntityId nextId;

        private SortedIterator(@NotNull EntityIterableBase iterable, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
            super(iterable);
            this.iterator1 = (EntityIteratorBase)iterable1.iterator();
            this.iterator2 = (EntityIteratorBase)iterable2.iterator();
            this.nextId = null;
            this.e1 = null;
            this.e2 = null;
        }

        @Override
        protected boolean hasNextImpl() {
            if (this.e1 == null && this.iterator1 != null) {
                if (this.iterator1.hasNext()) {
                    this.e1 = this.iterator1.nextId();
                } else {
                    this.iterator1 = null;
                }
            }
            if (this.e2 == null && this.iterator2 != null) {
                if (this.iterator2.hasNext()) {
                    this.e2 = this.iterator2.nextId();
                } else {
                    this.iterator2 = null;
                }
            }
            if (this.e1 == null) {
                this.nextId = this.e2;
                this.e2 = null;
            } else if (this.e2 == null) {
                this.nextId = this.e1;
                this.e1 = null;
            } else {
                int cmp = this.e1.compareTo((Object)this.e2);
                if (cmp < 0) {
                    this.nextId = this.e1;
                    this.e1 = null;
                } else if (cmp > 0) {
                    this.nextId = this.e2;
                    this.e2 = null;
                } else {
                    this.nextId = this.e1;
                    this.e2 = null;
                    this.e1 = null;
                }
            }
            return this.nextId != null;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            EntityId nextId = this.nextId;
            this.nextId = null;
            return nextId;
        }
    }
}

