/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.tables;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.TwoColumnTable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NotNull;

public final class LinksTable
extends TwoColumnTable {
    private final Store allLinksIndex;

    public LinksTable(@NotNull PersistentStoreTransaction txn, @NotNull String name, @NotNull StoreConfig config) {
        super(txn, name, config);
        PersistentEntityStoreImpl store = txn.getStore();
        Transaction envTxn = txn.getEnvironmentTransaction();
        Environment env = store.getEnvironment();
        this.allLinksIndex = env.openStore(name + "#all_idx", StoreConfig.WITH_DUPLICATES_WITH_PREFIXING, envTxn);
        store.trackTableCreation(this.allLinksIndex, txn);
    }

    @Override
    public boolean put(@NotNull Transaction txn, @NotNull ByteIterable first, @NotNull ByteIterable second) {
        return super.put(txn, first, second);
    }

    @Override
    @NotNull
    public Cursor getFirstIndexCursor(@NotNull Transaction txn) {
        return super.getFirstIndexCursor(txn);
    }

    @Override
    @NotNull
    public Cursor getSecondIndexCursor(@NotNull Transaction txn) {
        return super.getSecondIndexCursor(txn);
    }

    public boolean put(@NotNull Transaction txn, long localId, @NotNull ByteIterable value, boolean noOldValue, int linkId) {
        PropertyKey linkKey = new PropertyKey(localId, linkId);
        boolean success = super.put(txn, (ByteIterable)PropertyKey.propertyKeyToEntry(linkKey), value);
        if (noOldValue) {
            success |= this.allLinksIndex.put(txn, (ByteIterable)IntegerBinding.intToCompressedEntry((int)linkId), (ByteIterable)LongBinding.longToCompressedEntry((long)localId));
        }
        return success;
    }

    @Override
    public boolean delete(@NotNull Transaction txn, @NotNull ByteIterable first, @NotNull ByteIterable second) {
        return super.delete(txn, first, second);
    }

    public boolean delete(@NotNull Transaction txn, long localId, @NotNull ByteIterable value, boolean noNewValue, int linkId) {
        PropertyKey linkKey = new PropertyKey(localId, linkId);
        boolean success = super.delete(txn, (ByteIterable)PropertyKey.propertyKeyToEntry(linkKey), value);
        if (noNewValue) {
            success |= this.deleteAllIndex(txn, linkId, localId);
        }
        return success;
    }

    public boolean deleteAllIndex(@NotNull Transaction txn, int linkId, long localId) {
        return LinksTable.deletePair(this.allLinksIndex.openCursor(txn), (ByteIterable)IntegerBinding.intToCompressedEntry((int)linkId), (ByteIterable)LongBinding.longToCompressedEntry((long)localId));
    }

    public Store getAllLinksIndex() {
        return this.allLinksIndex;
    }

    @Override
    public boolean canBeCached() {
        return super.canBeCached() && !this.allLinksIndex.getConfig().temporaryEmpty;
    }

    private static boolean deletePair(@NotNull Cursor c, @NotNull ByteIterable key, @NotNull ByteIterable value) {
        boolean result = c.getSearchBoth(key, value);
        if (result) {
            result = c.deleteCurrent();
        }
        c.close();
        return result;
    }
}

