/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import jetbrains.exodus.core.dataStructures.SoftConcurrentObjectCache;
import jetbrains.exodus.core.dataStructures.SoftObjectCache;
import jetbrains.exodus.core.dataStructures.SoftObjectCacheBase;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.Sorts;

public class OptimizedTreesCache {
    private static final OptimizedTreesCache INSTANCE = new OptimizedTreesCache();
    private static final int CACHE_SIZE = 16384;
    private final SoftObjectCacheBase<String, OptimizedTreeAndSorts> cache;

    private OptimizedTreesCache() {
        boolean blocking = "false".equals(System.getProperty("exodus.query.treeCache.nonBlocking"));
        this.cache = blocking ? new SoftObjectCache(16384) : new SoftConcurrentObjectCache(16384);
    }

    OptimizedTreeAndSorts findOptimized(NodeBase tree) {
        return (OptimizedTreeAndSorts)this.cache.tryKey((Object)tree.getHandle());
    }

    void cacheOptimized(NodeBase original, NodeBase optimized, Sorts sorts) {
        this.cache.cacheObject((Object)original.getHandle(), (Object)new OptimizedTreeAndSorts(optimized, sorts));
    }

    public static OptimizedTreesCache get() {
        return INSTANCE;
    }

    public static class OptimizedTreeAndSorts {
        private final Sorts sorts;
        private final NodeBase optimizedTree;

        public OptimizedTreeAndSorts(NodeBase optimizedTree, Sorts sorts) {
            this.optimizedTree = optimizedTree;
            this.sorts = sorts;
        }

        public Sorts getSorts() {
            return this.sorts;
        }

        public NodeBase getOptimizedTree() {
            return this.optimizedTree;
        }
    }
}

