/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.query;

import java.util.ArrayList;
import java.util.Comparator;
import jetbrains.exodus.entitystore.ComparableGetter;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesOfTypeIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.InMemoryMergeSortIterable;
import jetbrains.exodus.query.InMemoryMergeSortIterableWithValueGetter;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.Utils;
import jetbrains.exodus.query.metadata.AssociationEndMetaData;
import jetbrains.exodus.query.metadata.AssociationMetaData;
import jetbrains.exodus.query.metadata.AssociationType;
import jetbrains.exodus.query.metadata.EntityMetaData;
import jetbrains.exodus.query.metadata.ModelMetaData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortEngine {
    private static final int MAX_ENTRIES_TO_SORT_IN_MEMORY = Integer.getInteger("jetbrains.exodus.query.maxEntriesToSortInMemory", 10000000);
    private static final int MAX_ENUM_COUNT_TO_SORT_LINKS = Integer.getInteger("jetbrains.exodus.query.maxEnumCountToSortLinks", 2048);
    private static final int MIN_ENTRIES_TO_SORT_LINKS = Integer.getInteger("jetbrains.exodus.query.minEntriesToSortLinks", 16);
    private static final Comparator<Comparable<Object>> PROPERTY_VALUE_COMPARATOR = new Comparator<Comparable<Object>>(){

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            return SortEngine.compareNullableComparables(o1, o2);
        }
    };
    private static final Comparator<Comparable<Object>> REVERSE_PROPERTY_VALUE_COMPARATOR = new Comparator<Comparable<Object>>(){

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            return SortEngine.compareNullableComparables(o2, o1);
        }
    };
    protected QueryEngine queryEngine;

    public SortEngine() {
    }

    public SortEngine(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    public void setQueryEngine(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    protected Entity attach(Entity entity) {
        return entity;
    }

    @Nullable
    private Comparable getProperty(Entity entity, String propertyName, boolean readOnlyTxn) {
        if (readOnlyTxn && !(entity instanceof PersistentEntity)) {
            return this.queryEngine.getPersistentStore().getEntity(entity.getId()).getProperty(propertyName);
        }
        return entity.getProperty(propertyName);
    }

    @NotNull
    private Iterable<Entity> getLinks(Entity entity, String linkName, boolean readOnlyTxn) {
        if (readOnlyTxn && !(entity instanceof PersistentEntity)) {
            return this.queryEngine.getPersistentStore().getEntity(entity.getId()).getLinks(linkName);
        }
        return entity.getLinks(linkName);
    }

    public Iterable<Entity> sort(String entityType, final String propertyName, Iterable<Entity> source, final boolean ascending) {
        EntityMetaData emd;
        PersistentStoreTransaction txn = this.queryEngine.getPersistentStore().getAndCheckCurrentTransaction();
        ComparableGetter valueGetter = this.propertyGetter(propertyName, txn.isReadonly());
        ModelMetaData mmd = this.queryEngine.getModelMetaData();
        if (mmd != null && (emd = mmd.getEntityMetaData(entityType)) != null) {
            if (source == null) {
                return this.mergeSorted(emd, new IterableGetter(){

                    @Override
                    public EntityIterableBase getIterable(String type) {
                        SortEngine.this.queryEngine.assertOperational();
                        return (EntityIterableBase)SortEngine.this.queryEngine.getPersistentStore().getAndCheckCurrentTransaction().sort(type, propertyName, ascending);
                    }
                }, valueGetter, SortEngine.caseInsensitiveComparator(ascending));
            }
            Iterable<Entity> i = this.queryEngine.toEntityIterable(source);
            if (this.queryEngine.isPersistentIterable(i)) {
                EntityIterableBase it = ((EntityIterableBase)i).getSource();
                if (it == EntityIterableBase.EMPTY) {
                    return this.queryEngine.wrap((EntityIterable)EntityIterableBase.EMPTY);
                }
                if (it.getRoughCount() == 0L && it.count() == 0L) {
                    return this.queryEngine.wrap(EntityIterableBase.EMPTY.asSortResult());
                }
                return this.mergeSorted(emd, new IterableGetter((EntityIterable)it, ascending){
                    final /* synthetic */ EntityIterable val$it;
                    final /* synthetic */ boolean val$ascending;
                    {
                        this.val$it = entityIterable;
                        this.val$ascending = bl;
                    }

                    @Override
                    public EntityIterableBase getIterable(String type) {
                        SortEngine.this.queryEngine.assertOperational();
                        return (EntityIterableBase)SortEngine.this.queryEngine.getPersistentStore().getAndCheckCurrentTransaction().sort(type, propertyName, this.val$it, this.val$ascending);
                    }
                }, valueGetter, SortEngine.caseInsensitiveComparator(ascending));
            }
        }
        if (source == null) {
            source = this.getAllEntities(entityType, mmd);
        }
        return this.sortInMemory(source, valueGetter, ascending);
    }

    public Iterable<Entity> sort(String enumType, final String propName, String entityType, final String linkName, Iterable<Entity> source, boolean ascending) {
        EntityMetaData emd;
        final PersistentStoreTransaction txn = this.queryEngine.getPersistentStore().getAndCheckCurrentTransaction();
        Object valueGetter = null;
        ModelMetaData mmd = this.queryEngine.getModelMetaData();
        if (mmd != null && (emd = mmd.getEntityMetaData(entityType)) != null) {
            final boolean isMultiple = emd.getAssociationEndMetaData(linkName).getCardinality().isMultiple();
            valueGetter = isMultiple ? new MultipleLinkComparableGetter(linkName, propName, ascending, txn.isReadonly()) : new SingleLinkComparableGetter(linkName, propName, txn.isReadonly(), txn);
            Iterable<Entity> i = this.queryEngine.toEntityIterable((Iterable<Entity>)source);
            if (this.queryEngine.isPersistentIterable(i)) {
                EntityIterableBase s = ((EntityIterableBase)i).getSource();
                if (s == EntityIterableBase.EMPTY) {
                    return this.queryEngine.wrap((EntityIterable)EntityIterableBase.EMPTY);
                }
                long sourceCount = s.getRoughCount();
                if (sourceCount == 0L && s.count() == 0L) {
                    return this.queryEngine.wrap(EntityIterableBase.EMPTY.asSortResult());
                }
                if (sourceCount < 0L || sourceCount >= (long)MIN_ENTRIES_TO_SORT_LINKS) {
                    EntityIterableBase distinctLinks;
                    long enumCount;
                    CachedInstanceIterable it = s.getOrCreateCachedInstance(txn);
                    EntityIterableBase allLinks = ((EntityIterableBase)this.queryEngine.queryGetAll(enumType).instantiate()).getSource();
                    long l = enumCount = allLinks instanceof EntitiesOfTypeIterable ? allLinks.size() : allLinks.getRoughCount();
                    if (enumCount < 0L || enumCount > (long)MAX_ENUM_COUNT_TO_SORT_LINKS) {
                        distinctLinks = ((EntityIterableBase)(isMultiple ? this.queryEngine.selectManyDistinct((Iterable<Entity>)it, linkName) : this.queryEngine.selectDistinct((Iterable<Entity>)it, linkName))).getSource();
                        enumCount = distinctLinks.getRoughCount();
                    } else {
                        distinctLinks = allLinks;
                    }
                    if (sourceCount > (long)MAX_ENTRIES_TO_SORT_IN_MEMORY || enumCount <= (long)MAX_ENUM_COUNT_TO_SORT_LINKS) {
                        EntityMetaData oppositeEmd;
                        AssociationMetaData amd;
                        ComparableGetter linksGetter = this.propertyGetter(propName, txn.isReadonly());
                        final EntityIterableBase distinctSortedLinks = this.mergeSorted(mmd.getEntityMetaData(enumType), new IterableGetter((EntityIterable)distinctLinks, ascending){
                            final /* synthetic */ EntityIterable val$distinctLinks;
                            final /* synthetic */ boolean val$ascending;
                            {
                                this.val$distinctLinks = entityIterable;
                                this.val$ascending = bl;
                            }

                            @Override
                            public EntityIterableBase getIterable(String type) {
                                SortEngine.this.queryEngine.assertOperational();
                                return (EntityIterableBase)txn.sort(type, propName, this.val$distinctLinks, this.val$ascending);
                            }
                        }, linksGetter, SortEngine.caseInsensitiveComparator(ascending));
                        AssociationEndMetaData aemd = emd.getAssociationEndMetaData(linkName);
                        if (aemd != null && (amd = aemd.getAssociationMetaData()).getType() != AssociationType.Directed && !(oppositeEmd = aemd.getOppositeEntityMetaData()).hasSubTypes()) {
                            String oppositeType = oppositeEmd.getType();
                            AssociationEndMetaData oppositeAemd = amd.getOppositeEnd(aemd);
                            String oppositeLinkName = oppositeAemd.getName();
                            return this.mergeSorted(emd, new IterableGetter((EntityIterable)it, oppositeType, oppositeLinkName){
                                final /* synthetic */ EntityIterable val$it;
                                final /* synthetic */ String val$oppositeType;
                                final /* synthetic */ String val$oppositeLinkName;
                                {
                                    this.val$it = entityIterable;
                                    this.val$oppositeType = string2;
                                    this.val$oppositeLinkName = string3;
                                }

                                @Override
                                public EntityIterableBase getIterable(String type) {
                                    SortEngine.this.queryEngine.assertOperational();
                                    return (EntityIterableBase)txn.sortLinks(type, (EntityIterable)distinctSortedLinks.getSource(), isMultiple, linkName, this.val$it, this.val$oppositeType, this.val$oppositeLinkName);
                                }
                            }, (ComparableGetter)valueGetter, SortEngine.caseInsensitiveComparator(ascending));
                        }
                        return this.mergeSorted(emd, new IterableGetter((EntityIterable)it){
                            final /* synthetic */ EntityIterable val$it;
                            {
                                this.val$it = entityIterable;
                            }

                            @Override
                            public EntityIterableBase getIterable(String type) {
                                SortEngine.this.queryEngine.assertOperational();
                                return (EntityIterableBase)txn.sortLinks(type, (EntityIterable)distinctSortedLinks.getSource(), isMultiple, linkName, this.val$it);
                            }
                        }, (ComparableGetter)valueGetter, SortEngine.caseInsensitiveComparator(ascending));
                    }
                    source = this.queryEngine.wrap((EntityIterable)it);
                } else {
                    source = this.queryEngine.wrap((EntityIterable)s);
                }
            }
        }
        if (source == null) {
            source = this.getAllEntities(entityType, mmd);
        }
        return this.sortInMemory((Iterable<Entity>)source, (ComparableGetter)valueGetter, ascending);
    }

    protected Iterable<Entity> sort(Iterable<Entity> source, Comparator<Entity> comparator, boolean ascending) {
        return this.sortInMemory(source, ascending ? comparator : new ReverseComparator(comparator));
    }

    protected Iterable<Entity> sortInMemory(Iterable<Entity> source, Comparator<Entity> comparator) {
        if (source instanceof InMemorySortIterable) {
            InMemorySortIterable merged = (InMemorySortIterable)source;
            return new InMemoryMergeSortIterable((Iterable<? extends Entity>)source, (Comparator<Entity>)new MergedComparator(merged.comparator, comparator));
        }
        return new InMemoryMergeSortIterable((Iterable<? extends Entity>)source, comparator);
    }

    protected Iterable<Entity> sortInMemory(Iterable<Entity> source, ComparableGetter valueGetter, boolean ascending) {
        if (source instanceof InMemorySortIterable) {
            InMemorySortIterable merged = (InMemorySortIterable)source;
            MergedComparator comparator = new MergedComparator(merged.comparator, ascending ? SortEngine.toComparator(valueGetter) : new ReverseComparator(SortEngine.toComparator(valueGetter)));
            return new InMemoryMergeSortIterable((Iterable<? extends Entity>)source, (Comparator<Entity>)comparator);
        }
        return new InMemoryMergeSortIterableWithValueGetter(source, valueGetter, SortEngine.caseInsensitiveComparator(ascending));
    }

    @NotNull
    private ComparableGetter propertyGetter(final String propertyName, final boolean readOnlyTxn) {
        return new ComparableGetter(){

            public Comparable select(Entity entity) {
                return SortEngine.this.getProperty(entity, propertyName, readOnlyTxn);
            }
        };
    }

    private Iterable<Entity> getAllEntities(String entityType, @Nullable ModelMetaData mmd) {
        EntityIterableBase it;
        this.queryEngine.assertOperational();
        EntityMetaData emd = mmd == null ? null : mmd.getEntityMetaData(entityType);
        Object object = it = emd != null && emd.isAbstract() ? EntityIterableBase.EMPTY : this.queryEngine.instantiateGetAll(entityType);
        if (emd != null) {
            for (String subType : emd.getSubTypes()) {
                if (Utils.getUnionSubtypes()) {
                    it = ((EntityIterable)this.getAllEntities(subType, mmd)).union((EntityIterable)it);
                    continue;
                }
                it = ((EntityIterable)this.getAllEntities(subType, mmd)).concat((EntityIterable)it);
            }
        }
        return this.queryEngine.wrap((EntityIterable)it);
    }

    private EntityIterableBase mergeSorted(EntityMetaData emd, IterableGetter sorted, final ComparableGetter valueGetter, Comparator<Comparable<Object>> comparator) {
        EntityIterableBase result;
        if (!emd.hasSubTypes()) {
            result = sorted.getIterable(emd.getType());
        } else {
            ArrayList<EntityIterableBase> iterables = new ArrayList<EntityIterableBase>(4);
            EntityIterableBase source = sorted.getIterable(emd.getType()).getSource();
            if (source != EntityIterableBase.EMPTY) {
                iterables.add(source);
            }
            for (String type : emd.getAllSubTypes()) {
                source = sorted.getIterable(type).getSource();
                if (source == EntityIterableBase.EMPTY) continue;
                iterables.add(source);
            }
            int iterablesCount = iterables.size();
            if (iterablesCount == 0) {
                result = EntityIterableBase.EMPTY;
            } else if (iterablesCount == 1) {
                result = (EntityIterableBase)iterables.get(0);
            } else {
                this.queryEngine.assertOperational();
                result = (EntityIterableBase)this.queryEngine.getPersistentStore().getAndCheckCurrentTransaction().mergeSorted(iterables, new ComparableGetter(){

                    public Comparable select(Entity entity) {
                        return valueGetter.select(SortEngine.this.attach(entity));
                    }
                }, comparator);
            }
        }
        return (EntityIterableBase)this.queryEngine.wrap(result.getSource().asSortResult());
    }

    public static int compareNullableComparables(Comparable c1, Comparable c2) {
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return 1;
        }
        if (c2 == null) {
            return -1;
        }
        return c1 instanceof String ? ((String)((Object)c1)).compareToIgnoreCase((String)((Object)c2)) : c1.compareTo(c2);
    }

    @NotNull
    private static Comparator<Comparable<Object>> caseInsensitiveComparator(boolean ascending) {
        return ascending ? PROPERTY_VALUE_COMPARATOR : REVERSE_PROPERTY_VALUE_COMPARATOR;
    }

    private static Comparator<Entity> toComparator(ComparableGetter selector) {
        return new EntityComparator(selector);
    }

    private class SingleLinkComparableGetter
    implements ComparableGetter {
        private final String linkName;
        private final String propName;
        private final boolean readOnlyTxn;
        private final PersistentEntityStoreImpl store;
        private final PersistentStoreTransaction txn;
        private final int linkId;

        public SingleLinkComparableGetter(String linkName, String propName, boolean readOnlyTxn, PersistentStoreTransaction txn) {
            this.linkName = linkName;
            this.propName = propName;
            this.readOnlyTxn = readOnlyTxn;
            this.store = SortEngine.this.queryEngine.getPersistentStore();
            this.txn = txn;
            this.linkId = this.store.getLinkId(txn, linkName, false);
        }

        public Comparable select(Entity entity) {
            EntityId sourceId;
            PersistentEntityId targetId;
            if (this.linkId < 0) {
                return null;
            }
            boolean isPersistentEntity = entity instanceof PersistentEntity;
            Object target = this.readOnlyTxn || isPersistentEntity ? ((targetId = this.store.getRawLinkAsEntityId(this.txn, new PersistentEntityId(sourceId = entity.getId()), this.linkId)) == null ? null : this.store.getEntity((EntityId)targetId)) : entity.getLink(this.linkName);
            return target == null ? null : SortEngine.this.getProperty(target, this.propName, this.readOnlyTxn);
        }
    }

    private class MultipleLinkComparableGetter
    implements ComparableGetter {
        private final String linkName;
        private final String propName;
        private final boolean ascending;
        private final boolean readOnlyTxn;

        public MultipleLinkComparableGetter(String linkName, String propName, boolean ascending, boolean readOnlyTxn) {
            this.linkName = linkName;
            this.propName = propName;
            this.ascending = ascending;
            this.readOnlyTxn = readOnlyTxn;
        }

        public Comparable select(Entity entity) {
            Iterable links = SortEngine.this.getLinks(entity, this.linkName, this.readOnlyTxn);
            Comparable result = null;
            for (Entity target : links) {
                Comparable property = SortEngine.this.getProperty(target, this.propName, this.readOnlyTxn);
                if (result == null) {
                    result = property;
                    continue;
                }
                int compared = SortEngine.compareNullableComparables(result, property);
                if ((!this.ascending || compared <= 0) && (this.ascending || compared >= 0)) continue;
                result = property;
            }
            return result;
        }
    }

    public static abstract class InMemorySortIterable
    implements Iterable<Entity> {
        @NotNull
        protected final Iterable<Entity> source;
        @NotNull
        protected final Comparator<Entity> comparator;

        protected InMemorySortIterable(@NotNull Iterable<Entity> source, @NotNull Comparator<Entity> comparator) {
            this.source = source;
            this.comparator = comparator;
        }
    }

    private static class MergedComparator
    implements Comparator<Entity> {
        @NotNull
        private final Comparator<Entity> first;
        @NotNull
        private final Comparator<Entity> second;

        private MergedComparator(@NotNull Comparator<Entity> first, @NotNull Comparator<Entity> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public int compare(@NotNull Entity o1, @NotNull Entity o2) {
            int i = this.second.compare(o1, o2);
            if (i == 0) {
                return this.first.compare(o1, o2);
            }
            return i;
        }
    }

    private static class ReverseComparator
    implements Comparator<Entity> {
        private final Comparator<Entity> source;

        private ReverseComparator(Comparator<Entity> source) {
            this.source = source;
        }

        @Override
        public int compare(@NotNull Entity o1, @NotNull Entity o2) {
            return this.source.compare(o2, o1);
        }
    }

    private static class EntityComparator
    implements Comparator<Entity> {
        private final ComparableGetter selector;

        private EntityComparator(ComparableGetter selector) {
            this.selector = selector;
        }

        @Override
        public int compare(@NotNull Entity o1, @NotNull Entity o2) {
            Comparable c1 = this.selector.select(o1);
            Comparable c2 = this.selector.select(o2);
            return SortEngine.compareNullableComparables(c1, c2);
        }
    }

    private static interface IterableGetter {
        public EntityIterableBase getIterable(String var1);
    }
}

