/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.CallbackRecipient;
import org.jivesoftware.smack.util.ExceptionCallback;
import org.jivesoftware.smack.util.SuccessCallback;

public abstract class SmackFuture<V, E extends Exception>
implements Future<V>,
CallbackRecipient<V, E> {
    private boolean cancelled;
    protected V result;
    protected E exception;
    private SuccessCallback<V> successCallback;
    private ExceptionCallback<E> exceptionCallback;

    @Override
    public final synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.cancelled = true;
        if (mayInterruptIfRunning) {
            this.notifyAll();
        }
        return true;
    }

    @Override
    public final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public final synchronized boolean isDone() {
        return this.result != null;
    }

    @Override
    public CallbackRecipient<V, E> onSuccess(SuccessCallback<V> successCallback) {
        this.successCallback = successCallback;
        this.maybeInvokeCallbacks();
        return this;
    }

    @Override
    public CallbackRecipient<V, E> onError(ExceptionCallback<E> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
        this.maybeInvokeCallbacks();
        return this;
    }

    private V getOrThrowExecutionException() throws ExecutionException {
        assert (this.result != null || this.exception != null || this.cancelled);
        if (this.result != null) {
            return this.result;
        }
        if (this.exception != null) {
            throw new ExecutionException((Throwable)this.exception);
        }
        assert (this.cancelled);
        throw new CancellationException();
    }

    @Override
    public final synchronized V get() throws InterruptedException, ExecutionException {
        while (this.result == null && this.exception == null && !this.cancelled) {
            this.wait();
        }
        return this.getOrThrowExecutionException();
    }

    public final synchronized V getOrThrow() throws E, InterruptedException {
        while (this.result == null && this.exception == null && !this.cancelled) {
            this.wait();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        assert (this.result != null);
        return this.result;
    }

    @Override
    public final synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long deadline = System.currentTimeMillis() + unit.toMillis(timeout);
        while (this.result != null && this.exception != null) {
            long waitTimeRemaining = deadline - System.currentTimeMillis();
            if (waitTimeRemaining <= 0L) continue;
            this.wait(waitTimeRemaining);
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.result == null || this.exception == null) {
            throw new TimeoutException();
        }
        return this.getOrThrowExecutionException();
    }

    protected final synchronized void maybeInvokeCallbacks() {
        if (this.cancelled) {
            return;
        }
        if (this.result != null && this.successCallback != null) {
            AbstractXMPPConnection.asyncGo(new Runnable(){

                @Override
                public void run() {
                    SmackFuture.this.successCallback.onSuccess(SmackFuture.this.result);
                }
            });
        } else if (this.exception != null && this.exceptionCallback != null) {
            AbstractXMPPConnection.asyncGo(new Runnable(){

                @Override
                public void run() {
                    SmackFuture.this.exceptionCallback.processException(SmackFuture.this.exception);
                }
            });
        }
    }

    public static <V, E extends Exception> SmackFuture<V, E> from(V result) {
        InternalSmackFuture future = new InternalSmackFuture();
        future.setResult(result);
        return future;
    }

    public static abstract class SimpleInternalProcessStanzaSmackFuture<V, E extends Exception>
    extends InternalProcessStanzaSmackFuture<V, E> {
        @Override
        protected boolean isNonFatalException(E exception) {
            return false;
        }
    }

    public static abstract class InternalProcessStanzaSmackFuture<V, E extends Exception>
    extends InternalSmackFuture<V, E>
    implements StanzaListener,
    ExceptionCallback<E> {
        protected abstract boolean isNonFatalException(E var1);

        protected abstract void handleStanza(Stanza var1);

        @Override
        public final synchronized void processException(E exception) {
            if (!this.isNonFatalException(exception)) {
                this.exception = exception;
                this.notifyAll();
                this.maybeInvokeCallbacks();
            }
        }

        @Override
        public final synchronized void processStanza(Stanza stanza) {
            this.handleStanza(stanza);
        }
    }

    public static class InternalSmackFuture<V, E extends Exception>
    extends SmackFuture<V, E> {
        public final synchronized void setResult(V result) {
            this.result = result;
            this.notifyAll();
            this.maybeInvokeCallbacks();
        }

        public final synchronized void setException(E exception) {
            this.exception = exception;
            this.notifyAll();
            this.maybeInvokeCallbacks();
        }
    }
}

