/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.saml;

import com.intellij.hub.auth.request.AuthRequestParameter;
import com.intellij.hub.core.Error;
import com.intellij.hub.core.ErrorImpl;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.APIVersion;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.ssl.KeyStore;
import jetbrains.jetpass.api.ssl.KeyStoreData;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.client.oauth2.auth.OAuth2CodeFlow;
import jetbrains.jetpass.core.store.OneTimeStore;
import jetbrains.jetpass.dao.dnq.api.APIInvocationContext;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUser;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.oauth2.server.AuthorizationCode;
import jetbrains.jetpass.oauth2.server.OAuthUtilKt;
import jetbrains.jetpass.rest.saml.AbsolutePathUtilKt;
import jetbrains.jetpass.rest.saml.SAML2Resource;
import jetbrains.jetpass.rest.saml.SAMLRequestReaderImpl;
import jetbrains.jetpass.rest.saml.html.CacheUtilKt;
import jetbrains.jetpass.rest.saml.html.SAMLHTMLResponse;
import jetbrains.jetpass.saml.HubSAMLException;
import jetbrains.jetpass.saml.SAMLAuthnRequest;
import jetbrains.jetpass.saml.SAMLAuthnResponse;
import jetbrains.jetpass.saml.SAMLLogoutRequest;
import jetbrains.jetpass.saml.SAMLLogoutResponse;
import jetbrains.jetpass.saml.SAMLPostRequestDecoder;
import jetbrains.jetpass.saml.SAMLPostResponseEncoder;
import jetbrains.jetpass.saml.SAMLRedirectRequestDecoder;
import jetbrains.jetpass.saml.SAMLResponseWriter;
import jetbrains.jetpass.saml.api.IdentityProviderMetadata;
import jetbrains.jetpass.saml.api.dao.IdentityProviderMetadataDAO;
import jetbrains.jetpass.saml.api.dao.ServiceProviderMetadataDAO;
import jetbrains.jetpass.saml.response.IDPMetadataBuilder;
import jetbrains.jetpass.saml.response.KeyStoreDataExt;
import jetbrains.jetpass.service.api.HubPrincipalManager;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdEmailContact;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUser;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensaml.xml.security.credential.Credential;

@Singleton
@Path(value="/saml2")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0007\u0018\u0000 M2\u00020\u0001:\u0001MB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0012\u00106\u001a\u0002072\b\b\u0001\u00104\u001a\u000205H\u0007J\u0016\u00108\u001a\u0002072\f\u00109\u001a\b\u0012\u0004\u0012\u0002070:H\u0002J6\u0010;\u001a\u0002072\n\b\u0001\u0010<\u001a\u0004\u0018\u00010)2\b\b\u0001\u0010=\u001a\u00020)2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010)2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010)H\u0007J*\u0010@\u001a\u0002072\b\b\u0001\u0010=\u001a\u00020)2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010)2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010)H\u0007J*\u0010A\u001a\u0002072\n\b\u0001\u0010B\u001a\u0004\u0018\u00010)2\n\b\u0001\u0010C\u001a\u0004\u0018\u00010)2\b\b\u0001\u00104\u001a\u000205H\u0007J\u0018\u0010D\u001a\u0002072\u0006\u0010<\u001a\u00020)2\u0006\u0010=\u001a\u00020)H\u0002J\u0010\u0010E\u001a\u0002072\u0006\u0010=\u001a\u00020)H\u0002J*\u0010F\u001a\u0002072\n\b\u0001\u0010B\u001a\u0004\u0018\u00010)2\n\b\u0001\u0010C\u001a\u0004\u0018\u00010)2\b\b\u0001\u00104\u001a\u000205H\u0007J*\u0010G\u001a\u0002072\n\b\u0001\u0010B\u001a\u0004\u0018\u00010)2\n\b\u0001\u0010H\u001a\u0004\u0018\u00010)2\b\b\u0001\u00104\u001a\u000205H\u0007J\u0018\u0010I\u001a\u0002072\u0006\u00104\u001a\u0002052\u0006\u0010J\u001a\u00020\u0005H\u0002J\u0018\u0010K\u001a\u0002072\u0006\u00104\u001a\u0002052\u0006\u0010J\u001a\u00020&H\u0002J\b\u0010L\u001a\u000207H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020 8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0007R\u0014\u0010(\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001e\u0010,\u001a\u00020-8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006N"}, d2={"Ljetbrains/jetpass/rest/saml/SAML2Resource;", "", "()V", "authnRequestStore", "Ljetbrains/jetpass/core/store/OneTimeStore;", "Ljetbrains/jetpass/saml/SAMLAuthnRequest;", "getAuthnRequestStore", "()Ljetbrains/jetpass/core/store/OneTimeStore;", "authorizationCodeStore", "Ljetbrains/jetpass/oauth2/server/AuthorizationCode;", "getAuthorizationCodeStore", "setAuthorizationCodeStore", "(Ljetbrains/jetpass/core/store/OneTimeStore;)V", "clientBuilder", "Ljetbrains/jetpass/client/hub/HubClient$HubClientBuilder;", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "daoContainer$delegate", "Lkotlin/properties/ReadOnlyProperty;", "hubPrincipalManager", "Ljetbrains/jetpass/service/api/HubPrincipalManager;", "getHubPrincipalManager", "()Ljetbrains/jetpass/service/api/HubPrincipalManager;", "setHubPrincipalManager", "(Ljetbrains/jetpass/service/api/HubPrincipalManager;)V", "identityProviderMetadata", "Ljetbrains/jetpass/saml/api/IdentityProviderMetadata;", "getIdentityProviderMetadata", "()Ljetbrains/jetpass/saml/api/IdentityProviderMetadata;", "idpDAO", "Ljetbrains/jetpass/saml/api/dao/IdentityProviderMetadataDAO;", "getIdpDAO", "()Ljetbrains/jetpass/saml/api/dao/IdentityProviderMetadataDAO;", "setIdpDAO", "(Ljetbrains/jetpass/saml/api/dao/IdentityProviderMetadataDAO;)V", "logoutRequestStore", "Ljetbrains/jetpass/saml/SAMLLogoutRequest;", "getLogoutRequestStore", "serviceID", "", "getServiceID", "()Ljava/lang/String;", "serviceProviderMetadataDAO", "Ljetbrains/jetpass/saml/api/dao/ServiceProviderMetadataDAO;", "getServiceProviderMetadataDAO", "()Ljetbrains/jetpass/saml/api/dao/ServiceProviderMetadataDAO;", "setServiceProviderMetadataDAO", "(Ljetbrains/jetpass/saml/api/dao/ServiceProviderMetadataDAO;)V", "getClient", "Ljetbrains/jetpass/client/hub/HubClient;", "uriInfo", "Ljavax/ws/rs/core/UriInfo;", "getMetadata", "Ljavax/ws/rs/core/Response;", "handleErrors", "fn", "Lkotlin/Function0;", "oauth", "code", "state", "error", "description", "oauthLogout", "postBinding", "samlRequest", "relayState", "processAuthnCodeResponse", "processLogoutCodeResponse", "redirectBinding", "redirectLogoutBinding", "returnTo", "redirectToLogin", "req", "redirectToLogout", "redirectToServiceHome", "Companion", "jetbrains.jetpass.saml.rest"})
public final class SAML2Resource {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Inject
    @NotNull
    public IdentityProviderMetadataDAO idpDAO;
    @Inject
    @NotNull
    public ServiceProviderMetadataDAO serviceProviderMetadataDAO;
    @Inject
    @NotNull
    public HubPrincipalManager hubPrincipalManager;
    @Named(value="authorizationCodeStore")
    @Inject
    @NotNull
    public OneTimeStore<AuthorizationCode> authorizationCodeStore;
    private final HubClient.HubClientBuilder clientBuilder = HubClient.Companion.builder$default((HubClient.Companion)HubClient.Companion, null, (int)1, null);
    @NotNull
    private final OneTimeStore<SAMLAuthnRequest> authnRequestStore = new OneTimeStore();
    @NotNull
    private final OneTimeStore<SAMLLogoutRequest> logoutRequestStore = new OneTimeStore();
    @NotNull
    private final ReadOnlyProperty daoContainer$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SAML2Resource.class), "daoContainer", "getDaoContainer()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final IdentityProviderMetadataDAO getIdpDAO() {
        IdentityProviderMetadataDAO identityProviderMetadataDAO = this.idpDAO;
        if (identityProviderMetadataDAO == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idpDAO");
        }
        return identityProviderMetadataDAO;
    }

    public final void setIdpDAO(@NotNull IdentityProviderMetadataDAO identityProviderMetadataDAO) {
        Intrinsics.checkParameterIsNotNull((Object)identityProviderMetadataDAO, (String)"<set-?>");
        this.idpDAO = identityProviderMetadataDAO;
    }

    @NotNull
    public final ServiceProviderMetadataDAO getServiceProviderMetadataDAO() {
        ServiceProviderMetadataDAO serviceProviderMetadataDAO = this.serviceProviderMetadataDAO;
        if (serviceProviderMetadataDAO == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serviceProviderMetadataDAO");
        }
        return serviceProviderMetadataDAO;
    }

    public final void setServiceProviderMetadataDAO(@NotNull ServiceProviderMetadataDAO serviceProviderMetadataDAO) {
        Intrinsics.checkParameterIsNotNull((Object)serviceProviderMetadataDAO, (String)"<set-?>");
        this.serviceProviderMetadataDAO = serviceProviderMetadataDAO;
    }

    @NotNull
    public final HubPrincipalManager getHubPrincipalManager() {
        HubPrincipalManager hubPrincipalManager = this.hubPrincipalManager;
        if (hubPrincipalManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hubPrincipalManager");
        }
        return hubPrincipalManager;
    }

    public final void setHubPrincipalManager(@NotNull HubPrincipalManager hubPrincipalManager) {
        Intrinsics.checkParameterIsNotNull((Object)hubPrincipalManager, (String)"<set-?>");
        this.hubPrincipalManager = hubPrincipalManager;
    }

    @NotNull
    public final OneTimeStore<AuthorizationCode> getAuthorizationCodeStore() {
        OneTimeStore<AuthorizationCode> oneTimeStore = this.authorizationCodeStore;
        if (oneTimeStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"authorizationCodeStore");
        }
        return oneTimeStore;
    }

    public final void setAuthorizationCodeStore(@NotNull OneTimeStore<AuthorizationCode> oneTimeStore) {
        Intrinsics.checkParameterIsNotNull(oneTimeStore, (String)"<set-?>");
        this.authorizationCodeStore = oneTimeStore;
    }

    private final IdentityProviderMetadata getIdentityProviderMetadata() {
        IdentityProviderMetadataDAO identityProviderMetadataDAO = this.idpDAO;
        if (identityProviderMetadataDAO == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idpDAO");
        }
        IdItem idItem = identityProviderMetadataDAO.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)idItem, (String)"idpDAO.get()");
        return (IdentityProviderMetadata)idItem;
    }

    private final String getServiceID() {
        HubPrincipalManager hubPrincipalManager = this.hubPrincipalManager;
        if (hubPrincipalManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hubPrincipalManager");
        }
        String string = (String)hubPrincipalManager.runAsRoot((Function0)new Function0<String>(this){
            final /* synthetic */ SAML2Resource this$0;

            @Nullable
            public final String invoke() {
                Service service = SAML2Resource.access$getIdentityProviderMetadata$p(this.this$0).getService();
                return service != null ? service.getId() : null;
            }
            {
                this.this$0 = sAML2Resource;
                super(0);
            }
        });
        if (string == null) {
            throw (Throwable)new IllegalStateException("ID of the service associated with SAML 2.0 identity provider is null");
        }
        return string;
    }

    @NotNull
    public final OneTimeStore<SAMLAuthnRequest> getAuthnRequestStore() {
        return this.authnRequestStore;
    }

    @NotNull
    public final OneTimeStore<SAMLLogoutRequest> getLogoutRequestStore() {
        return this.logoutRequestStore;
    }

    @NotNull
    public final JetPassDAOContainer getDaoContainer() {
        return (JetPassDAOContainer)this.daoContainer$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @GET
    @Produces(value={"text/html"})
    @NotNull
    public final Response redirectBinding(@QueryParam(value="SAMLRequest") @Nullable String samlRequest, @QueryParam(value="RelayState") @Nullable String relayState, @Context @NotNull UriInfo uriInfo) {
        Intrinsics.checkParameterIsNotNull((Object)uriInfo, (String)"uriInfo");
        Companion.getLogger().debug((Function0)new Function0<String>(samlRequest, relayState){
            final /* synthetic */ String $samlRequest;
            final /* synthetic */ String $relayState;

            @NotNull
            public final String invoke() {
                return "Received authn request. urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect: request=" + this.$samlRequest + "; relayState=" + this.$relayState;
            }
            {
                this.$samlRequest = string;
                this.$relayState = string2;
                super(0);
            }
        });
        return this.handleErrors((Function0<? extends Response>)((Function0)new Function0<Response>(this, samlRequest, relayState, uriInfo){
            final /* synthetic */ SAML2Resource this$0;
            final /* synthetic */ String $samlRequest;
            final /* synthetic */ String $relayState;
            final /* synthetic */ UriInfo $uriInfo;

            @NotNull
            public final Response invoke() {
                if (this.$samlRequest == null) {
                    throw (Throwable)HubSAMLException.Companion.missingSAMLRequestParameter();
                }
                SAMLRequestReaderImpl samlExchange = new SAMLRequestReaderImpl(SAML2Resource.access$getIdentityProviderMetadata$p(this.this$0), this.this$0.getServiceProviderMetadataDAO(), this.this$0.getHubPrincipalManager());
                SAMLRedirectRequestDecoder decoder = new SAMLRedirectRequestDecoder(this.$samlRequest);
                SAMLAuthnRequest req = samlExchange.readAuthnRequest(decoder.decode(), this.$relayState);
                return SAML2Resource.access$redirectToLogin(this.this$0, this.$uriInfo, req);
            }
            {
                this.this$0 = sAML2Resource;
                this.$samlRequest = string;
                this.$relayState = string2;
                this.$uriInfo = uriInfo;
                super(0);
            }
        }));
    }

    @POST
    @Produces(value={"text/html"})
    @NotNull
    public final Response postBinding(@FormParam(value="SAMLRequest") @Nullable String samlRequest, @FormParam(value="RelayState") @Nullable String relayState, @Context @NotNull UriInfo uriInfo) {
        Intrinsics.checkParameterIsNotNull((Object)uriInfo, (String)"uriInfo");
        Companion.getLogger().debug((Function0)new Function0<String>(samlRequest, relayState){
            final /* synthetic */ String $samlRequest;
            final /* synthetic */ String $relayState;

            @NotNull
            public final String invoke() {
                return "Received authn request. urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST: request=" + this.$samlRequest + "; relayState=" + this.$relayState;
            }
            {
                this.$samlRequest = string;
                this.$relayState = string2;
                super(0);
            }
        });
        return this.handleErrors((Function0<? extends Response>)((Function0)new Function0<Response>(this, samlRequest, relayState, uriInfo){
            final /* synthetic */ SAML2Resource this$0;
            final /* synthetic */ String $samlRequest;
            final /* synthetic */ String $relayState;
            final /* synthetic */ UriInfo $uriInfo;

            @NotNull
            public final Response invoke() {
                if (this.$samlRequest == null) {
                    throw (Throwable)HubSAMLException.Companion.missingSAMLRequestParameter();
                }
                SAMLRequestReaderImpl samlExchange = new SAMLRequestReaderImpl(SAML2Resource.access$getIdentityProviderMetadata$p(this.this$0), this.this$0.getServiceProviderMetadataDAO(), this.this$0.getHubPrincipalManager());
                SAMLPostRequestDecoder decoder = new SAMLPostRequestDecoder(this.$samlRequest);
                SAMLAuthnRequest request = samlExchange.readAuthnRequest(decoder.decode(), this.$relayState);
                return SAML2Resource.access$redirectToLogin(this.this$0, this.$uriInfo, request);
            }
            {
                this.this$0 = sAML2Resource;
                this.$samlRequest = string;
                this.$relayState = string2;
                this.$uriInfo = uriInfo;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/metadata")
    @Produces(value={"application/xml"})
    @NotNull
    public final Response getMetadata(@Context @NotNull UriInfo uriInfo) {
        void method$iv;
        void $receiver$iv;
        IDPMetadataBuilder iDPMetadataBuilder;
        Intrinsics.checkParameterIsNotNull((Object)uriInfo, (String)"uriInfo");
        IdentityProviderMetadata identityProviderMetadata = this.getIdentityProviderMetadata();
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"uriInfo.baseUriBuilder");
        URI uRI = AbsolutePathUtilKt.path(uriBuilder, Reflection.getOrCreateKotlinClass(SAML2Resource.class)).build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"uriInfo.baseUriBuilder.p\u20262Resource::class).build()");
        UriBuilder uriBuilder2 = uriInfo.getBaseUriBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder2, (String)"uriInfo.baseUriBuilder");
        URI uRI2 = AbsolutePathUtilKt.path(uriBuilder2, Reflection.getOrCreateKotlinClass(SAML2Resource.class)).build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"uriInfo.baseUriBuilder.p\u20262Resource::class).build()");
        UriBuilder uriBuilder3 = uriInfo.getBaseUriBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder3, (String)"uriInfo.baseUriBuilder");
        UriBuilder uriBuilder4 = uriBuilder3;
        getMetadata.1 var3_3 = getMetadata.1.INSTANCE;
        URI uRI3 = uRI2;
        URI uRI4 = uRI;
        IdentityProviderMetadata identityProviderMetadata2 = identityProviderMetadata;
        IDPMetadataBuilder iDPMetadataBuilder2 = iDPMetadataBuilder;
        IDPMetadataBuilder iDPMetadataBuilder3 = iDPMetadataBuilder;
        UriBuilder uriBuilder5 = $receiver$iv.path(SAML2Resource.class).path(SAML2Resource.class, method$iv.getName());
        URI uRI5 = uriBuilder5.build(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI5, (String)"uriInfo.baseUriBuilder.p\u2026ectLogoutBinding).build()");
        iDPMetadataBuilder2(identityProviderMetadata2, uRI4, uRI3, uRI5);
        Response response = Response.ok((Object)iDPMetadataBuilder3.build(), (MediaType)MediaType.APPLICATION_XML_TYPE).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok(IDPMetadataB\u2026ICATION_XML_TYPE).build()");
        return response;
    }

    @GET
    @Path(value="/logout")
    @Produces(value={"text/html"})
    @NotNull
    public final Response redirectLogoutBinding(@QueryParam(value="SAMLRequest") @Nullable String samlRequest, @QueryParam(value="return_to") @Nullable String returnTo, @Context @NotNull UriInfo uriInfo) {
        Intrinsics.checkParameterIsNotNull((Object)uriInfo, (String)"uriInfo");
        Companion.getLogger().debug((Function0)new Function0<String>(samlRequest){
            final /* synthetic */ String $samlRequest;

            @NotNull
            public final String invoke() {
                return "Received logout request. urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect: request=" + this.$samlRequest;
            }
            {
                this.$samlRequest = string;
                super(0);
            }
        });
        return this.handleErrors((Function0<? extends Response>)((Function0)new Function0<Response>(this, samlRequest, returnTo, uriInfo){
            final /* synthetic */ SAML2Resource this$0;
            final /* synthetic */ String $samlRequest;
            final /* synthetic */ String $returnTo;
            final /* synthetic */ UriInfo $uriInfo;

            @NotNull
            public final Response invoke() {
                String string;
                block3: {
                    block2: {
                        SAMLLogoutRequest request;
                        String string2;
                        string = this.$samlRequest;
                        if (string == null) break block2;
                        String it = string2 = string;
                        SAMLRequestReaderImpl samlExchange = new SAMLRequestReaderImpl(SAML2Resource.access$getIdentityProviderMetadata$p(this.this$0), this.this$0.getServiceProviderMetadataDAO(), this.this$0.getHubPrincipalManager());
                        SAMLRedirectRequestDecoder decoder = new SAMLRedirectRequestDecoder(this.$samlRequest);
                        SAMLLogoutRequest sAMLLogoutRequest = request = samlExchange.readLogoutRequest(decoder.decode(), this.$returnTo);
                        string = sAMLLogoutRequest;
                        if (sAMLLogoutRequest != null) break block3;
                    }
                    string = SAMLLogoutRequest.Companion.getUNIDENTIFIED();
                }
                String request = string;
                return request.getNameId() != null ? SAML2Resource.access$redirectToLogout(this.this$0, this.$uriInfo, (SAMLLogoutRequest)request) : SAML2Resource.access$redirectToServiceHome(this.this$0);
            }
            {
                this.this$0 = sAML2Resource;
                this.$samlRequest = string;
                this.$returnTo = string2;
                this.$uriInfo = uriInfo;
                super(0);
            }
        }));
    }

    private final Response redirectToServiceHome() {
        String homeURL2 = (String)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)redirectToServiceHome.homeURL.1.INSTANCE, (int)7, null);
        Response response = Response.seeOther((URI)URI.create(homeURL2)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(URI.create(homeURL)).build()");
        return response;
    }

    @GET
    @Path(value="/oauth")
    @Produces(value={"text/html"})
    @NotNull
    public final Response oauth(@QueryParam(value="code") @Nullable String code, @QueryParam(value="state") @NotNull String state, @QueryParam(value="error") @Nullable String error, @QueryParam(value="error_description") @Nullable String description) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return this.handleErrors((Function0<? extends Response>)((Function0)new Function0<Response>(this, code, state, error, description){
            final /* synthetic */ SAML2Resource this$0;
            final /* synthetic */ String $code;
            final /* synthetic */ String $state;
            final /* synthetic */ String $error;
            final /* synthetic */ String $description;

            @NotNull
            public final Response invoke() {
                if (this.$code == null) {
                    throw (Throwable)HubSAMLException.Companion.oauthError(this.$error, this.$description);
                }
                SAML2Resource.Companion.getLogger().debug((Function0)new Function0<String>(this){
                    final /* synthetic */ oauth.1 this$0;

                    @NotNull
                    public final String invoke() {
                        return "Received code: " + this.this$0.$code + " and state: " + this.this$0.$state;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
                return SAML2Resource.access$processAuthnCodeResponse(this.this$0, this.$code, this.$state);
            }
            {
                this.this$0 = sAML2Resource;
                this.$code = string;
                this.$state = string2;
                this.$error = string3;
                this.$description = string4;
                super(0);
            }
        }));
    }

    @GET
    @Path(value="/logout/oauth")
    @Produces(value={"text/html"})
    @NotNull
    public final Response oauthLogout(@QueryParam(value="state") @NotNull String state, @QueryParam(value="error") @Nullable String error, @QueryParam(value="error_description") @Nullable String description) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return this.handleErrors((Function0<? extends Response>)((Function0)new Function0<Response>(this, error, state, description){
            final /* synthetic */ SAML2Resource this$0;
            final /* synthetic */ String $error;
            final /* synthetic */ String $state;
            final /* synthetic */ String $description;

            @NotNull
            public final Response invoke() {
                if (this.$error != null) {
                    throw (Throwable)HubSAMLException.Companion.oauthError(this.$error, this.$description);
                }
                return SAML2Resource.access$processLogoutCodeResponse(this.this$0, this.$state);
            }
            {
                this.this$0 = sAML2Resource;
                this.$error = string;
                this.$state = string2;
                this.$description = string3;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final Response redirectToLogin(UriInfo uriInfo, SAMLAuthnRequest req) {
        void method$iv;
        void $receiver$iv;
        String state = this.authnRequestStore.put((Object)req);
        String serviceID2 = this.getServiceID();
        OAuth2CodeFlow.Builder builder = (OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)this.getClient(uriInfo).getOAuthClient().codeFlow().clientId(serviceID2)).credentials(AuthRequestParameter.RequestCredentials.DEFAULT);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"uriInfo.baseUriBuilder");
        UriBuilder uriBuilder2 = uriBuilder;
        redirectToLogin.codeFlow.1 var7_6 = redirectToLogin.codeFlow.1.INSTANCE;
        OAuth2CodeFlow.Builder builder2 = builder;
        UriBuilder uriBuilder3 = $receiver$iv.path(SAML2Resource.class).path(SAML2Resource.class, method$iv.getName());
        OAuth2CodeFlow codeFlow2 = ((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)builder2.redirectUri(uriBuilder3.build(new Object[0]))).scope(new String[]{serviceID2})).state(state)).build();
        Response.ResponseBuilder responseBuilder = Response.seeOther((URI)codeFlow2.getAuthUri());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"Response.seeOther(codeFlow.authUri)");
        Response response = CacheUtilKt.noCache(responseBuilder).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(codeFl\u2026uthUri).noCache().build()");
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private final Response redirectToLogout(UriInfo uriInfo, SAMLLogoutRequest req) {
        void method$iv;
        void $receiver$iv;
        String state = this.logoutRequestStore.put((Object)req);
        String serviceID2 = this.getServiceID();
        OAuth2CodeFlow.Builder builder = (OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)this.getClient(uriInfo).getOAuthClient().codeFlow().clientId(serviceID2)).credentials(AuthRequestParameter.RequestCredentials.SILENT_LOGOUT);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        Intrinsics.checkExpressionValueIsNotNull((Object)uriBuilder, (String)"uriInfo.baseUriBuilder");
        UriBuilder uriBuilder2 = uriBuilder;
        redirectToLogout.codeFlow.1 var7_6 = redirectToLogout.codeFlow.1.INSTANCE;
        OAuth2CodeFlow.Builder builder2 = builder;
        UriBuilder uriBuilder3 = $receiver$iv.path(SAML2Resource.class).path(SAML2Resource.class, method$iv.getName());
        OAuth2CodeFlow codeFlow2 = ((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)((OAuth2CodeFlow.Builder)builder2.redirectUri(uriBuilder3.build(new Object[0]))).scope(new String[]{serviceID2})).state(state)).build();
        Response.ResponseBuilder responseBuilder = Response.seeOther((URI)codeFlow2.getAuthUri());
        Intrinsics.checkExpressionValueIsNotNull((Object)responseBuilder, (String)"Response.seeOther(codeFlow.authUri)");
        Response response = CacheUtilKt.noCache(responseBuilder).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(codeFl\u2026uthUri).noCache().build()");
        return response;
    }

    private final Response handleErrors(Function0<? extends Response> fn) {
        Response response;
        try {
            response = (Response)fn.invoke();
        }
        catch (Exception e) {
            Error error;
            Exception exception = e;
            if (exception instanceof HubSAMLException) {
                error = ((HubSAMLException)e).toError();
            } else {
                String string = e.getClass().getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.javaClass.name");
                int n = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
                String string2 = e.getMessage();
                if (string2 == null) {
                    String string3 = e.getClass().getName();
                    string2 = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"e.javaClass.name");
                }
                error = (Error)new ErrorImpl(string, n, string2, null, null, null, 56, null);
            }
            Error error2 = error;
            Response response2 = Response.seeOther((URI)OAuthUtilKt.getRedirectURL((Error)error2, (String)this.getServiceID())).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"Response.seeOther(error.\u2026ctURL(serviceID)).build()");
            return response2;
        }
        return response;
    }

    private final Response processAuthnCodeResponse(String code, String state) {
        String string;
        String responseIssuer;
        SAMLAuthnRequest sAMLAuthnRequest = (SAMLAuthnRequest)this.authnRequestStore.get(state);
        if (sAMLAuthnRequest == null) {
            throw (Throwable)HubSAMLException.Companion.stateMismatch();
        }
        SAMLAuthnRequest samlRequest = sAMLAuthnRequest;
        Companion.getLogger().debug((Function0)new Function0<String>(state, samlRequest){
            final /* synthetic */ String $state;
            final /* synthetic */ SAMLAuthnRequest $samlRequest;

            @NotNull
            public final String invoke() {
                return "State holder found for state: " + this.$state + ", SAML authn request: " + this.$samlRequest;
            }
            {
                this.$state = string;
                this.$samlRequest = sAMLAuthnRequest;
                super(0);
            }
        });
        OneTimeStore<AuthorizationCode> oneTimeStore = this.authorizationCodeStore;
        if (oneTimeStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"authorizationCodeStore");
        }
        AuthorizationCode authorizationCode = (AuthorizationCode)oneTimeStore.get(code);
        if (authorizationCode == null) {
            throw (Throwable)HubSAMLException.Companion.unresolvedOAuthCode();
        }
        AuthorizationCode authCode = authorizationCode;
        String email2 = (String)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, String>(authCode){
            final /* synthetic */ AuthorizationCode $authCode;

            @NotNull
            public final String invoke(@NotNull TransientStoreSession it) {
                XdUser xdUser;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdBaseUser xdBaseUser = this.$authCode.getUser();
                if (!(xdBaseUser instanceof XdUser)) {
                    xdBaseUser = null;
                }
                XdEmailContact emailContact = (xdUser = (XdUser)xdBaseUser) != null && (xdUser = xdUser.getProfile()) != null ? xdUser.getEmail() : null;
                String login = this.$authCode.getUser().getLogin();
                Object object = emailContact;
                if (object == null || (object = object.getEmail()) == null) {
                    throw (Throwable)HubSAMLException.Companion.emailRequired(login);
                }
                Object email2 = object;
                boolean verified = emailContact.getVerified();
                if (!verified) {
                    throw (Throwable)HubSAMLException.Companion.emailUnverified(login);
                }
                return email2;
            }
            {
                this.$authCode = authorizationCode;
                super(1);
            }
        }), (int)7, null);
        Map attributes2 = (Map)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Map<String, ? extends List<? extends String>>>(this, authCode, samlRequest, email2){
            final /* synthetic */ SAML2Resource this$0;
            final /* synthetic */ AuthorizationCode $authCode;
            final /* synthetic */ SAMLAuthnRequest $samlRequest;
            final /* synthetic */ String $email;

            @NotNull
            public final Map<String, List<String>> invoke(@NotNull TransientStoreSession $noName_0) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                JetPassUser user = this.this$0.getDaoContainer().getJetPassUserDAO().wrapEntity(this.$authCode.getUser());
                return MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequenceOf((Object[])new Pair[]{TuplesKt.to((Object)this.$samlRequest.getLoginAttributeName(), (Object)CollectionsKt.listOf((Object)this.$authCode.getUser().getLogin())), TuplesKt.to((Object)this.$samlRequest.getFullNameAttributeName(), (Object)CollectionsKt.listOf((Object)this.$authCode.getUser().getVisibleName())), TuplesKt.to((Object)this.$samlRequest.getEmailAttributeName(), (Object)CollectionsKt.listOf((Object)this.$email)), TuplesKt.to((Object)this.$samlRequest.getGroupsAttributeName(), (Object)this.this$0.getHubPrincipalManager().runAs((AuthorityHolder)user, (Function0)new Function0<List<? extends String>>(user){
                    final /* synthetic */ JetPassUser $user;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @NotNull
                    public final List<String> invoke() {
                        List list;
                        APIVersion version$iv = APIVersion.Companion.getLATEST();
                        APIVersion savedAPIVersion$iv = APIInvocationContext.INSTANCE.getApiVersion();
                        APIInvocationContext.INSTANCE.setApiVersion(version$iv);
                        try {
                            list = CollectionsKt.toList((Iterable)((Iterable)this.$user.getTransitiveGroups().map((Function1)processAuthnCodeResponse.attributes.1.1.INSTANCE)));
                        }
                        finally {
                            APIInvocationContext.INSTANCE.setApiVersion(savedAPIVersion$iv);
                        }
                        return list;
                    }
                    {
                        this.$user = jetPassUser;
                        super(0);
                    }
                }))}), (Function1)processAuthnCodeResponse.attributes.2.INSTANCE));
            }
            {
                this.this$0 = sAML2Resource;
                this.$authCode = authorizationCode;
                this.$samlRequest = sAMLAuthnRequest;
                this.$email = string;
                super(1);
            }
        }), (int)7, null);
        String string2 = this.getIdentityProviderMetadata().getEntityId();
        if (string2 == null) {
            throw (Throwable)new NullPointerException("Entity ID of SAML identity provider is empty");
        }
        String string3 = responseIssuer = string2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"responseIssuer");
        SAMLAuthnResponse samlResponse = new SAMLAuthnResponse(email2, string3, null, attributes2, 4, null);
        HubPrincipalManager hubPrincipalManager = this.hubPrincipalManager;
        if (hubPrincipalManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hubPrincipalManager");
        }
        Credential credential2 = (Credential)hubPrincipalManager.runAsRoot((Function0)new Function0<Credential>(this){
            final /* synthetic */ SAML2Resource this$0;

            @Nullable
            public final Credential invoke() {
                Credential credential2;
                KeyStore keyStore = SAML2Resource.access$getIdentityProviderMetadata$p(this.this$0).getKeyStore();
                if (keyStore != null && (keyStore = keyStore.getData()) != null) {
                    KeyStore keyStore2;
                    KeyStore keyStoreData;
                    KeyStore keyStore3 = keyStoreData = (keyStore2 = keyStore);
                    Intrinsics.checkExpressionValueIsNotNull((Object)keyStore3, (String)"keyStoreData");
                    credential2 = new KeyStoreDataExt((KeyStoreData)keyStore3).getCredential();
                } else {
                    credential2 = null;
                }
                return credential2;
            }
            {
                this.this$0 = sAML2Resource;
                super(0);
            }
        });
        try {
            SAMLResponseWriter samlResponseWriter = new SAMLResponseWriter();
            String stringResponse = samlResponseWriter.writeAuthnResponse(samlRequest, samlResponse, credential2);
            SAMLPostResponseEncoder encoder = new SAMLPostResponseEncoder(stringResponse);
            string = encoder.encode();
        }
        catch (Exception e) {
            throw (Throwable)HubSAMLException.Companion.cantBuildResponse(e);
        }
        String encodedResponse = string;
        return new SAMLHTMLResponse().build(samlRequest.getAcsUrl(), encodedResponse, samlRequest.getRelayState());
    }

    private final Response processLogoutCodeResponse(String state) {
        Response response;
        SAMLLogoutRequest sAMLLogoutRequest = (SAMLLogoutRequest)this.logoutRequestStore.get(state);
        if (sAMLLogoutRequest == null) {
            throw (Throwable)HubSAMLException.Companion.stateMismatch();
        }
        SAMLLogoutRequest samlRequest = sAMLLogoutRequest;
        Companion.getLogger().debug((Function0)new Function0<String>(state, samlRequest){
            final /* synthetic */ String $state;
            final /* synthetic */ SAMLLogoutRequest $samlRequest;

            @NotNull
            public final String invoke() {
                return "State holder found for state: " + this.$state + ", SAML logout request: " + this.$samlRequest;
            }
            {
                this.$state = string;
                this.$samlRequest = sAMLLogoutRequest;
                super(0);
            }
        });
        String string = this.getIdentityProviderMetadata().getEntityId();
        if (string == null) {
            throw (Throwable)new NullPointerException("Entity ID of SAML identity provider is empty");
        }
        String responseIssuer = string;
        if (samlRequest.getAcceptsLogoutResponse()) {
            String string2;
            String string3 = responseIssuer;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"responseIssuer");
            SAMLLogoutResponse samlResponse = new SAMLLogoutResponse(string3);
            HubPrincipalManager hubPrincipalManager = this.hubPrincipalManager;
            if (hubPrincipalManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hubPrincipalManager");
            }
            Credential credential2 = (Credential)hubPrincipalManager.runAsRoot((Function0)new Function0<Credential>(this){
                final /* synthetic */ SAML2Resource this$0;

                @Nullable
                public final Credential invoke() {
                    Credential credential2;
                    KeyStore keyStore = SAML2Resource.access$getIdentityProviderMetadata$p(this.this$0).getKeyStore();
                    if (keyStore != null && (keyStore = keyStore.getData()) != null) {
                        KeyStore keyStore2;
                        KeyStore keyStoreData;
                        KeyStore keyStore3 = keyStoreData = (keyStore2 = keyStore);
                        Intrinsics.checkExpressionValueIsNotNull((Object)keyStore3, (String)"keyStoreData");
                        credential2 = new KeyStoreDataExt((KeyStoreData)keyStore3).getCredential();
                    } else {
                        credential2 = null;
                    }
                    return credential2;
                }
                {
                    this.this$0 = sAML2Resource;
                    super(0);
                }
            });
            try {
                SAMLResponseWriter samlResponseWriter = new SAMLResponseWriter();
                String stringResponse = samlResponseWriter.writeLogoutResponse(samlRequest, samlResponse, credential2);
                SAMLPostResponseEncoder encoder = new SAMLPostResponseEncoder(stringResponse);
                string2 = encoder.encode();
            }
            catch (Exception e) {
                throw (Throwable)HubSAMLException.Companion.cantBuildResponse(e);
            }
            String response2 = string2;
            response = SAMLHTMLResponse.build$default(new SAMLHTMLResponse(), samlRequest.getAcsUrl(), response2, null, 4, null);
        } else {
            CharSequence charSequence = samlRequest.getReturnTo();
            Response response3 = charSequence == null || charSequence.length() == 0 ? this.redirectToServiceHome() : Response.seeOther((URI)URI.create(samlRequest.getReturnTo())).build();
            response = response3;
            Intrinsics.checkExpressionValueIsNotNull((Object)response3, (String)"if (samlRequest.returnTo\u2026o)).build()\n            }");
        }
        return response;
    }

    private final HubClient getClient(UriInfo uriInfo) {
        String string = uriInfo.getBaseUri().toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uriInfo.baseUri.toASCIIString()");
        return this.clientBuilder.build(StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string, (CharSequence)"/api/rest"), (CharSequence)"api/rest/"));
    }

    public SAML2Resource() {
        ReadOnlyProperty readOnlyProperty;
        SAML2Resource sAML2Resource = this;
        String name$iv = null;
        sAML2Resource.daoContainer$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public static final /* synthetic */ IdentityProviderMetadata access$getIdentityProviderMetadata$p(SAML2Resource $this) {
        return $this.getIdentityProviderMetadata();
    }

    @NotNull
    public static final /* synthetic */ Response access$redirectToLogin(SAML2Resource $this, @NotNull UriInfo uriInfo, @NotNull SAMLAuthnRequest req) {
        return $this.redirectToLogin(uriInfo, req);
    }

    @NotNull
    public static final /* synthetic */ Response access$redirectToLogout(SAML2Resource $this, @NotNull UriInfo uriInfo, @NotNull SAMLLogoutRequest req) {
        return $this.redirectToLogout(uriInfo, req);
    }

    @NotNull
    public static final /* synthetic */ Response access$redirectToServiceHome(SAML2Resource $this) {
        return $this.redirectToServiceHome();
    }

    @NotNull
    public static final /* synthetic */ Response access$processAuthnCodeResponse(SAML2Resource $this, @NotNull String code, @NotNull String state) {
        return $this.processAuthnCodeResponse(code, state);
    }

    @NotNull
    public static final /* synthetic */ Response access$processLogoutCodeResponse(SAML2Resource $this, @NotNull String state) {
        return $this.processLogoutCodeResponse(state);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/rest/saml/SAML2Resource$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.saml.rest"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

