/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.airlift.compress.lzo.LzoCompressor;
import io.airlift.compress.lzo.LzoDecompressor;
import io.airlift.compress.snappy.SnappyCompressor;
import io.airlift.compress.snappy.SnappyDecompressor;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.vfs.ClusterConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AirCompressor
implements ClusterConverter {
    @NotNull
    private final Decompressor decompressor;
    @NotNull
    private final Compressor compressor;
    private final int maxClusterSize;

    private AirCompressor(@NotNull String codec, int maxClusterSize) {
        if (codec.equalsIgnoreCase("snappy")) {
            this.decompressor = new SnappyDecompressor();
            this.compressor = new SnappyCompressor();
        } else if (codec.equalsIgnoreCase("lz4")) {
            this.decompressor = new Lz4Decompressor();
            this.compressor = new Lz4Compressor();
        } else if (codec.equalsIgnoreCase("lzo")) {
            this.decompressor = new LzoDecompressor();
            this.compressor = new LzoCompressor();
        } else {
            throw new IllegalArgumentException("Unknown codec: " + codec);
        }
        this.maxClusterSize = maxClusterSize + 8;
    }

    @NotNull
    public ByteIterable onRead(@NotNull ByteIterable raw) {
        byte[] result = new byte[this.maxClusterSize];
        int decompressedLength = this.decompressor.decompress(raw.getBytesUnsafe(), 0, raw.getLength(), result, 0, this.maxClusterSize);
        return new ArrayByteIterable(result, decompressedLength);
    }

    @NotNull
    public ByteIterable onWrite(@NotNull ByteIterable source) {
        int sourceLength = source.getLength();
        int compressedLength = sourceLength + sourceLength / 5 + 50;
        byte[] compressed = new byte[compressedLength];
        compressedLength = this.compressor.compress(source.getBytesUnsafe(), 0, sourceLength, compressed, 0, compressedLength);
        return new ArrayByteIterable(compressed, compressedLength);
    }

    @Nullable
    static AirCompressor getInstance(@NotNull String codec, int maxClusterSize) {
        try {
            return new AirCompressor(codec, maxClusterSize);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

