/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import java.util.Map;
import java.util.TreeMap;
import jetbrains.youtrack.textindex.api.FieldTextExtractor;
import jetbrains.youtrack.textindex.api.TextIndexEntityMetaData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextIndexEntityMetaDataImpl
implements TextIndexEntityMetaData {
    @NotNull
    private final String entityType;
    @NotNull
    private final Map<String, FieldTextExtractor> textExtractors = new TreeMap<String, FieldTextExtractor>();
    private String[] fieldNames = null;

    public TextIndexEntityMetaDataImpl(@NotNull String entityType) {
        this.entityType = entityType;
    }

    @NotNull
    public String getEntityType() {
        return this.entityType;
    }

    public String[] getFieldNames() {
        if (this.fieldNames == null) {
            this.fieldNames = this.textExtractors.keySet().toArray(new String[this.textExtractors.size()]);
        }
        return this.fieldNames;
    }

    @Nullable
    public FieldTextExtractor getFieldTextExtractor(@NotNull String name) {
        return this.textExtractors.get(name);
    }

    public void addTextExtractor(@NotNull String name, @NotNull FieldTextExtractor extractor) {
        if (!this.textExtractors.containsKey(name)) {
            this.fieldNames = null;
            this.textExtractors.put(name, extractor);
        }
    }
}

