/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.charisma.persistent.queries.YouTrackTransientQueryEngine;
import jetbrains.charisma.smartui.inplaceSimilarIssue.SimilarIssuesCalculator;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.FixedLengthByteIterable;
import jetbrains.exodus.core.dataStructures.NanoSet;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.execution.DecoratorJob;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.Settings;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.env.ContextualEnvironment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.lucene.DebugExodusDirectory;
import jetbrains.exodus.lucene.ExodusDirectory;
import jetbrains.exodus.lucene.ExodusDirectoryConfig;
import jetbrains.exodus.lucene.codecs.Lucene70CodecWithNoFieldCompression;
import jetbrains.exodus.query.NodeBase;
import jetbrains.exodus.query.Or;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.exodus.query.TreeKeepingEntityIterable;
import jetbrains.exodus.util.MathUtil;
import jetbrains.exodus.vfs.ClusterConverter;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.IOCancellingPolicy;
import jetbrains.exodus.vfs.IOCancellingPolicyProvider;
import jetbrains.exodus.vfs.VfsConfig;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.textindex.AirCompressor;
import jetbrains.youtrack.textindex.CancellingPolicyProvider;
import jetbrains.youtrack.textindex.Fields;
import jetbrains.youtrack.textindex.HitsEntityIterableBase;
import jetbrains.youtrack.textindex.HitsEntityIterator;
import jetbrains.youtrack.textindex.SearchResultsEntityIterable;
import jetbrains.youtrack.textindex.SearchSection;
import jetbrains.youtrack.textindex.SimilarResultsEntityIterable;
import jetbrains.youtrack.textindex.StaticSettings;
import jetbrains.youtrack.textindex.TextIndexManagerBase;
import jetbrains.youtrack.textindex.TransactionalIndexSearcherReference;
import jetbrains.youtrack.textindex.VfsContentCache;
import jetbrains.youtrack.textindex.analysis.StringReplace;
import jetbrains.youtrack.textindex.api.FieldTextExtractor;
import jetbrains.youtrack.textindex.api.TextIndexEntityMetaData;
import jetbrains.youtrack.textindex.api.TextIndexListener;
import jetbrains.youtrack.textindex.api.TextIndexMetaData;
import jetbrains.youtrack.textindex.async.CheckIndexJob;
import jetbrains.youtrack.textindex.exactmatch.ExactMatchStringTransform;
import jetbrains.youtrack.textindex.nodes.TextSearch;
import jetbrains.youtrack.textindex.query.FindSimilarIssuesIterableImpl;
import jetbrains.youtrack.textindex.query.LocalScopeAwareSimilarResultsEntityIterable;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BytesRef;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.WebLocalScope;

public class TextIndexManagerImpl
extends TextIndexManagerBase {
    @NotNull
    @NonNls
    private static final String ENTITY_ID_FIELD = "entity_id";
    @NotNull
    static final Set<String> ENTITY_ID_FIELD_SET = new NanoSet((Object)"entity_id");
    @NotNull
    @NonNls
    private static final String NON_DELIMITERS_HASH_SETTING = "jetbrains.dnq.textIndex.nonDelimitersHash";
    @NotNull
    @NonNls
    private static final String CODE_FIELD = "code";
    @NotNull
    @NonNls
    private static final Pattern START_CODE_WIKI_ELEMENT = Pattern.compile("(([{]code[^\n}]*[}])|(^[`]{3,}[a-zA-Z0-9 \t]*[\n]))", 8);
    @NotNull
    @NonNls
    private static final Pattern END_CODE_WIKI_ELEMENT = Pattern.compile("[{]code[}]");
    @NotNull
    @NonNls
    private static final Pattern ALTERNATIVE_END_CODE_WIKI_ELEMENT = Pattern.compile("^([`]){3,}", 8);
    private final Map<String, Set<String>> fieldsNotForSimilarity = new HashMap();
    private Directory directory;
    private volatile IndexReader mockIndexReader;
    private volatile ThreadLocal<SoftReference<IndexReader>> threadIndexReader;
    private final ThreadLocal<TransactionalIndexSearcherReference> threadSearchReference;
    private final ReadWriteLock indexReaderWriterLock;
    private final StoreConfig vfsStoreConfig;
    private final ExodusDirectoryConfig directoryConfig;
    private final CancellingPolicyProvider cancellingPolicyProvider;
    private volatile Pair<EntityId, SoftReference<Directory>> tempIndexRecord;
    private final AtomicBoolean isOpen;
    public final BeanContainer beanContainer;

    public TextIndexManagerImpl(@NotNull ContextualEnvironment environment, @NotNull TextIndexMetaData metaData, @NotNull PersistentEntityStoreImpl store, @NotNull TransientEntityStore transientStore, @NotNull DecoratorJob transactionalDecoratorJob) {
        super(environment, metaData, store, transientStore, transactionalDecoratorJob);
        this.getQueryAnalyzer().setStopWordExceptions(StaticSettings.getStopWordExceptions());
        this.getTextAnalyzer().setStopWordExceptions(StaticSettings.getStopWordExceptions());
        this.clearIndexReaders();
        this.threadSearchReference = new ThreadLocal();
        this.indexReaderWriterLock = new ReentrantReadWriteLock(StaticSettings.useFairLock());
        this.vfsStoreConfig = StaticSettings.usePatriciaAsVFSDefaultTree() ? StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING : StoreConfig.WITHOUT_DUPLICATES;
        this.directoryConfig = new ExodusDirectoryConfig();
        this.directoryConfig.setInputBufferSize(StaticSettings.getIndexInputBufferSize(this.directoryConfig.getInputBufferSize()));
        this.directoryConfig.setInputMergeBufferSize(StaticSettings.getIndexInputMergeBufferSize(this.directoryConfig.getInputMergeBufferSize()));
        this.cancellingPolicyProvider = new CancellingPolicyProvider(this);
        this.createDirectory();
        this.isOpen = new AtomicBoolean(true);
        this.beanContainer = WebLocalScope.getContainer();
    }

    @Override
    protected void initSettings() {
        super.initSettings();
        Settings.set((Store)this.internalSettings, (String)"jetbrains.dnq.textIndex.stopWordExceptions", (String)TextIndexManagerImpl.stopWordExceptionsStringValue(StaticSettings.getStopWordExceptions()));
        Settings.set((Store)this.internalSettings, (String)"jetbrains.dnq.textIndex.usePatriciaAsVFSTree", (String)Boolean.toString(StaticSettings.usePatriciaAsVFSDefaultTree()));
        Settings.set((Store)this.internalSettings, (String)"jetbrains.dnq.textIndex.vfsClusterSize", (String)Integer.toString(StaticSettings.getVfsClusterSize()));
        Settings.set((Store)this.internalSettings, (String)"jetbrains.dnq.textIndex.compression", (String)StaticSettings.getCompressionType());
        boolean exactMatchAllowed = StaticSettings.getExactMatchAllowed();
        Settings.set((Store)this.internalSettings, (String)"jetbrains.dnq.textIndex.exactMatchAllowed", (String)Boolean.toString(exactMatchAllowed));
        if (exactMatchAllowed) {
            Settings.set((Store)this.internalSettings, (String)NON_DELIMITERS_HASH_SETTING, (String)Integer.toString(ExactMatchStringTransform.getNonDelimitersHash()));
        }
    }

    @Override
    protected boolean shouldRebuild() {
        if (super.shouldRebuild()) {
            return true;
        }
        String stopWordExceptions = TextIndexManagerImpl.stopWordExceptionsStringValue(StaticSettings.getStopWordExceptions());
        String stopWordExceptionsSaved = Settings.get((Store)this.internalSettings, (String)"jetbrains.dnq.textIndex.stopWordExceptions");
        if (stopWordExceptionsSaved == null || !stopWordExceptionsSaved.equals(stopWordExceptions)) {
            log.info((Object)("List of stop word exceptions changed: " + stopWordExceptions + " was: " + stopWordExceptionsSaved));
            return true;
        }
        String vfsClusterSize = Settings.get((Store)this.internalSettings, (String)"jetbrains.dnq.textIndex.vfsClusterSize");
        if (vfsClusterSize == null || Integer.parseInt(vfsClusterSize) != StaticSettings.getVfsClusterSize()) {
            return true;
        }
        String compressionType = Settings.get((Store)this.internalSettings, (String)"jetbrains.dnq.textIndex.compression");
        if (compressionType == null || !StaticSettings.getCompressionType().equalsIgnoreCase(compressionType)) {
            return true;
        }
        String usePatriciaSaved = Settings.get((Store)this.internalSettings, (String)"jetbrains.dnq.textIndex.usePatriciaAsVFSTree");
        boolean usePatriciaActual = Boolean.parseBoolean(usePatriciaSaved);
        if (StaticSettings.usePatriciaAsVFSDefaultTree() != usePatriciaActual) {
            log.info((Object)("Type of VFS tree changed: " + (StaticSettings.usePatriciaAsVFSDefaultTree() ? "patricia" : "btree") + " was: " + (StaticSettings.usePatriciaAsVFSDefaultTree() ? "btree" : "patricia")));
            return true;
        }
        String exactMatchSaved = Settings.get((Store)this.internalSettings, (String)"jetbrains.dnq.textIndex.exactMatchAllowed");
        if (exactMatchSaved == null) {
            log.info((Object)"ExactMatchAllowed setting not set");
            return true;
        }
        boolean exactMatchAllowed = Boolean.parseBoolean(exactMatchSaved);
        if (StaticSettings.getExactMatchAllowed() != exactMatchAllowed) {
            log.info((Object)("ExactMatchAllowed setting changed: " + exactMatchAllowed + " -> " + StaticSettings.getExactMatchAllowed()));
            return true;
        }
        if (StaticSettings.getExactMatchAllowed()) {
            String nonDelimitersHashSaved = Settings.get((Store)this.internalSettings, (String)NON_DELIMITERS_HASH_SETTING);
            if (nonDelimitersHashSaved == null) {
                log.info((Object)"Non-delimiters hash is not set");
                return true;
            }
            String nonDelimitersHash = Integer.toString(ExactMatchStringTransform.getNonDelimitersHash());
            if (!nonDelimitersHashSaved.equals(nonDelimitersHash)) {
                log.info((Object)("Changes in Unicode! Non-delimiters hash was " + nonDelimitersHashSaved + ", is " + nonDelimitersHash));
                return true;
            }
        }
        return false;
    }

    @Override
    public void close() {
        if (this.isOpen.getAndSet(false)) {
            log.info((Object)"Closing...");
            if (this.isSuspended()) {
                this.resumeIndexing();
            }
            this.finish();
            log.info((Object)("Queries cache hit rate: " + this.queriesCache.hitRate() * 100.0f + "%"));
            try {
                this.directory.close();
            }
            catch (IOException e) {
                throw ExodusException.toExodusException((Throwable)e);
            }
            super.close();
        }
    }

    @Override
    public void clearIndex() {
        this.createMockIndexReaderIfNecessary();
        this.environment.executeTransactionSafeTask(() -> TextIndexManagerImpl.super.clearIndex());
    }

    public boolean matchesQuery(@NotNull Entity entity, @NotNull String queryString) {
        return this.matchesQuery(entity, queryString, "entire_doc");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean matchesQuery(@NotNull Entity entity, @NotNull String queryString, @NotNull String field) {
        try {
            Pair<EntityId, SoftReference<Directory>> tempIndexRecord = this.tempIndexRecord;
            RAMDirectory tempIndex = null;
            if (tempIndexRecord != null && ((EntityId)tempIndexRecord.getFirst()).equals(entity.getId())) {
                tempIndex = (Directory)((SoftReference)tempIndexRecord.getSecond()).get();
            }
            if (tempIndex == null) {
                tempIndex = new RAMDirectory();
                IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)this.getTextAnalyzer());
                IndexWriter indexWriter = new IndexWriter((Directory)tempIndex, indexWriterConfig);
                indexWriter.addDocument((Iterable)this.createSingleDocument(entity, this.getEntityMetaData(entity), false));
                indexWriter.close();
                this.tempIndexRecord = new Pair((Object)entity.getId(), new SoftReference<RAMDirectory>(tempIndex));
            }
            try (DirectoryReader reader = DirectoryReader.open(tempIndex);){
                boolean bl = new IndexSearcher((IndexReader)reader).search((Query)this.getQuery((String)queryString, (String)field, (int)-1), (int)1).totalHits > 0L;
                return bl;
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to check if entity(" + entity + ") matches query: '" + queryString + '\''), (Throwable)e);
            throw ExodusException.toExodusException((Throwable)e);
        }
    }

    @NotNull
    public EntityIterable findSimilar(@NotNull Entity entity) {
        return new SimilarResultsEntityIterable(this, entity, null);
    }

    @NotNull
    public EntityIterable findSimilar(@NotNull Entity entity, @Nullable Float threshold) {
        return new SimilarResultsEntityIterable(this, entity, threshold);
    }

    public void setSimilarityIgnoredField(@NotNull String entityType, @NotNull String field) {
        HashSet fields = this.fieldsNotForSimilarity.get(entityType);
        if (fields == null) {
            fields = new HashSet();
            this.fieldsNotForSimilarity.put(entityType, (Set<String>)fields);
        }
        fields.add((String)field);
    }

    @Override
    public long totalDocs() {
        try (SearchSection ignored = new SearchSection(this);){
            long l = this.getCurrentSearchReference().get().getIndexReader().numDocs();
            return l;
        }
    }

    @Override
    public void clearIndexImpl() {
        this.executeExclusiveTask(() -> {
            this.createMockIndexReaderIfNecessary();
            try {
                this.directory.close();
                this.environment.clear();
                this.initSettings();
                this.createDirectory();
            }
            catch (IOException e) {
                log.error((Object)"Failed to clear index", (Throwable)e);
            }
            for (TextIndexListener listener : this.getListeners()) {
                listener.indexCleared();
            }
        });
        this.processorStarted();
    }

    @Override
    public void indexDocumentImpl(@NotNull TextIndexManagerBase.IndexingContext context, @NotNull Entity entity, @NotNull TextIndexEntityMetaData entityMetaData) throws Exception {
        float documentBoost;
        EntityId id = entity.getId();
        if (HitsEntityIterator.STATIC_BOOST && (documentBoost = this.getDocumentBooster().getBoost(entity)) == 0.0f) {
            this.deleteDocumentImpl(context, id);
            return;
        }
        Document doc = this.createSingleDocument(entity, entityMetaData, true);
        doc.add((IndexableField)new Field(ENTITY_ID_FIELD, TextIndexManagerImpl.entityIdTerm(id), (IndexableFieldType)Fields.ID_FIELD_TYPE));
        ((LuceneIndexingContext)context).getIndexWriter().updateDocument(TextIndexManagerImpl.getEntityIdTerm(id), (Iterable)doc);
    }

    @Override
    public void deleteDocumentImpl(@NotNull TextIndexManagerBase.IndexingContext context, @NotNull EntityId id) throws Exception {
        ((LuceneIndexingContext)context).getIndexWriter().deleteDocuments(new Term[]{TextIndexManagerImpl.getEntityIdTerm(id)});
    }

    @Override
    public void queueDeletionOfObsoleteDocuments(@NotNull StoreTransaction txn) {
        try (SearchSection ignored = new SearchSection(this);){
            IndexSearcher indexSearcher = this.getCurrentSearchReference().get();
            for (int docId = 0; docId < indexSearcher.getIndexReader().numDocs(); ++docId) {
                EntityId id = TextIndexManagerImpl.getDocumentEntityId(indexSearcher.doc(docId, ENTITY_ID_FIELD_SET));
                try {
                    txn.getEntity(id);
                    continue;
                }
                catch (EntityStoreException e) {
                    this.deleteDocument(id);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"TextIndexManager.queueDeletionOfObsoleteDocuments() failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    void checkIndex() {
        if (StaticSettings.checkIndexOnError()) {
            new CheckIndexJob(this);
        }
    }

    public void checkIndexImpl() {
        this.executeExclusiveTask(() -> {
            Void cfr_ignored_0 = (Void)this.computeInReadonlyTransaction(txn -> {
                try {
                    CheckIndex checkIndex = new CheckIndex(this.directory);
                    checkIndex.setInfoStream(new PrintStream(System.out));
                    checkIndex.checkIndex();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to check index", (Throwable)e);
                }
                return null;
            });
        });
    }

    void beginSearch() {
        TransactionalIndexSearcherReference searchRef = this.threadSearchReference.get();
        if (searchRef == null) {
            this.threadSearchReference.set(this.newTransactionalIndexSearcherReference());
        } else {
            searchRef.incReentrantUsers();
        }
    }

    void endSearch() {
        TransactionalIndexSearcherReference searchRef = this.threadSearchReference.get();
        if (searchRef == null) {
            throw new IllegalStateException("To end search, begin it");
        }
        if (searchRef.decReentrantUsers() == 0) {
            try {
                searchRef.close();
            }
            finally {
                this.threadSearchReference.remove();
            }
        }
    }

    public void executeSearchAction(Runnable action) {
        try (SearchSection ignored = new SearchSection(this);){
            action.run();
        }
    }

    public <T> T executeSearch(@NotNull Function0<? extends T> action) {
        try (SearchSection ignored = new SearchSection(this);){
            Object object = action.invoke();
            return (T)object;
        }
    }

    public void beforeProcessingJob(@NotNull Job job) {
        super.beforeProcessingJob(job);
        WebLocalScope.setLocalBeanContainer((BeanContainer)this.beanContainer);
    }

    public void afterProcessingJob(@NotNull Job job) {
        WebLocalScope.removeLocalBeanContainer();
        super.afterProcessingJob(job);
    }

    public Iterable<Entity> findIssues(Iterable<Entity> instance, String query) {
        YouTrackTransientQueryEngine engine = (YouTrackTransientQueryEngine)this.beanContainer.getBean("queryEngine");
        return new TreeKeepingEntityIterable(instance, "Issue", (NodeBase)new TextSearch(query, null), (QueryEngine)engine);
    }

    public FindSimilarIssuesIterableImpl findSimilarIssues(PersistentEntity sample) {
        YouTrackTransientQueryEngine engine = (YouTrackTransientQueryEngine)this.beanContainer.getBean("queryEngine");
        return new FindSimilarIssuesIterableImpl(engine, sample, this.getPersistentStore().getAndCheckCurrentTransaction(), (Function1<? super Entity, ? extends EntityIterableBase>)((Function1)entity -> new LocalScopeAwareSimilarResultsEntityIterable(sample, this, engine, this.beanContainer, SimilarIssuesCalculator.NOT_SIMILAR_THRESHOLD)));
    }

    public Iterable<Entity> findIssuesBySummaryAndDescription(@Nullable Iterable<Entity> issues, String query) {
        return new TreeKeepingEntityIterable(issues, "Issue", (NodeBase)new Or((NodeBase)new TextSearch(query, "summary"), (NodeBase)new TextSearch(query, "description")), (QueryEngine)ServiceLocator.getBean((String)"queryEngine"));
    }

    @Override
    protected TextIndexManagerBase.IndexingContext createIndexingContext() throws IOException {
        return new LuceneIndexingContext();
    }

    @Override
    protected boolean isIndexed(@NotNull EntityId id) {
        Throwable throwable = null;
        try (SearchSection ignored = new SearchSection(this);){
            IndexSearcher indexSearcher = this.getCurrentSearchReference().get();
            try {
                boolean bl = indexSearcher.search((Query)TextIndexManagerImpl.getEntityIdQuery((EntityId)id), (int)1).totalHits > 0L;
                return bl;
            }
            catch (IOException e) {
                try {
                    log.error((Object)"TextIndexManager.isIndexed() failed", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    protected HitsEntityIterableBase getSearchResults(@NotNull Query query, int entityTypeId, @Nullable Supplier<Query> emptyResultsFun) {
        return new SearchResultsEntityIterable(this, query, emptyResultsFun, entityTypeId);
    }

    @Override
    protected boolean hasTermsStartingWith(@NotNull String term) {
        Throwable throwable = null;
        try (SearchSection ignored = new SearchSection(this);){
            IndexSearcher indexSearcher = this.getCurrentSearchReference().get();
            IndexReader indexReader = indexSearcher.getIndexReader();
            try {
                Terms terms = MultiFields.getTerms((IndexReader)indexReader, (String)"entire_doc");
                if (terms != null) {
                    BytesRef text;
                    TermsEnum termsEnum = terms.iterator();
                    while ((text = termsEnum.next()) != null) {
                        if (!text.utf8ToString().startsWith(term)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                try {
                    log.error((Object)"TextIndexManager.hasTermsStartingWith() failed", (Throwable)e);
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    protected void processorStarted() {
        ((EnvironmentImpl)this.environment).getGC().setCleanerJobProcessor((JobProcessorAdapter)this);
        this.environment.executeInTransaction(txn -> {
            try {
                this.createIndexingContext().close(null);
            }
            catch (Throwable t) {
                log.error((Object)"Failed to open index", t);
                throw new RuntimeException(t);
            }
        });
        super.processorStarted();
    }

    Collection<String> getSimilarityIgnoredFields(@NotNull String entityType) {
        Set<String> result = this.fieldsNotForSimilarity.get(entityType);
        return Collections.unmodifiableCollection(result == null ? Collections.EMPTY_LIST : result);
    }

    TransactionalIndexSearcherReference getCurrentSearchReference() {
        return this.threadSearchReference.get();
    }

    void lockShared() {
        boolean wasInterrupted = false;
        IOCancellingPolicy policy = this.cancellingPolicyProvider.getPolicy();
        long started = System.currentTimeMillis();
        try {
            Lock readLock = this.indexReaderWriterLock.readLock();
            while (!this.isFinished()) {
                if (readLock.tryLock(1000L, TimeUnit.MILLISECONDS)) {
                    return;
                }
                if (policy.needToCancel()) {
                    policy.doCancel();
                }
                if (System.currentTimeMillis() - started <= StaticSettings.getReadLockTimeout()) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            wasInterrupted = true;
            log.error((Object)"TextIndexManager.lockShared() interrupted", (Throwable)e);
        }
        if (this.isFinished()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"TextIndexManager.lockShared() interrupted as TextIndexManager is finished");
            }
            return;
        }
        log.error((Object)("TextIndexManager.lockShared() timeout after " + StaticSettings.getReadLockTimeout() + " milliseconds"));
        String exceptionMsg = "TextIndexManager.lockShared() timeout";
        if (wasInterrupted) {
            exceptionMsg = exceptionMsg + ". Waiting for the lock was interrupted.";
        }
        throw new ExodusException(exceptionMsg);
    }

    void unlockShared() {
        if (!this.isFinished()) {
            this.indexReaderWriterLock.readLock().unlock();
        }
    }

    private void lockExclusive() {
        try {
            while (!this.isFinished()) {
                if (!this.indexReaderWriterLock.writeLock().tryLock(1000L, TimeUnit.MILLISECONDS)) continue;
                return;
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"TextIndexManager.lockExclusive() interrupted", (Throwable)e);
        }
        if (this.isFinished()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"TextIndexManager.lockExclusive() interrupted as TextIndexManager is finished");
            }
            return;
        }
        throw new ExodusException("TextIndexManager.lockExclusive() interrupted");
    }

    private void unlockExclusive() {
        if (!this.isFinished()) {
            this.indexReaderWriterLock.writeLock().unlock();
        }
    }

    private TransactionalIndexSearcherReference newTransactionalIndexSearcherReference() {
        return new TransactionalIndexSearcherReference(this, this::getCurrentThreadIndexReader);
    }

    private Document createSingleDocument(@NotNull Entity entity, @NotNull TextIndexEntityMetaData entityMetaData, boolean notifyListeners) {
        Document doc = new Document();
        TextIndexMetaData.RemoveWikiFunction removeWikiFunction = this.getMetaData().getRemoveWikiFunction();
        StringBuilder entireDocumentBuilder = null;
        StringBuilder codeBuilder = null;
        for (String fieldName : entityMetaData.getFieldNames()) {
            FieldTextExtractor extractor = entityMetaData.getFieldTextExtractor(fieldName);
            if (extractor == null) {
                throw new RuntimeException("No field entireText extractor for '" + fieldName + "'");
            }
            String fieldText = TextIndexManagerImpl.getTextSafe(entity, extractor);
            if (fieldText == null || fieldText.length() == 0) continue;
            String plainText = TextIndexManagerImpl.removeWiki(removeWikiFunction, entity, fieldText);
            doc.add((IndexableField)new Field(fieldName, plainText, (IndexableFieldType)Fields.TEXT_FIELD_TYPE));
            if (entireDocumentBuilder == null) {
                entireDocumentBuilder = new StringBuilder();
            } else if (StaticSettings.getExactMatchAllowed()) {
                entireDocumentBuilder.append(' ');
                entireDocumentBuilder.append(ExactMatchStringTransform.highestNonDelimiter());
                entireDocumentBuilder.append(' ');
            } else {
                entireDocumentBuilder.append(" a the ");
            }
            entireDocumentBuilder.append(plainText);
            if (fieldText.indexOf(123) < 0 && fieldText.indexOf(96) < 0) continue;
            int startIndex = 0;
            Matcher startMatcher = START_CODE_WIKI_ELEMENT.matcher(fieldText);
            while (startIndex < fieldText.length() && startMatcher.find(startIndex) && (startIndex = startMatcher.end()) < fieldText.length()) {
                int endIndex;
                Pattern endPattern = fieldText.charAt(startIndex - 1) == '}' ? END_CODE_WIKI_ELEMENT : ALTERNATIVE_END_CODE_WIKI_ELEMENT;
                Matcher endMatcher = endPattern.matcher(fieldText);
                int n = endIndex = endMatcher.find(startIndex) ? endMatcher.start() : fieldText.length();
                if (codeBuilder == null) {
                    codeBuilder = new StringBuilder();
                } else {
                    codeBuilder.append(' ');
                }
                codeBuilder.append(fieldText, startIndex, endIndex);
                startIndex = endIndex + 1;
            }
        }
        if (codeBuilder != null) {
            doc.add((IndexableField)new Field(CODE_FIELD, codeBuilder.toString(), (IndexableFieldType)Fields.TEXT_FIELD_TYPE));
        }
        if (entireDocumentBuilder != null) {
            String entireText = entireDocumentBuilder.toString();
            doc.add((IndexableField)new Field("entire_doc", entireText, (IndexableFieldType)Fields.TEXT_FIELD_TYPE));
            doc.add((IndexableField)new Field("entire_doc_reversed", entireDocumentBuilder.reverse().toString(), (IndexableFieldType)Fields.EXTRA_TEXT_FIELD_TYPE));
            if (StaticSettings.getExactMatchAllowed()) {
                doc.add((IndexableField)new Field("entire_doc_exact_match", ExactMatchStringTransform.charsToSearchablePhrase(entireText), (IndexableFieldType)Fields.EXACT_MATCH_PHRASE_FIELD_TYPE));
                doc.add((IndexableField)new Field("entire_doc_exact_match_filter_sum", ExactMatchStringTransform.charsToSearchableFilter(entireText), (IndexableFieldType)Fields.EXACT_MATCH_FILTER_FIELD_TYPE));
            }
            if (notifyListeners) {
                EntityId id = entity.getId();
                for (TextIndexListener listener : this.getListeners()) {
                    listener.documentAdded(id, entireText);
                }
            }
        }
        return doc;
    }

    private void createDirectory() {
        VfsConfig vfsConfig = new VfsConfig();
        int clusterSize = StaticSettings.getVfsClusterSize();
        vfsConfig.setClusteringStrategy((ClusteringStrategy)new ClusteringStrategy.LinearClusteringStrategy(clusterSize));
        if (StaticSettings.useDebugDirectory()) {
            this.directory = new DebugExodusDirectory(this.environment, this.vfsStoreConfig, this.directoryConfig);
        } else if (StaticSettings.useRAMDirectory()) {
            this.directory = new RAMDirectory();
        } else {
            ExodusDirectory directory = new ExodusDirectory(this.environment, vfsConfig, this.vfsStoreConfig, this.directoryConfig);
            directory.getVfs().setCancellingPolicyProvider((IOCancellingPolicyProvider)this.cancellingPolicyProvider);
            AirCompressor vfsContentCompressor = AirCompressor.getInstance(StaticSettings.getCompressionType(), clusterSize);
            if (vfsContentCompressor == null) {
                vfsContentCompressor = new ClusterConverter(){

                    @NotNull
                    public ByteIterable onRead(@NotNull ByteIterable raw) {
                        return raw instanceof FixedLengthByteIterable ? new ArrayByteIterable(raw) : raw;
                    }

                    @NotNull
                    public ByteIterable onWrite(@NotNull ByteIterable source) {
                        return source;
                    }
                };
            }
            if (VfsContentCache.CLUSTER_CACHE_SIZE == 0) {
                directory.getVfs().setClusterConverter((ClusterConverter)vfsContentCompressor);
            } else {
                directory.getVfs().setClusterConverter((ClusterConverter)new VfsContentCache(this.environment, clusterSize, vfsContentCompressor));
            }
            double nrtSize = StaticSettings.getNRTCacheSizeMb();
            this.directory = nrtSize > 0.0 ? new NRTCachingDirectory((Directory)directory, nrtSize / 10.0, nrtSize) : directory;
        }
        this.createMockIndexReaderIfNecessary();
    }

    private IndexReader getCurrentThreadIndexReader() {
        IndexReader result;
        IndexReader mockIndexReader = this.mockIndexReader;
        if (mockIndexReader != null) {
            return mockIndexReader;
        }
        SoftReference<IndexReader> indexReaderRef = this.threadIndexReader.get();
        IndexReader indexReader = result = indexReaderRef == null ? null : indexReaderRef.get();
        if (result == null) {
            result = this.newDirectoryReader();
            if (result == null) {
                result = this.newDirectoryReader();
            }
            if (result == null) {
                result = this.newMockIndexReader();
            } else {
                this.threadIndexReader.set(new SoftReference<IndexReader>(result));
            }
        }
        return result;
    }

    @Nullable
    private IndexReader newDirectoryReader() {
        try {
            return DirectoryReader.open((Directory)this.directory);
        }
        catch (Throwable t) {
            if (t instanceof IOException || t instanceof IllegalArgumentException) {
                log.info((Object)"Failed to create directory reader", t);
                return null;
            }
            throw new RuntimeException(t);
        }
    }

    private void createMockIndexReaderIfNecessary() {
        if (this.mockIndexReader == null) {
            this.mockIndexReader = this.newMockIndexReader();
        }
    }

    private DirectoryReader newMockIndexReader() {
        RAMDirectory directory = new RAMDirectory();
        try {
            IndexWriter indexWriter = new IndexWriter((Directory)directory, new IndexWriterConfig((Analyzer)this.getTextAnalyzer()));
            indexWriter.commit();
            indexWriter.close();
            return DirectoryReader.open((Directory)directory);
        }
        catch (IOException ignore) {
            log.error((Object)"Failed to set mock index reader, setting indexReader = null");
            return null;
        }
    }

    private void executeExclusiveTask(@NotNull Runnable task) {
        this.lockExclusive();
        try {
            task.run();
        }
        finally {
            this.unlockExclusive();
        }
    }

    void clearIndexReaders() {
        this.threadIndexReader = new ThreadLocal();
    }

    @Nullable
    static String getTextSafe(@NotNull Entity entity, @NotNull FieldTextExtractor extractor) {
        try {
            String result = extractor.getText(entity);
            return result == null || result.contains("``") ? result : StringReplace.replaceAll(result, "`", " `");
        }
        catch (Throwable t) {
            log.error((Object)("Failed to get text of " + entity), t);
            return null;
        }
    }

    static String removeWiki(TextIndexMetaData.RemoveWikiFunction removeWikiFunction, Entity entity, String text) {
        try {
            return removeWikiFunction.removeWiki(entity, text);
        }
        catch (Throwable t) {
            log.error((Object)("Failed to remove wiki for " + entity + "\n\ntext:\n" + text + "\n\n"), t);
            return text;
        }
    }

    private static String stopWordExceptionsStringValue(String[] exceptions) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String stopWordException : exceptions) {
            if (!first) {
                builder.append(',');
            }
            builder.append(stopWordException);
            first = false;
        }
        return builder.toString();
    }

    private static Term getEntityIdTerm(@NotNull EntityId id) {
        return new Term(ENTITY_ID_FIELD, TextIndexManagerImpl.entityIdTerm(id));
    }

    private static Query getEntityIdQuery(@NotNull EntityId id) {
        return new TermQuery(TextIndexManagerImpl.getEntityIdTerm(id));
    }

    private static String entityIdTerm(@NotNull EntityId id) {
        return String.format("%04x%x", id.getTypeId(), id.getLocalId());
    }

    static long getDocumentEntityLocalId(@NotNull Document doc) {
        String term = doc.get(ENTITY_ID_FIELD);
        return Long.parseLong(term.substring(4), 16);
    }

    @NotNull
    static EntityId getDocumentEntityId(@NotNull Document doc) {
        String term = doc.get(ENTITY_ID_FIELD);
        int entityTypeId = Integer.parseInt(term.substring(0, 4), 16);
        long entityLocalId = Long.parseLong(term.substring(4), 16);
        return new PersistentEntityId(entityTypeId, entityLocalId);
    }

    private class LuceneIndexingContext
    implements TextIndexManagerBase.IndexingContext {
        @NotNull
        private final IndexWriter indexWriter;

        private LuceneIndexingContext() throws IOException {
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)TextIndexManagerImpl.this.getTextAnalyzer());
            indexWriterConfig.setCommitOnClose(true);
            indexWriterConfig.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
            indexWriterConfig.setMaxBufferedDocs(Integer.MAX_VALUE);
            indexWriterConfig.setRAMBufferSizeMB(-1.0);
            LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
            mergePolicy.setMergeFactor(Math.max(MathUtil.integerLogarithm((int)TextIndexManagerImpl.this.pendingDocs()), 3));
            mergePolicy.setMinMergeMB((double)TextIndexManagerImpl.this.environment.getEnvironmentConfig().getLogFileSize() / 1024.0);
            indexWriterConfig.setMergePolicy((MergePolicy)mergePolicy);
            indexWriterConfig.setCodec((Codec)new Lucene70CodecWithNoFieldCompression());
            this.indexWriter = new IndexWriter(TextIndexManagerImpl.this.directory, indexWriterConfig);
        }

        @Override
        public void close(@Nullable Runnable closeContextClosure) throws IOException {
            this.indexWriter.close();
            TextIndexManagerImpl.this.executeExclusiveTask(() -> {
                if (closeContextClosure != null) {
                    closeContextClosure.run();
                }
                TextIndexManagerImpl.this.clearIndexReaders();
                TextIndexManagerImpl.this.mockIndexReader = null;
            });
        }

        @NotNull
        private IndexWriter getIndexWriter() {
            return this.indexWriter;
        }
    }
}

