/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.textindex.api.TextIndexEntityMetaData;
import jetbrains.youtrack.textindex.api.TextIndexMetaData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextIndexMetaDataImpl
implements TextIndexMetaData {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Map<String, TextIndexEntityMetaData> _entityMetaDatas = new HashMap<String, TextIndexEntityMetaData>();
    private String[] _cachedEntityTypes = null;
    private TextIndexMetaData.RemoveWikiFunction rwf = new TextIndexMetaData.RemoveWikiFunction(){

        public String removeWiki(Entity entity, String source) {
            return source;
        }
    };

    @NotNull
    public synchronized String[] getIndexedEntityTypes() {
        if (this._entityMetaDatas.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (this._cachedEntityTypes == null) {
            Set<String> entityTypes = this._entityMetaDatas.keySet();
            this._cachedEntityTypes = entityTypes.toArray(new String[entityTypes.size()]);
        }
        return this._cachedEntityTypes;
    }

    @Nullable
    public synchronized TextIndexEntityMetaData getEntityMetaData(@NotNull String entityType) {
        return this._entityMetaDatas.get(entityType);
    }

    public synchronized void addEntityMetaData(@NotNull String entityType, @NotNull TextIndexEntityMetaData metaData) {
        this._entityMetaDatas.put(entityType, metaData);
        this._cachedEntityTypes = null;
    }

    public TextIndexMetaData.RemoveWikiFunction getRemoveWikiFunction() {
        return this.rwf;
    }

    public void setRemoveWikiFunction(TextIndexMetaData.RemoveWikiFunction rwf) {
        this.rwf = rwf;
    }

    public String getVersionLabel() {
        return "";
    }
}

