/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.textindex.analysis;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashSet;
import jetbrains.youtrack.textindex.analysis.BufferedReplacingReader;
import jetbrains.youtrack.textindex.analysis.ExtraDelimiterReader;
import jetbrains.youtrack.textindex.analysis.GenericAnalyzer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.pl.PolishAnalyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.stempel.StempelStemmer;
import org.egothor.stemmer.Trie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001e\u001f B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0016H\u0014J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0016H\u0014J\u000e\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u0019\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c\u00a2\u0006\u0002\u0010\u001dR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Ljetbrains/youtrack/textindex/analysis/GenericAnalyzer;", "Lorg/apache/lucene/analysis/Analyzer;", "replaceColon", "", "(Z)V", "customStemFilters", "Ljetbrains/exodus/core/dataStructures/hash/LinkedHashSet;", "", "stopwordSet", "Lorg/apache/lucene/analysis/CharArraySet;", "kotlin.jvm.PlatformType", "getStopwordSet", "()Lorg/apache/lucene/analysis/CharArraySet;", "setStopwordSet", "(Lorg/apache/lucene/analysis/CharArraySet;)V", "addLanguage", "", "lang", "createComponents", "Lorg/apache/lucene/analysis/Analyzer$TokenStreamComponents;", "fieldName", "initReader", "Ljava/io/Reader;", "reader", "initReaderForNormalization", "removeLanguage", "setStopWordExceptions", "stopWordExceptions", "", "([Ljava/lang/String;)V", "Companion", "PolishStemmer", "TrivialReuseStrategy", "youtrack-text-search"})
public final class GenericAnalyzer
extends Analyzer {
    private final LinkedHashSet<String> customStemFilters;
    private CharArraySet stopwordSet;
    private final boolean replaceColon;
    @NotNull
    public static final String RUSSIAN = "Russian";
    @NotNull
    public static final String GERMAN = "German";
    @NotNull
    public static final String FRENCH = "French";
    @NotNull
    public static final String SPANISH = "Spanish";
    @NotNull
    public static final String PORTUGUESE = "Portuguese";
    @NotNull
    public static final String ITALIAN = "Italian";
    @NotNull
    public static final String DUTCH = "Dutch";
    @NotNull
    public static final String FINNISH = "Finnish";
    @NotNull
    public static final String SWEDISH = "Swedish";
    @NotNull
    public static final String NORWEGIAN = "Norwegian";
    @NotNull
    public static final String DANISH = "Danish";
    @NotNull
    public static final String POLISH = "Polish";
    @NotNull
    public static final String CZECH = "Czech";
    @NotNull
    public static final String GREEK = "Greek";
    @NotNull
    public static final String LATVIAN = "Latvian";
    @NotNull
    public static final String ARABIC = "Arabic";
    @NotNull
    public static final String TURKISH = "Turkish";
    @NotNull
    public static final String CHINESE = "Chinese";
    @NotNull
    public static final String JAPANESE = "Japanese";
    @NotNull
    public static final String KOREAN = "Korean";
    private static final HashMap<String, Function1<TokenStream, TokenStream>> stemFilters;
    public static final Companion Companion;

    public final CharArraySet getStopwordSet() {
        return this.stopwordSet;
    }

    public final void setStopwordSet(CharArraySet charArraySet) {
        this.stopwordSet = charArraySet;
    }

    public final void setStopWordExceptions(@NotNull String[] stopWordExceptions) {
        Intrinsics.checkParameterIsNotNull((Object)stopWordExceptions, (String)"stopWordExceptions");
        HashSet stopWordExceptionSet = new HashSet();
        stopWordExceptionSet.addAll((Collection)Arrays.asList(Arrays.copyOf(stopWordExceptions, stopWordExceptions.length)));
        CharArraySet stopwordSet = new CharArraySet(1, false);
        Iterator iterator = this.stopwordSet.iterator();
        while (iterator.hasNext()) {
            Object word;
            Object e = word = iterator.next();
            if (e == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharArray");
            }
            HashSet hashSet = stopWordExceptionSet;
            char[] cArray = (char[])e;
            String string = new String(cArray);
            if (hashSet.contains((Object)string)) continue;
            stopwordSet.add((char[])word);
        }
        this.stopwordSet = stopwordSet;
    }

    @NotNull
    protected Analyzer.TokenStreamComponents createComponents(@NotNull String fieldName) {
        StandardTokenizer standardTokenizer;
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        StandardTokenizer $receiver = standardTokenizer = new StandardTokenizer();
        boolean bl = false;
        $receiver.setMaxTokenLength(255);
        StandardTokenizer src = standardTokenizer;
        TokenStream tok = (TokenStream)src;
        if (Intrinsics.areEqual((Object)fieldName, (Object)"entire_doc_exact_match") ^ true && Intrinsics.areEqual((Object)fieldName, (Object)"entire_doc_exact_match_filter_sum") ^ true) {
            tok = (TokenStream)new ASCIIFoldingFilter(tok);
            tok = (TokenStream)new LowerCaseFilter(tok);
            if (Intrinsics.areEqual((Object)fieldName, (Object)"entire_doc_reversed") ^ true) {
                tok = (TokenStream)new StopFilter(tok, this.stopwordSet);
                if (!this.customStemFilters.isEmpty()) {
                    for (String lang : this.customStemFilters) {
                        Function1 function1 = (Function1)stemFilters.get((Object)lang);
                        if (function1 == null || (function1 = (TokenStream)function1.invoke((Object)tok)) == null) {
                            function1 = tok;
                        }
                        tok = function1;
                    }
                }
                tok = (TokenStream)new PorterStemFilter(tok);
            }
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)src, tok);
    }

    @NotNull
    protected Reader initReader(@NotNull String fieldName, @NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        return new BufferedReplacingReader(new ExtraDelimiterReader(reader, this.replaceColon));
    }

    @NotNull
    protected Reader initReaderForNormalization(@NotNull String fieldName, @NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        return new BufferedReplacingReader(new ExtraDelimiterReader(reader, this.replaceColon));
    }

    public final void addLanguage(@NotNull String lang) {
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        this.customStemFilters.add((Object)lang);
    }

    public final void removeLanguage(@NotNull String lang) {
        Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
        this.customStemFilters.remove((Object)lang);
    }

    @JvmOverloads
    public GenericAnalyzer(boolean replaceColon) {
        super((Analyzer.ReuseStrategy)new TrivialReuseStrategy());
        this.replaceColon = replaceColon;
        this.customStemFilters = new LinkedHashSet();
        this.stopwordSet = new ClassicAnalyzer().getStopwordSet();
    }

    @JvmOverloads
    public /* synthetic */ GenericAnalyzer(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @JvmOverloads
    public GenericAnalyzer() {
        this(false, 1, null);
    }

    static {
        HashMap hashMap;
        Companion = new Companion(null);
        HashMap $receiver = hashMap = new HashMap();
        boolean bl = false;
        Map map = (Map)$receiver;
        Object object = RUSSIAN;
        Object object2 = Companion.stemFilters.1.1.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = GERMAN;
        object2 = Companion.stemFilters.1.2.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = FRENCH;
        object2 = Companion.stemFilters.1.3.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = SPANISH;
        object2 = Companion.stemFilters.1.4.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = PORTUGUESE;
        object2 = Companion.stemFilters.1.5.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = ITALIAN;
        object2 = Companion.stemFilters.1.6.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = DUTCH;
        object2 = Companion.stemFilters.1.7.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = FINNISH;
        object2 = Companion.stemFilters.1.8.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = SWEDISH;
        object2 = Companion.stemFilters.1.9.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = NORWEGIAN;
        object2 = Companion.stemFilters.1.10.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = DANISH;
        object2 = Companion.stemFilters.1.11.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = POLISH;
        object2 = Companion.stemFilters.1.12.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = CZECH;
        object2 = Companion.stemFilters.1.13.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = GREEK;
        object2 = Companion.stemFilters.1.14.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = LATVIAN;
        object2 = Companion.stemFilters.1.15.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = ARABIC;
        object2 = Companion.stemFilters.1.16.INSTANCE;
        map.put(object, object2);
        map = (Map)$receiver;
        object = TURKISH;
        object2 = Companion.stemFilters.1.17.INSTANCE;
        map.put(object, object2);
        Function1 cjk2 = Companion.stemFilters.1.cjk.1.INSTANCE;
        object = (Map)$receiver;
        object2 = CHINESE;
        Function1 function1 = cjk2;
        object.put(object2, function1);
        object = (Map)$receiver;
        object2 = JAPANESE;
        function1 = cjk2;
        object.put(object2, function1);
        object = (Map)$receiver;
        object2 = KOREAN;
        function1 = cjk2;
        object.put(object2, function1);
        stemFilters = hashMap;
    }

    @JvmStatic
    @NotNull
    public static final String removeAccents(@NotNull String source) {
        return Companion.removeAccents(source);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/textindex/analysis/GenericAnalyzer$TrivialReuseStrategy;", "Lorg/apache/lucene/analysis/Analyzer$ReuseStrategy;", "()V", "getReusableComponents", "Lorg/apache/lucene/analysis/Analyzer$TokenStreamComponents;", "analyzer", "Lorg/apache/lucene/analysis/Analyzer;", "fieldName", "", "setReusableComponents", "", "components", "youtrack-text-search"})
    private static final class TrivialReuseStrategy
    extends Analyzer.ReuseStrategy {
        public void setReusableComponents(@NotNull Analyzer analyzer, @NotNull String fieldName, @NotNull Analyzer.TokenStreamComponents components) {
            Intrinsics.checkParameterIsNotNull((Object)analyzer, (String)"analyzer");
            Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
            Intrinsics.checkParameterIsNotNull((Object)components, (String)"components");
        }

        @Nullable
        public Analyzer.TokenStreamComponents getReusableComponents(@Nullable Analyzer analyzer, @Nullable String fieldName) {
            return null;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ljetbrains/youtrack/textindex/analysis/GenericAnalyzer$PolishStemmer;", "Lorg/apache/lucene/analysis/stempel/StempelStemmer;", "()V", "Companion", "youtrack-text-search"})
    private static final class PolishStemmer
    extends StempelStemmer {
        private static final Trie DEFAULT_TABLE;
        public static final Companion Companion;

        public PolishStemmer() {
            super(DEFAULT_TABLE);
        }

        static {
            Companion = new Companion(null);
            try {
                Trie trie = StempelStemmer.load((InputStream)PolishAnalyzer.class.getResourceAsStream("stemmer_20000.tbl"));
                Intrinsics.checkExpressionValueIsNotNull((Object)trie, (String)"StempelStemmer.load(Poli\u2026er.DEFAULT_STEMMER_FILE))");
                DEFAULT_TABLE = trie;
            }
            catch (IOException ex) {
                throw (Throwable)new RuntimeException("Unable to load default stemming tables", ex);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/textindex/analysis/GenericAnalyzer$PolishStemmer$Companion;", "", "()V", "DEFAULT_TABLE", "Lorg/egothor/stemmer/Trie;", "youtrack-text-search"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R&\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/youtrack/textindex/analysis/GenericAnalyzer$Companion;", "", "()V", "ARABIC", "", "CHINESE", "CZECH", "DANISH", "DUTCH", "FINNISH", "FRENCH", "GERMAN", "GREEK", "ITALIAN", "JAPANESE", "KOREAN", "LATVIAN", "NORWEGIAN", "POLISH", "PORTUGUESE", "RUSSIAN", "SPANISH", "SWEDISH", "TURKISH", "stemFilters", "Ljetbrains/exodus/core/dataStructures/hash/HashMap;", "Lkotlin/Function1;", "Lorg/apache/lucene/analysis/TokenStream;", "removeAccents", "source", "youtrack-text-search"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final String removeAccents(@NotNull String source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            int length = source.length();
            char[] out = new char[length * 4];
            String string = source;
            char[] cArray = string.toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            int outLen = ASCIIFoldingFilter.foldToASCII((char[])cArray, (int)0, (char[])out, (int)0, (int)length);
            int n = 0;
            return new String(out, n, outLen);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

