/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.notification;

import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import jetbrains.jetpass.api.settings.PublicSettings;
import jetbrains.jetpass.dao.api.API;
import jetbrains.jetpass.dao.api.settings.SettingsDAO;
import jetbrains.jetpass.notification.I18NTemplateDirectiveModel;
import jetbrains.jetpass.notification.NotificationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00010\u0018R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Ljetbrains/jetpass/notification/FreemarkerRenderer;", "", "()V", "api", "Ljetbrains/jetpass/dao/api/API;", "getApi", "()Ljetbrains/jetpass/dao/api/API;", "setApi", "(Ljetbrains/jetpass/dao/api/API;)V", "freemarkerConfiguration", "Lfreemarker/template/Configuration;", "value", "Lfreemarker/cache/TemplateLoader;", "templateLoader", "getTemplateLoader", "()Lfreemarker/cache/TemplateLoader;", "setTemplateLoader", "(Lfreemarker/cache/TemplateLoader;)V", "clearCache", "", "render", "", "templateName", "root", "", "jetbrains.jetpass.notification"})
public final class FreemarkerRenderer {
    private final Configuration freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_23);
    @NotNull
    public API api;

    @NotNull
    public final API getApi() {
        API aPI = this.api;
        if (aPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"api");
        }
        return aPI;
    }

    public final void setApi(@NotNull API aPI) {
        Intrinsics.checkParameterIsNotNull((Object)aPI, (String)"<set-?>");
        this.api = aPI;
    }

    @NotNull
    public final TemplateLoader getTemplateLoader() {
        TemplateLoader templateLoader = this.freemarkerConfiguration.getTemplateLoader();
        Intrinsics.checkExpressionValueIsNotNull((Object)templateLoader, (String)"freemarkerConfiguration.templateLoader");
        return templateLoader;
    }

    public final void setTemplateLoader(@NotNull TemplateLoader value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.freemarkerConfiguration.setTemplateLoader(value);
    }

    public final void clearCache() {
        this.freemarkerConfiguration.clearTemplateCache();
    }

    @NotNull
    public final String render(@NotNull String templateName, @NotNull Map<String, ? extends Object> root) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)templateName, (String)"templateName");
        Intrinsics.checkParameterIsNotNull(root, (String)"root");
        try {
            Template template = this.freemarkerConfiguration.getTemplate(templateName);
            StringWriter body = new StringWriter();
            Environment processingEnvironment = template.createProcessingEnvironment(root, (Writer)body);
            API aPI = this.api;
            if (aPI == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"api");
            }
            SettingsDAO settingsDAO = aPI.getSettingsDAO();
            Intrinsics.checkExpressionValueIsNotNull((Object)settingsDAO, (String)"api.settingsDAO");
            PublicSettings publicSettings = settingsDAO.getPublicSettings();
            Intrinsics.checkExpressionValueIsNotNull((Object)publicSettings, (String)"api.settingsDAO.publicSettings");
            jetbrains.jetpass.api.settings.Locale locale = publicSettings.getLocale();
            if (locale != null) {
                Environment environment = processingEnvironment;
                Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"processingEnvironment");
                environment.setLocale(Locale.forLanguageTag(locale.getLanguage()));
            }
            processingEnvironment.process();
            String string = body.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"body.toString()");
            return string;
        }
        catch (IOException e) {
            throw (Throwable)NotificationException.Companion.notificationRenderFailed(e);
        }
        catch (TemplateException e) {
            throw (Throwable)NotificationException.Companion.notificationRenderFailed(e);
        }
    }

    public FreemarkerRenderer() {
        this.freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(Configuration.VERSION_2_3_23));
        this.freemarkerConfiguration.setDefaultEncoding("UTF-8");
        this.freemarkerConfiguration.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        this.freemarkerConfiguration.setSharedVariable(I18NTemplateDirectiveModel.Companion.getNAME(), (TemplateModel)new I18NTemplateDirectiveModel());
        this.freemarkerConfiguration.setLocalizedLookup(false);
    }
}

