/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.notification;

import freemarker.cache.ClassTemplateLoader;
import java.io.IOException;
import java.io.Reader;
import jetbrains.jetpass.api.settings.Locale;
import jetbrains.jetpass.api.settings.PublicSettings;
import jetbrains.jetpass.dao.api.API;
import jetbrains.jetpass.dao.api.settings.SettingsDAO;
import jetbrains.jetpass.locale.PredefinedLocale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0014H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/jetpass/notification/HubBuiltInTemplateLoader;", "Lfreemarker/cache/ClassTemplateLoader;", "()V", "api", "Ljetbrains/jetpass/dao/api/API;", "getApi", "()Ljetbrains/jetpass/dao/api/API;", "setApi", "(Ljetbrains/jetpass/dao/api/API;)V", "currentLocale", "Ljetbrains/jetpass/api/settings/Locale;", "getCurrentLocale", "()Ljetbrains/jetpass/api/settings/Locale;", "loader", "closeTemplateSource", "", "templateSource", "", "findTemplateSource", "name", "", "getLastModified", "", "getReader", "Ljava/io/Reader;", "encoding", "jetbrains.jetpass.notification"})
public class HubBuiltInTemplateLoader
extends ClassTemplateLoader {
    @NotNull
    public API api;
    private final ClassTemplateLoader loader = new ClassTemplateLoader(((Object)((Object)this)).getClass(), "/templates");

    @NotNull
    public final API getApi() {
        API aPI = this.api;
        if (aPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"api");
        }
        return aPI;
    }

    public final void setApi(@NotNull API aPI) {
        Intrinsics.checkParameterIsNotNull((Object)aPI, (String)"<set-?>");
        this.api = aPI;
    }

    @NotNull
    protected Locale getCurrentLocale() {
        API aPI = this.api;
        if (aPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"api");
        }
        SettingsDAO settingsDAO = aPI.getSettingsDAO();
        Intrinsics.checkExpressionValueIsNotNull((Object)settingsDAO, (String)"api.settingsDAO");
        PublicSettings publicSettings = settingsDAO.getPublicSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicSettings, (String)"api.settingsDAO.publicSettings");
        Locale locale = publicSettings.getLocale();
        if (locale == null) {
            locale = (Locale)PredefinedLocale.ENGLISH;
        }
        return locale;
    }

    @Nullable
    public Object findTemplateSource(@NotNull String name) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Locale locale = this.getCurrentLocale();
        return this.loader.findTemplateSource(locale.getName() + "/" + name);
    }

    public long getLastModified(@NotNull Object templateSource) {
        Intrinsics.checkParameterIsNotNull((Object)templateSource, (String)"templateSource");
        return this.loader.getLastModified(templateSource);
    }

    @NotNull
    public Reader getReader(@NotNull Object templateSource, @NotNull String encoding) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)templateSource, (String)"templateSource");
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        Reader reader = this.loader.getReader(templateSource, encoding);
        Intrinsics.checkExpressionValueIsNotNull((Object)reader, (String)"loader.getReader(templateSource, encoding)");
        return reader;
    }

    public void closeTemplateSource(@NotNull Object templateSource) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)templateSource, (String)"templateSource");
        this.loader.closeTemplateSource(templateSource);
    }

    public HubBuiltInTemplateLoader() {
        super(HubBuiltInTemplateLoader.class, "/");
    }
}

