/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.notification;

import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import jetbrains.jetpass.api.settings.Locale;
import jetbrains.jetpass.api.settings.PublicSettings;
import jetbrains.jetpass.dao.api.API;
import jetbrains.jetpass.dao.api.settings.SettingsDAO;
import jetbrains.jetpass.locale.LocaleContainer;
import jetbrains.jetpass.locale.PredefinedLocale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0019H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Ljetbrains/jetpass/notification/HubCustomTemplateLoader;", "Lfreemarker/cache/TemplateLoader;", "()V", "api", "Ljetbrains/jetpass/dao/api/API;", "getApi", "()Ljetbrains/jetpass/dao/api/API;", "setApi", "(Ljetbrains/jetpass/dao/api/API;)V", "container", "Ljetbrains/jetpass/locale/LocaleContainer;", "getContainer", "()Ljetbrains/jetpass/locale/LocaleContainer;", "setContainer", "(Ljetbrains/jetpass/locale/LocaleContainer;)V", "currentLocale", "Ljetbrains/jetpass/api/settings/Locale;", "getCurrentLocale", "()Ljetbrains/jetpass/api/settings/Locale;", "closeTemplateSource", "", "templateSource", "", "findTemplateSource", "name", "", "getLastModified", "", "getReader", "Ljava/io/Reader;", "encoding", "jetbrains.jetpass.notification"})
public final class HubCustomTemplateLoader
implements TemplateLoader {
    @NotNull
    public API api;
    @NotNull
    public LocaleContainer container;

    @NotNull
    public final API getApi() {
        API aPI = this.api;
        if (aPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"api");
        }
        return aPI;
    }

    public final void setApi(@NotNull API aPI) {
        Intrinsics.checkParameterIsNotNull((Object)aPI, (String)"<set-?>");
        this.api = aPI;
    }

    @NotNull
    public final LocaleContainer getContainer() {
        LocaleContainer localeContainer = this.container;
        if (localeContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return localeContainer;
    }

    public final void setContainer(@NotNull LocaleContainer localeContainer) {
        Intrinsics.checkParameterIsNotNull((Object)localeContainer, (String)"<set-?>");
        this.container = localeContainer;
    }

    private final Locale getCurrentLocale() {
        API aPI = this.api;
        if (aPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"api");
        }
        SettingsDAO settingsDAO = aPI.getSettingsDAO();
        Intrinsics.checkExpressionValueIsNotNull((Object)settingsDAO, (String)"api.settingsDAO");
        PublicSettings publicSettings = settingsDAO.getPublicSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicSettings, (String)"api.settingsDAO.publicSettings");
        Locale locale = publicSettings.getLocale();
        if (locale == null) {
            locale = (Locale)PredefinedLocale.ENGLISH;
        }
        return locale;
    }

    @Nullable
    public Object findTemplateSource(@NotNull String name) throws IOException {
        File folder;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Locale locale = this.getCurrentLocale();
        LocaleContainer localeContainer = this.container;
        if (localeContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        if ((folder = localeContainer.getCustomTranslationFile(locale, "templates")) != null && folder.isDirectory()) {
            File file = new File(folder, FilenameUtils.getName((String)name));
            return file.isFile() ? file : null;
        }
        return null;
    }

    public long getLastModified(@NotNull Object templateSource) {
        Intrinsics.checkParameterIsNotNull((Object)templateSource, (String)"templateSource");
        return ((File)templateSource).lastModified();
    }

    @NotNull
    public Reader getReader(@NotNull Object templateSource, @NotNull String encoding) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)templateSource, (String)"templateSource");
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        if (!(templateSource instanceof File)) {
            throw (Throwable)new IllegalArgumentException("templateSource is a: " + templateSource.getClass().getName());
        }
        return new InputStreamReader((InputStream)new FileInputStream((File)templateSource), encoding);
    }

    public void closeTemplateSource(@NotNull Object templateSource) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)templateSource, (String)"templateSource");
    }
}

