/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.notification;

import java.util.Set;
import java.util.UUID;
import jetbrains.jetpass.api.settings.JabberSettings;
import jetbrains.jetpass.dao.api.API;
import jetbrains.jetpass.dao.api.settings.SettingsDAO;
import jetbrains.jetpass.notification.DebugModeProperty;
import jetbrains.jetpass.notification.JabberNotificator;
import jetbrains.jetpass.notification.JabberNotificatorImpl;
import jetbrains.jetpass.notification.JabberNotificatorImpl$debugMode$2;
import jetbrains.jetpass.notification.JabberSSLContextFactory;
import jetbrains.jetpass.notification.NotificationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.debugger.AbstractDebugger;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 .2\u00020\u0001:\u0002./B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010&\u001a\u00020'2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020'0)H\u0002J\u0018\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR+\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000fR\u001a\u0010 \u001a\u00020!X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00060"}, d2={"Ljetbrains/jetpass/notification/JabberNotificatorImpl;", "Ljetbrains/jetpass/notification/JabberNotificator;", "()V", "_debugMode", "", "api", "Ljetbrains/jetpass/dao/api/API;", "getApi", "()Ljetbrains/jetpass/dao/api/API;", "setApi", "(Ljetbrains/jetpass/dao/api/API;)V", "<set-?>", "", "debugMode", "getDebugMode", "()Ljava/lang/String;", "setDebugMode", "(Ljava/lang/String;)V", "debugMode$delegate", "Ljetbrains/jetpass/notification/DebugModeProperty;", "debugModeJabber", "", "getDebugModeJabber", "()Ljava/util/Set;", "setDebugModeJabber", "(Ljava/util/Set;)V", "jabberSettings", "Ljetbrains/jetpass/api/settings/JabberSettings;", "getJabberSettings", "()Ljetbrains/jetpass/api/settings/JabberSettings;", "service", "getService", "sslContextFactory", "Ljetbrains/jetpass/notification/JabberSSLContextFactory;", "getSslContextFactory", "()Ljetbrains/jetpass/notification/JabberSSLContextFactory;", "setSslContextFactory", "(Ljetbrains/jetpass/notification/JabberSSLContextFactory;)V", "openConnection", "", "body", "Lkotlin/Function1;", "Lorg/jivesoftware/smack/XMPPConnection;", "send", "jabber", "message", "Companion", "JabberDebuggerFactory", "jetbrains.jetpass.notification"})
public class JabberNotificatorImpl
implements JabberNotificator {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private boolean _debugMode;
    @NotNull
    private final DebugModeProperty debugMode$delegate = new DebugModeProperty(JabberNotificatorImpl$debugMode$2.INSTANCE);
    @NotNull
    private Set<String> debugModeJabber = SetsKt.emptySet();
    @NotNull
    public API api;
    @NotNull
    public JabberSSLContextFactory sslContextFactory;
    private static final int CONNECTION_TIMEOUT = 30000;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(JabberNotificatorImpl.class), "debugMode", "getDebugMode()Ljava/lang/String;"))};
        Companion = new Companion(null);
        CONNECTION_TIMEOUT = 30000;
    }

    @NotNull
    public final String getDebugMode() {
        return this.debugMode$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setDebugMode(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.debugMode$delegate.setValue(this, $$delegatedProperties[0], string);
    }

    @NotNull
    public final Set<String> getDebugModeJabber() {
        return this.debugModeJabber;
    }

    public final void setDebugModeJabber(@NotNull Set<String> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
        this.debugModeJabber = set;
    }

    @NotNull
    public final API getApi() {
        API aPI = this.api;
        if (aPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"api");
        }
        return aPI;
    }

    public final void setApi(@NotNull API aPI) {
        Intrinsics.checkParameterIsNotNull((Object)aPI, (String)"<set-?>");
        this.api = aPI;
    }

    @NotNull
    public final JabberSettings getJabberSettings() {
        API aPI = this.api;
        if (aPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"api");
        }
        SettingsDAO settingsDAO = aPI.getSettingsDAO();
        Intrinsics.checkExpressionValueIsNotNull((Object)settingsDAO, (String)"api.settingsDAO");
        JabberSettings jabberSettings = settingsDAO.getJabberSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)jabberSettings, (String)"api.settingsDAO.jabberSettings");
        return jabberSettings;
    }

    @NotNull
    public final JabberSSLContextFactory getSslContextFactory() {
        JabberSSLContextFactory jabberSSLContextFactory = this.sslContextFactory;
        if (jabberSSLContextFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sslContextFactory");
        }
        return jabberSSLContextFactory;
    }

    public final void setSslContextFactory(@NotNull JabberSSLContextFactory jabberSSLContextFactory) {
        Intrinsics.checkParameterIsNotNull((Object)jabberSSLContextFactory, (String)"<set-?>");
        this.sslContextFactory = jabberSSLContextFactory;
    }

    @Override
    public void send(@NotNull String jabber, @NotNull String message) throws NotificationException {
        Intrinsics.checkParameterIsNotNull((Object)jabber, (String)"jabber");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (!this.getJabberSettings().isEnabled().booleanValue()) {
            Companion.getLogger().info((Function0)send.1.INSTANCE);
            throw (Throwable)NotificationException.Companion.jabberDisabled();
        }
        if (this._debugMode && !this.debugModeJabber.contains(jabber)) {
            String errMsg = "Jabber " + jabber + " is not in the list of allowed jabbers " + this.debugModeJabber + '.';
            Companion.getLogger().info((Function0)new Function0<String>(errMsg, message){
                final /* synthetic */ String $errMsg;
                final /* synthetic */ String $message;

                @NotNull
                public final String invoke() {
                    return this.$errMsg + " Skip notification \"" + this.$message + '\"';
                }
                {
                    this.$errMsg = string;
                    this.$message = string2;
                    super(0);
                }
            });
            return;
        }
        this.openConnection((Function1<? super XMPPConnection, Unit>)((Function1)new Function1<XMPPConnection, Unit>(jabber, message){
            final /* synthetic */ String $jabber;
            final /* synthetic */ String $message;

            public final void invoke(@NotNull XMPPConnection connection) {
                Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
                try {
                    EntityBareJid bareJid = JidCreate.entityBareFrom((String)this.$jabber);
                    Chat chat = ChatManager.getInstanceFor((XMPPConnection)connection).chatWith(bareJid);
                    chat.send((CharSequence)this.$message);
                }
                catch (Exception e) {
                    throw (Throwable)NotificationException.Companion.jabberSendFailed(e);
                }
            }
            {
                this.$jabber = string;
                this.$message = string2;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void openConnection(Function1<? super XMPPConnection, Unit> body) {
        XMPPTCPConnectionConfiguration.Builder builder;
        XMPPTCPConnectionConfiguration.Builder $receiver = builder = XMPPTCPConnectionConfiguration.builder();
        $receiver.setUsernameAndPassword((CharSequence)this.getJabberSettings().getLogin(), this.getJabberSettings().getPassword());
        $receiver.setResource((CharSequence)("Hub-" + UUID.randomUUID()));
        $receiver.setHost(this.getJabberSettings().getHost());
        Integer n = this.getJabberSettings().getPort();
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"jabberSettings.port");
        $receiver.setPort(n.intValue());
        $receiver.setXmppDomain(this.getService());
        $receiver.setConnectTimeout(CONNECTION_TIMEOUT);
        JabberSSLContextFactory jabberSSLContextFactory = this.sslContextFactory;
        if (jabberSSLContextFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sslContextFactory");
        }
        $receiver.setCustomSSLContext(jabberSSLContextFactory.getContext());
        $receiver.setDebuggerFactory((SmackDebuggerFactory)JabberDebuggerFactory.INSTANCE);
        XMPPTCPConnectionConfiguration config = builder.build();
        XMPPTCPConnection connection = new XMPPTCPConnection(config);
        connection.connect();
        try {
            connection.login();
            body.invoke((Object)connection);
        }
        finally {
            connection.disconnect();
        }
    }

    private final String getService() {
        String serviceName = this.getJabberSettings().getServiceName();
        String string = serviceName;
        if (string == null) {
            String string2 = this.getJabberSettings().getHost();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jabberSettings.host");
        }
        return string;
    }

    public static final /* synthetic */ boolean access$get_debugMode$p(JabberNotificatorImpl $this) {
        return $this._debugMode;
    }

    public static final /* synthetic */ void access$set_debugMode$p(JabberNotificatorImpl $this, boolean bl) {
        $this._debugMode = bl;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Ljetbrains/jetpass/notification/JabberNotificatorImpl$JabberDebuggerFactory;", "Lorg/jivesoftware/smack/debugger/SmackDebuggerFactory;", "()V", "create", "Lorg/jivesoftware/smack/debugger/SmackDebugger;", "connection", "Lorg/jivesoftware/smack/XMPPConnection;", "jetbrains.jetpass.notification"})
    public static final class JabberDebuggerFactory
    implements SmackDebuggerFactory {
        public static final JabberDebuggerFactory INSTANCE;

        @NotNull
        public SmackDebugger create(@NotNull XMPPConnection connection) {
            Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
            return (SmackDebugger)new AbstractDebugger(connection, connection){
                final /* synthetic */ XMPPConnection $connection;

                protected void log(@NotNull String logMessage) {
                    Intrinsics.checkParameterIsNotNull((Object)logMessage, (String)"logMessage");
                    JabberNotificatorImpl.Companion.getLogger().debug((Function0)new Function0<String>(logMessage){
                        final /* synthetic */ String $logMessage;

                        @NotNull
                        public final String invoke() {
                            return this.$logMessage;
                        }
                        {
                            this.$logMessage = string;
                            super(0);
                        }
                    });
                }

                protected void log(@NotNull String logMessage, @NotNull Throwable throwable) {
                    Intrinsics.checkParameterIsNotNull((Object)logMessage, (String)"logMessage");
                    Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                    JabberNotificatorImpl.Companion.getLogger().debug(throwable, (Function0)new Function0<String>(logMessage){
                        final /* synthetic */ String $logMessage;

                        @NotNull
                        public final String invoke() {
                            return this.$logMessage;
                        }
                        {
                            this.$logMessage = string;
                            super(0);
                        }
                    });
                }
                {
                    this.$connection = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            };
        }

        private JabberDebuggerFactory() {
        }

        static {
            JabberDebuggerFactory jabberDebuggerFactory;
            INSTANCE = jabberDebuggerFactory = new JabberDebuggerFactory();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/notification/JabberNotificatorImpl$Companion;", "Lmu/KLogging;", "()V", "CONNECTION_TIMEOUT", "", "jetbrains.jetpass.notification"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

